/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.ethclient;

import io.vertx.core.Vertx;
import java.lang.invoke.LambdaMetafactory;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.tuweni.concurrent.AsyncCompletion;
import org.apache.tuweni.concurrent.coroutines.AsyncCompletionKt;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.devp2p.DiscoveryService;
import org.apache.tuweni.devp2p.EnodeUriKt;
import org.apache.tuweni.devp2p.eth.BlockchainInformation;
import org.apache.tuweni.devp2p.eth.ConnectionSelectionStrategy;
import org.apache.tuweni.devp2p.eth.EthRequestsManager;
import org.apache.tuweni.devp2p.eth.EthSubprotocol;
import org.apache.tuweni.devp2p.eth.SimpleBlockchainInformation;
import org.apache.tuweni.devp2p.eth.Status;
import org.apache.tuweni.devp2p.proxy.ProxyClient;
import org.apache.tuweni.devp2p.proxy.ProxySubprotocol;
import org.apache.tuweni.devp2p.proxy.TcpEndpoint;
import org.apache.tuweni.eth.Block;
import org.apache.tuweni.eth.Hash;
import org.apache.tuweni.eth.genesis.GenesisFile;
import org.apache.tuweni.eth.repository.BlockchainIndex;
import org.apache.tuweni.eth.repository.BlockchainRepository;
import org.apache.tuweni.eth.repository.MemoryTransactionPool;
import org.apache.tuweni.eth.repository.TransactionPool;
import org.apache.tuweni.ethclient.ConnectionManagementStrategy;
import org.apache.tuweni.ethclient.DNSClient;
import org.apache.tuweni.ethclient.DNSConfiguration;
import org.apache.tuweni.ethclient.DataStoreConfiguration;
import org.apache.tuweni.ethclient.DiscoveryConfiguration;
import org.apache.tuweni.ethclient.EthereumClient;
import org.apache.tuweni.ethclient.EthereumClientConfig;
import org.apache.tuweni.ethclient.EthereumPeerRepository;
import org.apache.tuweni.ethclient.FromBestBlockSynchronizer;
import org.apache.tuweni.ethclient.FromUnknownParentSynchronizer;
import org.apache.tuweni.ethclient.GenesisFileConfiguration;
import org.apache.tuweni.ethclient.MemoryEthereumPeerRepository;
import org.apache.tuweni.ethclient.PeerRepositoryConfiguration;
import org.apache.tuweni.ethclient.PeerStatusEthSynchronizer;
import org.apache.tuweni.ethclient.ProxyConfiguration;
import org.apache.tuweni.ethclient.RLPxServiceConfiguration;
import org.apache.tuweni.ethclient.StaticPeersConfiguration;
import org.apache.tuweni.ethclient.Synchronizer;
import org.apache.tuweni.ethclient.WireConnectionPeerRepositoryAdapter;
import org.apache.tuweni.kv.InfinispanKeyValueStore;
import org.apache.tuweni.kv.KeyValueStore;
import org.apache.tuweni.kv.LevelDBKeyValueStore;
import org.apache.tuweni.kv.MapKeyValueStore;
import org.apache.tuweni.kv.PersistenceMarshaller;
import org.apache.tuweni.metrics.MetricsService;
import org.apache.tuweni.peer.repository.Identity;
import org.apache.tuweni.rlpx.RLPxService;
import org.apache.tuweni.rlpx.WireConnectionRepository;
import org.apache.tuweni.rlpx.vertx.VertxRLPxService;
import org.apache.tuweni.rlpx.wire.SubProtocol;
import org.apache.tuweni.rlpx.wire.SubProtocolClient;
import org.apache.tuweni.rlpx.wire.WireConnection;
import org.apache.tuweni.units.bigints.UInt256;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.persistence.rocksdb.configuration.RocksDBStoreConfigurationBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 +2\u00020\u0001:\u0001+B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0011\u0010'\u001a\u00020(H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010)J\u0006\u0010*\u001a\u00020(R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000ej\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00130\u000ej\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0013`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0014\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00150\u000ej\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0015`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R-\u0010\u001b\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u001c0\u000ej\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u001c`\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR*\u0010\u001f\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020 0\u000ej\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020 `\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010!\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\"0\u000ej\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\"`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010#\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020$0\u000ej\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020$`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006,"}, d2={"Lorg/apache/tuweni/ethclient/EthereumClient;", "Lkotlinx/coroutines/CoroutineScope;", "vertx", "Lio/vertx/core/Vertx;", "config", "Lorg/apache/tuweni/ethclient/EthereumClientConfig;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "(Lio/vertx/core/Vertx;Lorg/apache/tuweni/ethclient/EthereumClientConfig;Lkotlin/coroutines/CoroutineContext;)V", "getConfig", "()Lorg/apache/tuweni/ethclient/EthereumClientConfig;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "discoveryServices", "Ljava/util/HashMap;", "", "Lorg/apache/tuweni/devp2p/DiscoveryService;", "Lkotlin/collections/HashMap;", "dnsClients", "Lorg/apache/tuweni/ethclient/DNSClient;", "genesisFiles", "Lorg/apache/tuweni/eth/genesis/GenesisFile;", "managerHandler", "", "Lorg/infinispan/manager/DefaultCacheManager;", "metricsService", "Lorg/apache/tuweni/metrics/MetricsService;", "peerRepositories", "Lorg/apache/tuweni/ethclient/EthereumPeerRepository;", "getPeerRepositories", "()Ljava/util/HashMap;", "services", "Lorg/apache/tuweni/rlpx/RLPxService;", "storageRepositories", "Lorg/apache/tuweni/eth/repository/BlockchainRepository;", "synchronizers", "Lorg/apache/tuweni/ethclient/Synchronizer;", "getVertx", "()Lio/vertx/core/Vertx;", "start", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "stop", "Companion", "eth-client"})
public final class EthereumClient
implements CoroutineScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Vertx vertx;
    @NotNull
    private final EthereumClientConfig config;
    @NotNull
    private final CoroutineContext coroutineContext;
    @Nullable
    private MetricsService metricsService;
    @NotNull
    private final HashMap<String, GenesisFile> genesisFiles;
    @NotNull
    private final HashMap<String, RLPxService> services;
    @NotNull
    private final HashMap<String, BlockchainRepository> storageRepositories;
    @NotNull
    private final HashMap<String, EthereumPeerRepository> peerRepositories;
    @NotNull
    private final HashMap<String, DNSClient> dnsClients;
    @NotNull
    private final HashMap<String, DiscoveryService> discoveryServices;
    @NotNull
    private final HashMap<String, Synchronizer> synchronizers;
    @NotNull
    private final List<DefaultCacheManager> managerHandler;
    private static final Logger logger = LoggerFactory.getLogger(EthereumClient.class);

    public EthereumClient(@NotNull Vertx vertx, @NotNull EthereumClientConfig config, @NotNull CoroutineContext coroutineContext) {
        Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        this.vertx = vertx;
        this.config = config;
        this.coroutineContext = coroutineContext;
        this.genesisFiles = new HashMap();
        this.services = new HashMap();
        this.storageRepositories = new HashMap();
        this.peerRepositories = new HashMap();
        this.dnsClients = new HashMap();
        this.discoveryServices = new HashMap();
        this.synchronizers = new HashMap();
        this.managerHandler = new ArrayList();
    }

    public /* synthetic */ EthereumClient(Vertx vertx, EthereumClientConfig ethereumClientConfig, CoroutineContext coroutineContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            coroutineContext = (CoroutineContext)Dispatchers.getUnconfined();
        }
        this(vertx, ethereumClientConfig, coroutineContext);
    }

    @NotNull
    public final Vertx getVertx() {
        return this.vertx;
    }

    @NotNull
    public final EthereumClientConfig getConfig() {
        return this.config;
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    @NotNull
    public final HashMap<String, EthereumPeerRepository> getPeerRepositories() {
        return this.peerRepositories;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final Object start(@NotNull Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof start.1)) ** GOTO lbl-1000
        var28_2 = var1_1;
        if ((var28_2.label & -2147483648) != 0) {
            var28_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                Object L$9;
                /* synthetic */ Object result;
                final /* synthetic */ EthereumClient this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.start((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var29_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                EthereumClient.logger.info("Starting Ethereum client...");
                var3_5 = this.getConfig().metricsPort();
                var4_7 = this.getConfig().metricsNetworkInterface();
                var5_10 = this.getConfig().metricsGrpcPushEnabled();
                var6_14 = this.getConfig().metricsPrometheusEnabled();
                this.metricsService = metricsService = new MetricsService("tuweni", 0L, var3_5, var4_7, var6_14 != false, var5_10 != false, null, 0L, 194, null);
                $this$forEach$iv = this.getConfig().peerRepositories();
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (PeerRepositoryConfiguration)element$iv;
                    $i$a$-forEach-EthereumClient$start$2 = false;
                    if (!Intrinsics.areEqual((Object)it.getType(), (Object)"memory")) {
                        throw (Throwable)new NotImplementedError(null, 1, null);
                    }
                    ((Map)this.getPeerRepositories()).put(it.getName(), new MemoryEthereumPeerRepository());
                }
                $this$forEach$iv = this.getConfig().genesisFiles();
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (GenesisFileConfiguration)element$iv;
                    $i$a$-forEach-EthereumClient$start$3 = false;
                    ((Map)this.genesisFiles).put(it.getName(), it.genesisFile());
                }
                repoToGenesisFile = new HashMap<K, V>();
                $this$forEach$iv = this.getConfig().dataStores();
                $i$f$forEach = false;
                element$iv = $this$forEach$iv.iterator();
lbl43:
                // 2 sources

                while (element$iv.hasNext()) {
                    element$iv /* !! */  = element$iv.next();
                    dataStore = (DataStoreConfiguration)element$iv /* !! */ ;
                    $i$a$-forEach-EthereumClient$start$4 = false;
                    v0 = genesisFile = this.genesisFiles.get(dataStore.getGenesisFile());
                    Intrinsics.checkNotNull((Object)v0);
                    genesisBlock = v0.toBlock();
                    dataStorage = dataStore.getStoragePath();
                    index = new NIOFSDirectory(dataStorage.resolve("index"));
                    analyzer = new StandardAnalyzer();
                    config /* !! */  = new IndexWriterConfig((Analyzer)analyzer);
                    writer = new IndexWriter((Directory)index, config /* !! */ );
                    builder /* !! */  = new GlobalConfigurationBuilder().serialization().marshaller((Marshaller)new PersistenceMarshaller());
                    manager = new DefaultCacheManager(builder /* !! */ .build());
                    this.managerHandler.add(manager);
                    var19_40 = manager.createCache("headers", ((RocksDBStoreConfigurationBuilder)new ConfigurationBuilder().persistence().addStore(RocksDBStoreConfigurationBuilder.class)).location(dataStorage.resolve("headers").toAbsolutePath().toString()).expiredLocation(dataStorage.resolve("headers-expired").toAbsolutePath().toString()).build());
                    Intrinsics.checkNotNullExpressionValue((Object)var19_40, (String)"manager.createCache(\n   \u2026String()).build()\n      )");
                    headersCache = var19_40;
                    var21_42 = dataStorage.resolve("bodies");
                    Intrinsics.checkNotNullExpressionValue((Object)var21_42, (String)"dataStorage.resolve(\"bodies\")");
                    v1 = (KeyValueStore)LevelDBKeyValueStore.Companion.open((Path)var21_42);
                    v2 = (KeyValueStore)InfinispanKeyValueStore.Companion.open(headersCache);
                    var21_42 = dataStorage.resolve("metadata");
                    Intrinsics.checkNotNullExpressionValue((Object)var21_42, (String)"dataStorage.resolve(\"metadata\")");
                    v3 = (KeyValueStore)LevelDBKeyValueStore.Companion.open((Path)var21_42);
                    var21_42 = dataStorage.resolve("transactionReceipts");
                    Intrinsics.checkNotNullExpressionValue((Object)var21_42, (String)"dataStorage.resolve(\"transactionReceipts\")");
                    v4 = (KeyValueStore)LevelDBKeyValueStore.Companion.open((Path)var21_42);
                    var21_42 = dataStorage.resolve("transactions");
                    Intrinsics.checkNotNullExpressionValue((Object)var21_42, (String)"dataStorage.resolve(\"transactions\")");
                    v5 = (KeyValueStore)LevelDBKeyValueStore.Companion.open((Path)var21_42);
                    var21_42 = dataStorage.resolve("state");
                    Intrinsics.checkNotNullExpressionValue((Object)var21_42, (String)"dataStorage.resolve(\"state\")");
                    v6 = (KeyValueStore)LevelDBKeyValueStore.Companion.open((Path)var21_42);
                    v7 = new BlockchainIndex(writer);
                    Intrinsics.checkNotNullExpressionValue((Object)genesisBlock, (String)"genesisBlock");
                    $continuation.L$0 = this;
                    $continuation.L$1 = metricsService;
                    $continuation.L$2 = repoToGenesisFile;
                    $continuation.L$3 = element$iv;
                    $continuation.L$4 = dataStore;
                    $continuation.L$5 = genesisFile;
                    $continuation.label = 1;
                    v8 = BlockchainRepository.Companion.init(v1, v2, v3, v4, v5, v6, v7, (Block)genesisBlock, metricsService.getMeterSdkProvider().get(dataStore.getName() + "_storage"), (Continuation)$continuation);
                    if (v8 == var29_4) {
                        return var29_4;
                    }
                    ** GOTO lbl103
                }
                break;
            }
            case 1: {
                $i$f$forEach = false;
                $i$a$-forEach-EthereumClient$start$4 = false;
                genesisFile = (GenesisFile)$continuation.L$5;
                dataStore = (DataStoreConfiguration)$continuation.L$4;
                element$iv = (Iterator)$continuation.L$3;
                repoToGenesisFile = (HashMap)$continuation.L$2;
                metricsService = (MetricsService)$continuation.L$1;
                this = (EthereumClient)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v8 = $result;
lbl103:
                // 2 sources

                repository /* !! */  = (BlockchainRepository)v8;
                var21_42 = this.storageRepositories;
                var22_43 = dataStore.getName();
                var21_42.put(var22_43, repository /* !! */ );
                ((Map)repoToGenesisFile).put(repository /* !! */ , genesisFile);
                ** GOTO lbl43
            }
        }
        $this$forEach$iv = this.getConfig().dnsClients();
        $i$f$forEach = false;
        element$iv = $this$forEach$iv.iterator();
lbl115:
        // 2 sources

        while (element$iv.hasNext()) {
            element$iv /* !! */  = element$iv.next();
            it = (DNSConfiguration)element$iv /* !! */ ;
            $i$a$-forEach-EthereumClient$start$5 = false;
            peerRepository = this.getPeerRepositories().get(it.peerRepository());
            if (peerRepository == null) {
                if (this.getPeerRepositories().isEmpty()) {
                    v9 = "none";
                } else {
                    genesisBlock = this.getPeerRepositories().keySet();
                    Intrinsics.checkNotNullExpressionValue(genesisBlock, (String)"peerRepositories.keys");
                    v9 = CollectionsKt.joinToString$default((Iterable)((Iterable)genesisBlock), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
                }
                message = v9 + " defined";
                throw new IllegalArgumentException("Repository " + peerRepository + " not found, " + message);
            }
            dnsClient = new DNSClient(it, (KeyValueStore<String, String>)((KeyValueStore)MapKeyValueStore.Companion.open()), peerRepository);
            genesisBlock = this.dnsClients;
            index = it.getName();
            genesisBlock.put(index, dnsClient);
            $continuation.L$0 = this;
            $continuation.L$1 = metricsService;
            $continuation.L$2 = repoToGenesisFile;
            $continuation.L$3 = element$iv;
            $continuation.L$4 = it;
            $continuation.L$5 = null;
            $continuation.label = 2;
            v10 = dnsClient.start((Continuation<? super Unit>)$continuation);
            if (v10 == var29_4) {
                return var29_4;
            }
            ** GOTO lbl156
        }
        {
            break;
            case 2: {
                $i$f$forEach = false;
                $i$a$-forEach-EthereumClient$start$5 = false;
                it = (DNSConfiguration)$continuation.L$4;
                element$iv = (Iterator<T>)$continuation.L$3;
                repoToGenesisFile = (HashMap<K, V>)$continuation.L$2;
                metricsService = (MetricsService)$continuation.L$1;
                this = (EthereumClient)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v10 = $result;
lbl156:
                // 2 sources

                EthereumClient.logger.info("Started DNS client " + it.getName() + " for " + it.enrLink());
                ** GOTO lbl115
            }
        }
        $this$forEach$iv = this.getConfig().discoveryServices();
        $i$f$forEach = false;
        for (E element$iv : $this$forEach$iv) {
            it = (DiscoveryConfiguration)element$iv /* !! */ ;
            $i$a$-forEach-EthereumClient$start$6 = false;
            peerRepository = this.getPeerRepositories().get(it.getPeerRepository());
            if (peerRepository == null) {
                if (this.getPeerRepositories().isEmpty()) {
                    v11 = "none";
                } else {
                    genesisBlock = this.getPeerRepositories().keySet();
                    Intrinsics.checkNotNullExpressionValue(genesisBlock, (String)"peerRepositories.keys");
                    v11 = CollectionsKt.joinToString$default((Iterable)((Iterable)genesisBlock), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
                }
                message = v11 + " defined";
                throw new IllegalArgumentException("Repository " + peerRepository + " not found, " + message);
            }
            discoveryService = DiscoveryService.Companion.open$default((DiscoveryService.Companion)DiscoveryService.Companion, (Vertx)this.getVertx(), (SECP256K1.KeyPair)it.getIdentity(), (int)it.getPort(), (String)it.getNetworkInterface(), (long)0L, null, null, null, null, null, null, null, null, null, (int)16368, null);
            genesisBlock = this.discoveryServices;
            index = it.getName();
            genesisBlock.put(index, discoveryService);
            EthereumClient.logger.info("Started discovery service " + it.getName());
        }
        $this$map$iv = this.getConfig().rlpxServices();
        $i$f$map = false;
        element$iv /* !! */  = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        var10_30 = $this$mapTo$iv$iv.iterator();
lbl188:
        // 2 sources

        while (var10_30.hasNext()) {
            item$iv$iv = var10_30.next();
            discoveryService = (RLPxServiceConfiguration)item$iv$iv;
            var26_47 = destination$iv$iv;
            $i$a$-map-EthereumClient$start$7 = false;
            EthereumClient.logger.info("Creating RLPx service " + rlpxConfig.getName());
            peerRepository = this.getPeerRepositories().get(rlpxConfig.peerRepository());
            if (peerRepository == null) {
                if (this.getPeerRepositories().isEmpty()) {
                    v12 = "none";
                } else {
                    config /* !! */  = this.getPeerRepositories().keySet();
                    Intrinsics.checkNotNullExpressionValue((Object)config /* !! */ , (String)"peerRepositories.keys");
                    v12 = CollectionsKt.joinToString$default((Iterable)((Iterable)config /* !! */ ), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
                }
                message = v12 + " defined";
                throw new IllegalArgumentException("Repository " + rlpxConfig.peerRepository() + " not found, " + message);
            }
            repository = this.storageRepositories.get(rlpxConfig.repository());
            if (repository == null) {
                if (this.storageRepositories.isEmpty()) {
                    v13 = "none";
                } else {
                    builder /* !! */  = this.storageRepositories.keySet();
                    Intrinsics.checkNotNullExpressionValue((Object)builder /* !! */ , (String)"storageRepositories.keys");
                    v13 = CollectionsKt.joinToString$default((Iterable)((Iterable)builder /* !! */ ), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
                }
                message = v13 + " defined";
                throw new IllegalArgumentException("Repository " + rlpxConfig.repository() + " not found, " + message);
            }
            genesisFile = (GenesisFile)repoToGenesisFile.get(repository);
            $continuation.L$0 = this;
            $continuation.L$1 = metricsService;
            $continuation.L$2 = repoToGenesisFile;
            $continuation.L$3 = destination$iv$iv;
            $continuation.L$4 = var10_30;
            $continuation.L$5 = rlpxConfig;
            $continuation.L$6 = peerRepository;
            $continuation.L$7 = genesisFile;
            $continuation.L$8 = repository;
            $continuation.L$9 = var26_47;
            $continuation.label = 3;
            v14 = repository.retrieveGenesisBlock((Continuation)$continuation);
            if (v14 == var29_4) {
                return var29_4;
            }
            ** GOTO lbl247
        }
        {
            break;
            case 3: {
                $i$f$map = false;
                $i$f$mapTo = false;
                $i$a$-map-EthereumClient$start$7 = false;
                var26_47 = (Collection<String>)$continuation.L$9;
                repository = (BlockchainRepository)$continuation.L$8;
                genesisFile = (GenesisFile)$continuation.L$7;
                peerRepository = (EthereumPeerRepository)$continuation.L$6;
                rlpxConfig = (RLPxServiceConfiguration)$continuation.L$5;
                var10_30 = (Iterator)$continuation.L$4;
                destination$iv$iv = (Set<String>)$continuation.L$3;
                repoToGenesisFile = (HashMap)$continuation.L$2;
                metricsService = (MetricsService)$continuation.L$1;
                this = (EthereumClient)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v14 = $result;
lbl247:
                // 2 sources

                genesisBlock = (Block)v14;
                adapter = new WireConnectionPeerRepositoryAdapter(peerRepository);
                v15 = genesisFile;
                Intrinsics.checkNotNull((Object)v15);
                repository /* !! */  = UInt256.valueOf((long)v15.getChainId());
                Intrinsics.checkNotNullExpressionValue((Object)repository /* !! */ , (String)"valueOf(genesisFile!!.chainId.toLong())");
                v16 = repository /* !! */ ;
                repository /* !! */  = genesisBlock.getHeader().getDifficulty();
                Intrinsics.checkNotNullExpressionValue((Object)repository /* !! */ , (String)"genesisBlock.header.difficulty");
                v17 = repository /* !! */ ;
                repository /* !! */  = genesisBlock.getHeader().getHash();
                Intrinsics.checkNotNullExpressionValue((Object)repository /* !! */ , (String)"genesisBlock.header.hash");
                v18 = repository /* !! */ ;
                repository /* !! */  = genesisBlock.getHeader().getNumber();
                Intrinsics.checkNotNullExpressionValue((Object)repository /* !! */ , (String)"genesisBlock.header.number");
                v19 = repository /* !! */ ;
                repository /* !! */  = genesisBlock.getHeader().getHash();
                Intrinsics.checkNotNullExpressionValue((Object)repository /* !! */ , (String)"genesisBlock.header.hash");
                v20 = repository /* !! */ ;
                repository /* !! */  = genesisFile.getForks();
                Intrinsics.checkNotNullExpressionValue((Object)repository /* !! */ , (String)"genesisFile.forks");
                blockchainInfo = new SimpleBlockchainInformation((UInt256)v16, (UInt256)v17, (Hash)v18, (UInt256)v19, (Hash)v20, (List)repository /* !! */ );
                EthereumClient.logger.info("Initializing with blockchain information " + blockchainInfo);
                var21_42 = new MemoryTransactionPool();
                var22_43 = (KFunction)new Function2<WireConnection, Status, Unit>((Object)adapter){

                    public final void invoke(@NotNull WireConnection p0, @NotNull Status p1) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        ((WireConnectionPeerRepositoryAdapter)this.receiver).listenToStatus(p0, p1);
                    }
                };
                ethSubprotocol = new EthSubprotocol(null, (BlockchainInformation)blockchainInfo, repository, (TransactionPool)var21_42, (Function1)new Function1<WireConnectionRepository, ConnectionSelectionStrategy>(adapter){
                    final /* synthetic */ WireConnectionPeerRepositoryAdapter $adapter;
                    {
                        this.$adapter = $adapter;
                        super(1);
                    }

                    @NotNull
                    public final ConnectionSelectionStrategy invoke(@NotNull WireConnectionRepository it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return new ConnectionManagementStrategy(0, this.$adapter, 1, null);
                    }
                }, (Function2)var22_43, 1, null);
                meter = metricsService.getMeterSdkProvider().get(rlpxConfig.getName() + "_rlpx");
                proxySubprotocol = new ProxySubprotocol();
                var23_44 = new SubProtocol[]{(SubProtocol)ethSubprotocol, (SubProtocol)proxySubprotocol};
                service = new VertxRLPxService(this.getVertx(), rlpxConfig.port(), rlpxConfig.networkInterface(), rlpxConfig.advertisedPort(), rlpxConfig.keyPair(), CollectionsKt.listOf((Object[])var23_44), rlpxConfig.clientName(), meter, (WireConnectionRepository)adapter);
                var23_44 = this.services;
                var25_46 = rlpxConfig.getName();
                var23_44.put(var25_46, service);
                var26_47.add((String)service.start().thenRun((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, start$lambda-6$lambda-5(org.apache.tuweni.ethclient.RLPxServiceConfiguration org.apache.tuweni.rlpx.vertx.VertxRLPxService org.apache.tuweni.ethclient.EthereumClient org.apache.tuweni.ethclient.EthereumPeerRepository org.apache.tuweni.eth.repository.BlockchainRepository org.apache.tuweni.ethclient.WireConnectionPeerRepositoryAdapter ), ()V)((RLPxServiceConfiguration)rlpxConfig, (VertxRLPxService)service, (EthereumClient)this, (EthereumPeerRepository)peerRepository, (BlockchainRepository)repository, (WireConnectionPeerRepositoryAdapter)adapter)));
                ** GOTO lbl188
            }
        }
        var4_9 = AsyncCompletion.allOf((Collection)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)var4_9, (String)"allOf(\n      config.rlpx\u2026)\n        }\n      }\n    )");
        $continuation.L$0 = this;
        $continuation.L$1 = null;
        $continuation.L$2 = null;
        $continuation.L$3 = null;
        $continuation.L$4 = null;
        $continuation.L$5 = null;
        $continuation.L$6 = null;
        $continuation.L$7 = null;
        $continuation.L$8 = null;
        $continuation.L$9 = null;
        $continuation.label = 4;
        v21 = AsyncCompletionKt.await((AsyncCompletion)var4_9, (Continuation)$continuation);
        if (v21 == var29_4) {
            return var29_4;
        }
        ** GOTO lbl305
        {
            case 4: {
                this = (EthereumClient)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v21 = $result;
lbl305:
                // 3 sources

                for (StaticPeersConfiguration staticPeers : this.getConfig().staticPeers()) {
                    peerRepository = this.getPeerRepositories().get(staticPeers.peerRepository());
                    if (peerRepository == null) {
                        if (this.getPeerRepositories().isEmpty()) {
                            v22 = "none";
                        } else {
                            destination$iv$iv = this.getPeerRepositories().keySet();
                            Intrinsics.checkNotNullExpressionValue(destination$iv$iv, (String)"peerRepositories.keys");
                            v22 = CollectionsKt.joinToString$default((Iterable)destination$iv$iv, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
                        }
                        message = v22 + " defined";
                        throw new IllegalArgumentException("Repository " + staticPeers.peerRepository() + " not found, " + message);
                    }
                    for (String enode : staticPeers.enodes()) {
                        var10_30 = URI.create(enode);
                        Intrinsics.checkNotNullExpressionValue((Object)var10_30, (String)"create(enode)");
                        uri = EnodeUriKt.parseEnodeUri((URI)var10_30);
                        v23 = uri.getEndpoint().getTcpPort();
                        peerRepository.storeIdentity(uri.getEndpoint().getAddress(), v23 == null ? uri.getEndpoint().getUdpPort() : v23.intValue(), uri.getNodeId());
                    }
                }
                Runtime.getRuntime().addShutdownHook(new Thread(this){
                    final /* synthetic */ EthereumClient this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void run() {
                        this.this$0.stop();
                    }
                });
                EthereumClient.logger.info("Started Ethereum client");
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void stop() {
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ EthereumClient this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var13_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var2_3 = EthereumClient.access$getDnsClients$p(this.this$0).values();
                        Intrinsics.checkNotNullExpressionValue(var2_3, (String)"dnsClients.values");
                        $this$forEach$iv = var2_3;
                        $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            p0 = (DNSClient)element$iv;
                            $i$a$-forEach-EthereumClient$stop$1$1 = false;
                            p0.stop();
                        }
                        $i$f$forEach = EthereumClient.access$getDiscoveryServices$p(this.this$0).values();
                        Intrinsics.checkNotNullExpressionValue($i$f$forEach, (String)"discoveryServices.values");
                        $this$map$iv = $i$f$forEach;
                        $i$f$map = false;
                        element$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            var10_19 = (DiscoveryService)item$iv$iv;
                            var12_21 = destination$iv$iv;
                            $i$a$-map-EthereumClient$stop$1$2 = false;
                            var12_21.add(p0.shutdownAsync());
                        }
                        $this$forEach$iv = AsyncCompletion.allOf((Collection)((List)destination$iv$iv));
                        Intrinsics.checkNotNullExpressionValue($this$forEach$iv, (String)"allOf(discoveryServices.\u2026yService::shutdownAsync))");
                        this.label = 1;
                        v0 = AsyncCompletionKt.await($this$forEach$iv, (Continuation)((Continuation)this));
                        if (v0 == var13_2) {
                            return var13_2;
                        }
                        ** GOTO lbl38
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl38:
                        // 2 sources

                        $this$forEach$iv = EthereumClient.access$getSynchronizers$p(this.this$0).values();
                        Intrinsics.checkNotNullExpressionValue($this$forEach$iv, (String)"synchronizers.values");
                        $this$forEach$iv = $this$forEach$iv;
                        $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            it = (Synchronizer)element$iv;
                            $i$a$-forEach-EthereumClient$stop$1$3 = false;
                            it.stop();
                        }
                        $this$forEach$iv = EthereumClient.access$getManagerHandler$p(this.this$0);
                        $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            it = (DefaultCacheManager)element$iv;
                            $i$a$-forEach-EthereumClient$stop$1$4 = false;
                            it.stop();
                        }
                        $i$f$forEach = EthereumClient.access$getServices$p(this.this$0).values();
                        Intrinsics.checkNotNullExpressionValue($i$f$forEach, (String)"services.values");
                        $this$map$iv = $i$f$forEach;
                        $i$f$map = false;
                        element$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            p0 = (RLPxService)item$iv$iv;
                            var12_21 = destination$iv$iv;
                            $i$a$-map-EthereumClient$stop$1$5 = false;
                            var12_21.add(p0.stop());
                        }
                        $this$forEach$iv = AsyncCompletion.allOf((Collection)((List)destination$iv$iv));
                        Intrinsics.checkNotNullExpressionValue($this$forEach$iv, (String)"allOf(services.values.map(RLPxService::stop))");
                        this.label = 2;
                        v1 = AsyncCompletionKt.await($this$forEach$iv, (Continuation)((Continuation)this));
                        if (v1 == var13_2) {
                            return var13_2;
                        }
                        ** GOTO lbl80
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl80:
                        // 2 sources

                        $this$forEach$iv = EthereumClient.access$getStorageRepositories$p(this.this$0).values();
                        Intrinsics.checkNotNullExpressionValue($this$forEach$iv, (String)"storageRepositories.values");
                        $this$forEach$iv = $this$forEach$iv;
                        $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            p0 = (BlockchainRepository)element$iv;
                            $i$a$-forEach-EthereumClient$stop$1$6 = false;
                            p0.close();
                        }
                        v2 = EthereumClient.access$getMetricsService$p(this.this$0);
                        if (v2 != null) {
                            v2.close();
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private static final void start$lambda-6$lambda-5(RLPxServiceConfiguration $rlpxConfig, VertxRLPxService $service, EthereumClient this$0, EthereumPeerRepository $peerRepository, BlockchainRepository $repository, WireConnectionPeerRepositoryAdapter $adapter) {
        Object object;
        Object uri;
        Intrinsics.checkNotNullParameter((Object)$rlpxConfig, (String)"$rlpxConfig");
        Intrinsics.checkNotNullParameter((Object)$service, (String)"$service");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$adapter, (String)"$adapter");
        logger.info("Started Ethereum client " + $rlpxConfig.getName());
        SubProtocolClient subProtocolClient = $service.getClient(ProxySubprotocol.Companion.getID());
        if (subProtocolClient == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.apache.tuweni.devp2p.proxy.ProxyClient");
        }
        ProxyClient proxyClient = (ProxyClient)subProtocolClient;
        for (ProxyConfiguration proxyConfiguration : this$0.config.proxies()) {
            uri = URI.create(proxyConfiguration.upstream());
            Vertx vertx = this$0.vertx;
            object = ((URI)uri).getHost();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"uri.host");
            TcpEndpoint target = new TcpEndpoint(vertx, (String)object, ((URI)uri).getPort(), null, 8, null);
            target.start();
            object = proxyClient.getRegisteredSites();
            String string = proxyConfiguration.name();
            object.put(string, target);
        }
        $peerRepository.addIdentityListener((Function1<? super Identity, Unit>)((Function1)new Function1<Identity, Unit>($service){
            final /* synthetic */ VertxRLPxService $service;
            {
                this.$service = $service;
                super(1);
            }

            public final void invoke(@NotNull Identity it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$service.connectTo(it.publicKey(), new InetSocketAddress(it.networkInterface(), it.port()));
            }
        }));
        SubProtocolClient subProtocolClient2 = $service.getClient(EthSubprotocol.Companion.getETH66());
        if (subProtocolClient2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.apache.tuweni.devp2p.eth.EthRequestsManager");
        }
        PeerStatusEthSynchronizer synchronizer = new PeerStatusEthSynchronizer(null, null, $repository, (EthRequestsManager)subProtocolClient2, $peerRepository, $adapter, 3, null);
        Map map = this$0.synchronizers;
        uri = $rlpxConfig.getName() + "status";
        map.put(uri, synchronizer);
        synchronizer.start();
        SubProtocolClient subProtocolClient3 = $service.getClient(EthSubprotocol.Companion.getETH66());
        if (subProtocolClient3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.apache.tuweni.devp2p.eth.EthRequestsManager");
        }
        FromUnknownParentSynchronizer fromUnknownParentSynchronizer = new FromUnknownParentSynchronizer(null, null, $repository, (EthRequestsManager)subProtocolClient3, $peerRepository, 3, null);
        uri = this$0.synchronizers;
        Object object2 = $rlpxConfig.getName() + "parent";
        uri.put(object2, fromUnknownParentSynchronizer);
        fromUnknownParentSynchronizer.start();
        SubProtocolClient subProtocolClient4 = $service.getClient(EthSubprotocol.Companion.getETH66());
        if (subProtocolClient4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.apache.tuweni.devp2p.eth.EthRequestsManager");
        }
        FromBestBlockSynchronizer bestSynchronizer = new FromBestBlockSynchronizer(null, null, $repository, (EthRequestsManager)subProtocolClient4, $peerRepository, 3, null);
        object2 = this$0.synchronizers;
        object = $rlpxConfig.getName() + "best";
        object2.put(object, bestSynchronizer);
        bestSynchronizer.start();
    }

    public static final /* synthetic */ HashMap access$getDnsClients$p(EthereumClient $this) {
        return $this.dnsClients;
    }

    public static final /* synthetic */ HashMap access$getDiscoveryServices$p(EthereumClient $this) {
        return $this.discoveryServices;
    }

    public static final /* synthetic */ HashMap access$getSynchronizers$p(EthereumClient $this) {
        return $this.synchronizers;
    }

    public static final /* synthetic */ List access$getManagerHandler$p(EthereumClient $this) {
        return $this.managerHandler;
    }

    public static final /* synthetic */ HashMap access$getServices$p(EthereumClient $this) {
        return $this.services;
    }

    public static final /* synthetic */ HashMap access$getStorageRepositories$p(EthereumClient $this) {
        return $this.storageRepositories;
    }

    public static final /* synthetic */ MetricsService access$getMetricsService$p(EthereumClient $this) {
        return $this.metricsService;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/apache/tuweni/ethclient/EthereumClient$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/slf4j/Logger;", "eth-client"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

