/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.config;

import com.google.common.base.Strings;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.tuweni.config.ConfigurationError;
import org.apache.tuweni.config.ConfigurationErrors;
import org.apache.tuweni.config.DocumentPosition;
import org.apache.tuweni.config.PropertyValidators;

public interface PropertyValidator<T> {
    public static <T> PropertyValidator<T> combine(PropertyValidator<? super T> first, PropertyValidator<? super T> second) {
        return PropertyValidator.combine(Arrays.asList(first, second));
    }

    public static <T> PropertyValidator<T> combine(List<PropertyValidator<? super T>> validators) {
        return (key, position, value) -> validators.stream().flatMap(validator -> validator.validate(key, position, value).stream()).collect(Collectors.toList());
    }

    public static <T> PropertyValidator<List<T>> allInList(PropertyValidator<? super T> validator) {
        return (key, position, value) -> {
            if (value != null) {
                return value.stream().flatMap(elem -> validator.validate(key, position, elem).stream()).collect(Collectors.toList());
            }
            return ConfigurationErrors.noErrors();
        };
    }

    public static PropertyValidator<Object> isPresent() {
        return PropertyValidators.IS_PRESENT;
    }

    public static PropertyValidator<Number> inRange(long from, long to) {
        return (key, position, value) -> {
            if (value != null && (value.longValue() < from || value.longValue() >= to)) {
                return ConfigurationErrors.singleError(position, "Value of property '" + key + "' is outside range [" + from + "," + to + ")");
            }
            return ConfigurationErrors.noErrors();
        };
    }

    public static PropertyValidator<String> anyOf(String ... values) {
        return PropertyValidator.anyOf(Arrays.asList(values), String::compareTo);
    }

    public static PropertyValidator<String> anyOf(Collection<String> values) {
        return PropertyValidator.anyOf(values, String::compareTo);
    }

    public static PropertyValidator<String> anyOfIgnoreCase(String ... values) {
        return PropertyValidator.anyOf(Arrays.asList(values), String::compareToIgnoreCase);
    }

    public static PropertyValidator<String> anyOfIgnoreCase(Collection<String> values) {
        return PropertyValidator.anyOf(values, String::compareToIgnoreCase);
    }

    public static PropertyValidator<String> anyOf(Collection<String> values, Comparator<String> comparator) {
        StringBuilder builder = new StringBuilder();
        int count = values.size();
        int i = 0;
        for (String value2 : values) {
            builder.append('\"');
            builder.append(value2);
            builder.append('\"');
            if (i < count - 2) {
                builder.append(", ");
            } else if (i == count - 2) {
                if (count >= 3) {
                    builder.append(',');
                }
                builder.append(" or ");
            }
            ++i;
        }
        String expected = builder.toString();
        return (key, position, value) -> {
            if (value != null && values.stream().noneMatch(p -> comparator.compare((String)p, (String)value) == 0)) {
                return ConfigurationErrors.singleError(position, "Value of property '" + key + "' should be " + expected);
            }
            return ConfigurationErrors.noErrors();
        };
    }

    public static PropertyValidator<String> isURL() {
        return (key, position, value) -> {
            if (value != null) {
                try {
                    new URL((String)value);
                }
                catch (MalformedURLException e) {
                    return ConfigurationErrors.singleError(position, "Value of property '" + key + "' is not a valid URL", e);
                }
            }
            return ConfigurationErrors.noErrors();
        };
    }

    public static PropertyValidator<Integer> isValidPortOrZero() {
        return (key, position, value) -> {
            if (value != null && (value < 0 || value > 65535)) {
                return ConfigurationErrors.singleError(position, "Value of property '" + key + "' is not a valid port");
            }
            return ConfigurationErrors.noErrors();
        };
    }

    public static PropertyValidator<Integer> isValidPort() {
        return (key, position, value) -> {
            if (value != null && (value <= 0 || value > 65535)) {
                return ConfigurationErrors.singleError(position, "Value of property '" + key + "' is not a valid port");
            }
            return ConfigurationErrors.noErrors();
        };
    }

    public static PropertyValidator<String> isNotBlank() {
        return (key, position, value) -> {
            if (value != null && !Strings.isNullOrEmpty((String)value)) {
                return ConfigurationErrors.singleError(position, "Value of property '" + key + "' is blank");
            }
            return ConfigurationErrors.noErrors();
        };
    }

    public List<ConfigurationError> validate(String var1, @Nullable DocumentPosition var2, @Nullable T var3);
}

