/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.eth.crawler;

import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.LongValueRecorder;
import io.opentelemetry.api.metrics.Meter;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.concurrent.AsyncResult;
import org.apache.tuweni.concurrent.ExpiringMap;
import org.apache.tuweni.concurrent.coroutines.AsyncResultKt;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.devp2p.Endpoint;
import org.apache.tuweni.devp2p.EnodeUriComponents;
import org.apache.tuweni.devp2p.EnodeUriKt;
import org.apache.tuweni.devp2p.Peer;
import org.apache.tuweni.devp2p.PeerRepository;
import org.apache.tuweni.devp2p.eth.Status;
import org.apache.tuweni.eth.crawler.ClientInfo;
import org.apache.tuweni.eth.crawler.ClientReadyStats;
import org.apache.tuweni.eth.crawler.PeerConnectionInfo;
import org.apache.tuweni.eth.crawler.PeerConnectionInfoDetails;
import org.apache.tuweni.eth.crawler.RelationalPeerRepository;
import org.apache.tuweni.eth.crawler.RepositoryPeer;
import org.apache.tuweni.eth.crawler.UpgradeConfig;
import org.apache.tuweni.eth.crawler.rest.ClientIdInfo;
import org.apache.tuweni.rlpx.wire.HelloMessage;
import org.apache.tuweni.rlpx.wire.WireConnection;
import org.apache.tuweni.units.bigints.UInt256;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 X2\u00020\u00012\u00020\u0002:\u0001XBM\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u001c\u0010*\u001a\u00020\u001f2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001dH\u0016J\u0019\u0010,\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020.H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010/J)\u0010,\u001a\u00020\u001e2\u0006\u00100\u001a\u00020\u00182\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\"H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00104J\u0016\u0010,\u001a\u00020\u001e2\u0006\u00103\u001a\u00020\"2\u0006\u00105\u001a\u000206J\u0016\u00107\u001a\b\u0012\u0004\u0012\u00020\u001e082\u0006\u0010-\u001a\u00020.H\u0016J\u0016\u00107\u001a\b\u0012\u0004\u0012\u00020\u001e082\u0006\u0010-\u001a\u00020\u0018H\u0016J\u0013\u00109\u001a\b\u0012\u0004\u0012\u00020\u00150\fH\u0000\u00a2\u0006\u0002\b:J\u0013\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00150\fH\u0000\u00a2\u0006\u0002\b<J%\u0010=\u001a\u001a\u0012\u0004\u0012\u00020\u0018\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00060\u00170\u0017H\u0000\u00a2\u0006\u0002\b>J\u001f\u0010?\u001a\u0004\u0018\u00010@2\u0006\u0010A\u001a\u00020\u00062\u0006\u0010B\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\bCJ5\u0010D\u001a\b\u0012\u0004\u0012\u00020E0\f2\u0006\u0010A\u001a\u00020\u00062\n\b\u0002\u0010F\u001a\u0004\u0018\u0001022\n\b\u0002\u0010G\u001a\u0004\u0018\u000102H\u0000\u00a2\u0006\u0004\bH\u0010IJ5\u0010J\u001a\b\u0012\u0004\u0012\u00020@0\f2\u0006\u0010A\u001a\u00020\u00062\n\b\u0002\u0010F\u001a\u0004\u0018\u0001022\n\b\u0002\u0010G\u001a\u0004\u0018\u000102H\u0000\u00a2\u0006\u0004\bK\u0010IJ'\u0010L\u001a\b\u0012\u0004\u0012\u00020E0\f2\b\b\u0002\u0010F\u001a\u0002022\b\b\u0002\u0010G\u001a\u000202H\u0000\u00a2\u0006\u0002\bMJ\u0019\u0010N\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020)0(H\u0000\u00a2\u0006\u0002\bOJ\u0018\u0010P\u001a\u00020\u001f2\u0006\u0010Q\u001a\u00020R2\b\u0010S\u001a\u0004\u0018\u00010TJ\u0006\u0010U\u001a\u00020\u001fJ\u0011\u0010V\u001a\u00020\u001fH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010WR\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0016\u001a\u001c\u0012\u0004\u0012\u00020\u0018\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00060\u0017\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00180!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010%\u001a\n \u0013*\u0004\u0018\u00010&0&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020)0(X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006Y"}, d2={"Lorg/apache/tuweni/eth/crawler/RelationalPeerRepository;", "Lkotlinx/coroutines/CoroutineScope;", "Lorg/apache/tuweni/devp2p/PeerRepository;", "dataSource", "Ljavax/sql/DataSource;", "expiration", "", "clientIdsInterval", "clientsStatsDelay", "meter", "Lio/opentelemetry/api/metrics/Meter;", "upgradeConfigs", "", "Lorg/apache/tuweni/eth/crawler/UpgradeConfig;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "(Ljavax/sql/DataSource;JJJLio/opentelemetry/api/metrics/Meter;Ljava/util/List;Lkotlin/coroutines/CoroutineContext;)V", "clientCalculationsCounter", "Lio/opentelemetry/api/metrics/LongCounter;", "kotlin.jvm.PlatformType", "clientIds", "Lorg/apache/tuweni/eth/crawler/ClientInfo;", "clientsStats", "", "", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "listeners", "", "Lkotlin/Function1;", "Lorg/apache/tuweni/devp2p/Peer;", "", "peerCache", "Lorg/apache/tuweni/concurrent/ExpiringMap;", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "started", "Ljava/util/concurrent/atomic/AtomicBoolean;", "totalClientsGauge", "Lio/opentelemetry/api/metrics/LongValueRecorder;", "upgradeStats", "", "Lorg/apache/tuweni/eth/crawler/ClientReadyStats;", "addListener", "listener", "get", "uri", "Ljava/net/URI;", "(Ljava/net/URI;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "host", "port", "", "nodeId", "(Ljava/lang/String;ILorg/apache/tuweni/crypto/SECP256K1$PublicKey;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "endpoint", "Lorg/apache/tuweni/devp2p/Endpoint;", "getAsync", "Lorg/apache/tuweni/concurrent/AsyncResult;", "getClientIds", "getClientIds$eth_crawler", "getClientIdsInternal", "getClientIdsInternal$eth_crawler", "getClientStats", "getClientStats$eth_crawler", "getPeerWithInfo", "Lorg/apache/tuweni/eth/crawler/PeerConnectionInfoDetails;", "infoCollected", "publicKey", "getPeerWithInfo$eth_crawler", "getPeers", "Lorg/apache/tuweni/eth/crawler/PeerConnectionInfo;", "from", "limit", "getPeers$eth_crawler", "(JLjava/lang/Integer;Ljava/lang/Integer;)Ljava/util/List;", "getPeersWithInfo", "getPeersWithInfo$eth_crawler", "getPendingPeers", "getPendingPeers$eth_crawler", "getUpgradeStats", "getUpgradeStats$eth_crawler", "recordInfo", "wireConnection", "Lorg/apache/tuweni/rlpx/wire/WireConnection;", "status", "Lorg/apache/tuweni/devp2p/eth/Status;", "start", "stop", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "eth-crawler"})
public class RelationalPeerRepository
implements CoroutineScope,
PeerRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataSource dataSource;
    private final long expiration;
    private final long clientIdsInterval;
    private final long clientsStatsDelay;
    @NotNull
    private final Meter meter;
    @NotNull
    private final List<UpgradeConfig> upgradeConfigs;
    @NotNull
    private final CoroutineContext coroutineContext;
    @NotNull
    private final List<Function1<Peer, Unit>> listeners;
    @NotNull
    private final ExpiringMap<SECP256K1.PublicKey, String> peerCache;
    private final LongValueRecorder totalClientsGauge;
    private final LongCounter clientCalculationsCounter;
    @Nullable
    private List<ClientInfo> clientIds;
    @Nullable
    private Map<String, ? extends Map<String, Long>> clientsStats;
    @NotNull
    private Map<String, ClientReadyStats> upgradeStats;
    @NotNull
    private final AtomicBoolean started;
    private static final Logger logger = LoggerFactory.getLogger(RelationalPeerRepository.class);

    public RelationalPeerRepository(@NotNull DataSource dataSource, long expiration, long clientIdsInterval, long clientsStatsDelay, @NotNull Meter meter, @NotNull List<UpgradeConfig> upgradeConfigs, @NotNull CoroutineContext coroutineContext) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)meter, (String)"meter");
        Intrinsics.checkNotNullParameter(upgradeConfigs, (String)"upgradeConfigs");
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        this.dataSource = dataSource;
        this.expiration = expiration;
        this.clientIdsInterval = clientIdsInterval;
        this.clientsStatsDelay = clientsStatsDelay;
        this.meter = meter;
        this.upgradeConfigs = upgradeConfigs;
        this.coroutineContext = coroutineContext;
        this.listeners = new ArrayList();
        this.peerCache = new ExpiringMap();
        this.totalClientsGauge = this.meter.longValueRecorderBuilder("totalClients").setDescription("Number of nodes used to compute client stats").build();
        this.clientCalculationsCounter = this.meter.longCounterBuilder("clients").setDescription("Number of times clients were computed").build();
        this.upgradeStats = new LinkedHashMap();
        this.started = new AtomicBoolean(false);
    }

    public /* synthetic */ RelationalPeerRepository(DataSource dataSource, long l, long l2, long l3, Meter meter, List list, CoroutineContext coroutineContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = 300000L;
        }
        if ((n & 4) != 0) {
            l2 = 172800000L;
        }
        if ((n & 8) != 0) {
            l3 = 30000L;
        }
        if ((n & 0x20) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x40) != 0) {
            coroutineContext = (CoroutineContext)Dispatchers.getDefault();
        }
        this(dataSource, l, l2, l3, meter, list, coroutineContext);
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    public void addListener(@NotNull Function1<? super Peer, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.listeners.add(listener);
    }

    @Nullable
    public Object get(@NotNull String host, int port, @NotNull SECP256K1.PublicKey nodeId, @NotNull Continuation<? super Peer> $completion) {
        return this.get(nodeId, new Endpoint(host, port, null, 4, null));
    }

    @NotNull
    public final Peer get(@NotNull SECP256K1.PublicKey nodeId, @NotNull Endpoint endpoint) {
        Intrinsics.checkNotNullParameter((Object)nodeId, (String)"nodeId");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        String id = (String)this.peerCache.computeIfAbsent((Object)nodeId, this.expiration, arg_0 -> RelationalPeerRepository.get$lambda-2(this, nodeId, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)id, (String)"id");
        return new RepositoryPeer(nodeId, id, endpoint, this.dataSource);
    }

    @Nullable
    public Object get(@NotNull URI uri, @NotNull Continuation<? super Peer> $completion) {
        return RelationalPeerRepository.get$suspendImpl(this, uri, $completion);
    }

    static /* synthetic */ Object get$suspendImpl(RelationalPeerRepository this_, URI uri, Continuation $completion) {
        EnodeUriComponents enodeUriComponents = EnodeUriKt.parseEnodeUri((URI)uri);
        SECP256K1.PublicKey nodeId = enodeUriComponents.component1();
        Endpoint endpoint = enodeUriComponents.component2();
        return this_.get(nodeId, endpoint);
    }

    @NotNull
    public AsyncResult<Peer> getAsync(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return AsyncResultKt.asyncResult$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Peer>, Object>(this, uri, null){
            int label;
            final /* synthetic */ RelationalPeerRepository this$0;
            final /* synthetic */ URI $uri;
            {
                this.this$0 = $receiver;
                this.$uri = $uri;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.get(this.$uri, (Continuation<? super Peer>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Peer> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public AsyncResult<Peer> getAsync(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return AsyncResultKt.asyncResult$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Peer>, Object>(this, uri, null){
            int label;
            final /* synthetic */ RelationalPeerRepository this$0;
            final /* synthetic */ String $uri;
            {
                this.this$0 = $receiver;
                this.$uri = $uri;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.get(this.$uri, (Continuation<? super Peer>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Peer> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void recordInfo(@NotNull WireConnection wireConnection, @Nullable Status status) {
        Intrinsics.checkNotNullParameter((Object)wireConnection, (String)"wireConnection");
        AutoCloseable autoCloseable = this.dataSource.getConnection();
        Throwable throwable = null;
        try {
            boolean bl;
            Connection conn = (Connection)autoCloseable;
            boolean bl2 = false;
            Object object = wireConnection.peerPublicKey();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"wireConnection.peerPublicKey()");
            SECP256K1.PublicKey publicKey = object;
            object = wireConnection.peerHost();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"wireConnection.peerHost()");
            RepositoryPeer peer = (RepositoryPeer)this.get(publicKey, new Endpoint((String)object, wireConnection.peerPort(), null, 4, null));
            PreparedStatement stmt = conn.prepareStatement("insert into nodeInfo(id, createdAt, host, port, publickey, p2pVersion, clientId, capabilities, genesisHash, bestHash, totalDifficulty, identity, disconnectReason) values(?,?,?,?,?,?,?,?,?,?,?,?,?)");
            AutoCloseable autoCloseable2 = stmt;
            Throwable throwable2 = null;
            try {
                String string;
                String string2;
                String string3;
                String string4;
                String string5;
                int n;
                PreparedStatement it = (PreparedStatement)autoCloseable2;
                boolean bl3 = false;
                HelloMessage peerHello = wireConnection.getPeerHello();
                it.setString(1, UUID.randomUUID().toString());
                it.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                it.setString(3, wireConnection.peerHost());
                it.setInt(4, wireConnection.peerPort());
                it.setBytes(5, wireConnection.peerPublicKey().bytesArray());
                HelloMessage helloMessage = peerHello;
                it.setInt(6, helloMessage == null ? 0 : (n = helloMessage.p2pVersion()));
                HelloMessage helloMessage2 = peerHello;
                if (helloMessage2 == null) {
                    string5 = "";
                } else {
                    string5 = helloMessage2.clientId();
                    if (string5 == null) {
                        string5 = "";
                    }
                }
                it.setString(7, string5);
                HelloMessage helloMessage3 = peerHello;
                if (helloMessage3 == null) {
                    string4 = "";
                } else {
                    List list = helloMessage3.capabilities();
                    if (list == null) {
                        string4 = "";
                    } else {
                        string4 = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)",", null, null, (int)0, null, (Function1)recordInfo.1.1.1.INSTANCE, (int)30, null);
                        if (string4 == null) {
                            string4 = "";
                        }
                    }
                }
                it.setString(8, string4);
                Status status2 = status;
                if (status2 == null) {
                    string3 = null;
                } else {
                    Bytes32 bytes32 = status2.getGenesisHash();
                    string3 = bytes32 == null ? null : bytes32.toHexString();
                }
                it.setString(9, string3);
                Status status3 = status;
                if (status3 == null) {
                    string2 = null;
                } else {
                    Bytes32 bytes32 = status3.getBestHash();
                    string2 = bytes32 == null ? null : bytes32.toHexString();
                }
                it.setString(10, string2);
                Status status4 = status;
                if (status4 == null) {
                    string = null;
                } else {
                    UInt256 uInt256 = status4.getTotalDifficulty();
                    string = uInt256 == null ? null : uInt256.toHexString();
                }
                it.setString(11, string);
                it.setString(12, peer.getId());
                it.setString(13, wireConnection.getDisconnectReason().text);
                bl = it.execute();
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            }
            boolean bl4 = bl;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * Exception decompiling
     */
    @NotNull
    public final List<PeerConnectionInfo> getPeers$eth_crawler(long infoCollected, @Nullable Integer from, @Nullable Integer limit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static /* synthetic */ List getPeers$eth_crawler$default(RelationalPeerRepository relationalPeerRepository, long l, Integer n, Integer n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getPeers");
        }
        if ((n3 & 2) != 0) {
            n = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        return relationalPeerRepository.getPeers$eth_crawler(l, n, n2);
    }

    /*
     * Exception decompiling
     */
    @NotNull
    public final List<PeerConnectionInfoDetails> getPeersWithInfo$eth_crawler(long infoCollected, @Nullable Integer from, @Nullable Integer limit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static /* synthetic */ List getPeersWithInfo$eth_crawler$default(RelationalPeerRepository relationalPeerRepository, long l, Integer n, Integer n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getPeersWithInfo");
        }
        if ((n3 & 2) != 0) {
            n = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        return relationalPeerRepository.getPeersWithInfo$eth_crawler(l, n, n2);
    }

    /*
     * Exception decompiling
     */
    @NotNull
    public final List<PeerConnectionInfo> getPendingPeers$eth_crawler(int from, int limit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static /* synthetic */ List getPendingPeers$eth_crawler$default(RelationalPeerRepository relationalPeerRepository, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getPendingPeers");
        }
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = 100;
        }
        return relationalPeerRepository.getPendingPeers$eth_crawler(n, n2);
    }

    public final void start() {
        logger.info("Starting repo");
        BuildersKt.launch$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ RelationalPeerRepository this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var18_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        RelationalPeerRepository.access$getStarted$p(this.this$0).set(true);
lbl6:
                        // 3 sources

                        while (RelationalPeerRepository.access$getStarted$p(this.this$0).get()) {
                            RelationalPeerRepository.Companion.getLogger$eth_crawler().info("Finding client ids");
                            newClientIds = this.this$0.getClientIdsInternal$eth_crawler();
                            RelationalPeerRepository.Companion.getLogger$eth_crawler().info("Found client ids " + newClientIds.size());
                            RelationalPeerRepository.access$setClientIds$p(this.this$0, newClientIds);
                            newClientsStats = new LinkedHashMap<K, V>();
                            total = newClientIds.stream().mapToInt((ToIntFunction<ClientInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)I, invokeSuspend$lambda-0(org.apache.tuweni.eth.crawler.ClientInfo ), (Lorg/apache/tuweni/eth/crawler/ClientInfo;)I)()).sum();
                            $this$forEach$iv = newClientIds;
                            $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                newClientCount = (ClientInfo)element$iv;
                                $i$a$-forEach-RelationalPeerRepository$start$1$1 = false;
                                clientIdInfo = new ClientIdInfo(newClientCount.getClientId());
                                var12_17 = newClientsStats.computeIfAbsent(clientIdInfo.getName(), (Function<String, Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda-2$lambda-1(java.lang.String ), (Ljava/lang/String;)Ljava/util/Map;)());
                                Intrinsics.checkNotNullExpressionValue((Object)var12_17, (String)"newClientsStats.computeI\u2026.name) { mutableMapOf() }");
                                versionStats = var12_17;
                                v0 = (Long)versionStats.get(clientIdInfo.getVersion());
                                statsCount = v0 == null ? 0L : v0;
                                versionStats.put(clientIdInfo.getVersion(), Boxing.boxLong((long)(statsCount + (long)newClientCount.getCount())));
                            }
                            for (UpgradeConfig upgradeConfig : RelationalPeerRepository.access$getUpgradeConfigs$p(this.this$0)) {
                                upgradeReady = 0;
                                $this$forEach$iv = newClientIds;
                                $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    newClientCount = (ClientInfo)element$iv;
                                    $i$a$-forEach-RelationalPeerRepository$start$1$2 = false;
                                    clientIdInfo = new ClientIdInfo(newClientCount.getClientId());
                                    v1 = upgradeConfig.getVersions();
                                    statsCount = clientIdInfo.name().toLowerCase(Locale.ROOT);
                                    Intrinsics.checkNotNullExpressionValue((Object)statsCount, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                                    if (v1.get(statsCount) == null) continue;
                                    $i$a$-let-RelationalPeerRepository$start$1$2$1 = false;
                                    if (clientIdInfo.compareTo(upgradeVersion) < 0) continue;
                                    upgradeReady += newClientCount.getCount();
                                }
                                RelationalPeerRepository.access$getUpgradeStats$p(this.this$0).put(upgradeConfig.getName(), new ClientReadyStats(total, upgradeReady));
                            }
                            RelationalPeerRepository.access$setClientsStats$p(this.this$0, newClientsStats);
                            RelationalPeerRepository.access$getTotalClientsGauge$p(this.this$0).record((long)total);
                            RelationalPeerRepository.access$getClientCalculationsCounter$p(this.this$0).add(1L);
                            this.label = 1;
                            v2 = DelayKt.delay((long)RelationalPeerRepository.access$getClientsStatsDelay$p(this.this$0), (Continuation)((Continuation)this));
                            if (v2 != var18_2) continue;
                            return var18_2;
                        }
                        break;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
                        ** GOTO lbl6
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final int invokeSuspend$lambda-0(ClientInfo it) {
                return it.getCount();
            }

            private static final Map invokeSuspend$lambda-2$lambda-1(String it) {
                return new LinkedHashMap<K, V>();
            }
        }), (int)3, null);
    }

    @Nullable
    public final Object stop(@NotNull Continuation<? super Unit> $completion) {
        this.started.set(false);
        return Unit.INSTANCE;
    }

    @NotNull
    public final Map<String, ClientReadyStats> getUpgradeStats$eth_crawler() {
        return this.upgradeStats;
    }

    @NotNull
    public final List<ClientInfo> getClientIds$eth_crawler() {
        List<ClientInfo> list = this.clientIds;
        return list == null ? CollectionsKt.emptyList() : list;
    }

    @NotNull
    public final Map<String, Map<String, Long>> getClientStats$eth_crawler() {
        Map<String, Map<String, Long>> map = this.clientsStats;
        return map == null ? MapsKt.emptyMap() : map;
    }

    /*
     * Exception decompiling
     */
    @NotNull
    public final List<ClientInfo> getClientIdsInternal$eth_crawler() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public final PeerConnectionInfoDetails getPeerWithInfo$eth_crawler(long infoCollected, @NotNull String publicKey) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    public Object get(@NotNull String uri, @NotNull Continuation<? super Peer> $completion) {
        return PeerRepository.DefaultImpls.get((PeerRepository)this, (String)uri, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String get$lambda-2(RelationalPeerRepository this$0, SECP256K1.PublicKey $nodeId, SECP256K1.PublicKey it) {
        String string;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$nodeId, (String)"$nodeId");
        AutoCloseable autoCloseable = this$0.dataSource.getConnection();
        Throwable throwable = null;
        try {
            String string2;
            Connection conn = (Connection)autoCloseable;
            boolean bl = false;
            logger.trace("Get peer with " + $nodeId);
            PreparedStatement stmt = conn.prepareStatement("select id,publickey from identity where publickey=?");
            stmt.setBytes(1, $nodeId.bytes().toArrayUnsafe());
            ResultSet rs = stmt.executeQuery();
            AutoCloseable autoCloseable2 = rs;
            Throwable throwable2 = null;
            try {
                String string3;
                ResultSet it2 = (ResultSet)autoCloseable2;
                boolean bl2 = false;
                if (!rs.next()) {
                    logger.debug("Creating new peer with public key " + $nodeId.toHexString());
                    String string4 = UUID.randomUUID().toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"randomUUID().toString()");
                    String id = string4;
                    PreparedStatement insert = conn.prepareStatement("insert into identity(id, publickey) values(?, ?)");
                    insert.setString(1, id);
                    insert.setBytes(2, $nodeId.bytes().toArrayUnsafe());
                    insert.execute();
                    string3 = id;
                } else {
                    String id;
                    logger.trace("Found existing peer with public key " + $nodeId.toHexString());
                    string3 = id = rs.getString(1);
                }
                string2 = string3;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            }
            string = string2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return string;
    }

    public static final /* synthetic */ AtomicBoolean access$getStarted$p(RelationalPeerRepository $this) {
        return $this.started;
    }

    public static final /* synthetic */ void access$setClientIds$p(RelationalPeerRepository $this, List list) {
        $this.clientIds = list;
    }

    public static final /* synthetic */ List access$getUpgradeConfigs$p(RelationalPeerRepository $this) {
        return $this.upgradeConfigs;
    }

    public static final /* synthetic */ Map access$getUpgradeStats$p(RelationalPeerRepository $this) {
        return $this.upgradeStats;
    }

    public static final /* synthetic */ void access$setClientsStats$p(RelationalPeerRepository $this, Map map) {
        $this.clientsStats = map;
    }

    public static final /* synthetic */ LongValueRecorder access$getTotalClientsGauge$p(RelationalPeerRepository $this) {
        return $this.totalClientsGauge;
    }

    public static final /* synthetic */ LongCounter access$getClientCalculationsCounter$p(RelationalPeerRepository $this) {
        return $this.clientCalculationsCounter;
    }

    public static final /* synthetic */ long access$getClientsStatsDelay$p(RelationalPeerRepository $this) {
        return $this.clientsStatsDelay;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/apache/tuweni/eth/crawler/RelationalPeerRepository$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger$eth_crawler", "()Lorg/slf4j/Logger;", "eth-crawler"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLogger$eth_crawler() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

