/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.ethstats;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.eth.Address;
import org.apache.tuweni.eth.Hash;
import org.apache.tuweni.ethstats.TxStats;
import org.apache.tuweni.units.bigints.UInt256;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonPropertyOrder(alphabetic=true)
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b%\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001By\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\u0006\u0010\f\u001a\u00020\b\u0012\u0006\u0010\r\u001a\u00020\u0003\u0012\u0006\u0010\u000e\u001a\u00020\u0003\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\u0006\u0010\u0012\u001a\u00020\u0005\u0012\u0006\u0010\u0013\u001a\u00020\u0005\u0012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010\u00a2\u0006\u0002\u0010\u0015J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u00c6\u0003J\t\u0010*\u001a\u00020\u0005H\u00c6\u0003J\t\u0010+\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u00c6\u0003J\t\u0010-\u001a\u00020\u0005H\u00c6\u0003J\t\u0010.\u001a\u00020\u0005H\u00c6\u0003J\t\u0010/\u001a\u00020\bH\u00c6\u0003J\t\u00100\u001a\u00020\nH\u00c6\u0003J\t\u00101\u001a\u00020\bH\u00c6\u0003J\t\u00102\u001a\u00020\bH\u00c6\u0003J\t\u00103\u001a\u00020\u0003H\u00c6\u0003J\t\u00104\u001a\u00020\u0003H\u00c6\u0003J\u0097\u0001\u00105\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\b2\b\b\u0002\u0010\f\u001a\u00020\b2\b\b\u0002\u0010\r\u001a\u00020\u00032\b\b\u0002\u0010\u000e\u001a\u00020\u00032\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u00052\b\b\u0002\u0010\u0013\u001a\u00020\u00052\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u00c6\u0001J\u0013\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\b\u00109\u001a\u00020\bH\u0007J\t\u0010:\u001a\u00020;H\u00d6\u0001J\t\u0010<\u001a\u00020=H\u00d6\u0001R\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0017R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001cR\u0011\u0010\u0013\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001cR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0019R\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0017R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001cR\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010%\u00a8\u0006>"}, d2={"Lorg/apache/tuweni/ethstats/BlockStats;", "", "number", "Lorg/apache/tuweni/units/bigints/UInt256;", "hash", "Lorg/apache/tuweni/eth/Hash;", "parentHash", "timestamp", "", "miner", "Lorg/apache/tuweni/eth/Address;", "gasUsed", "gasLimit", "difficulty", "totalDifficulty", "transactions", "", "Lorg/apache/tuweni/ethstats/TxStats;", "transactionsRoot", "stateRoot", "uncles", "(Lorg/apache/tuweni/units/bigints/UInt256;Lorg/apache/tuweni/eth/Hash;Lorg/apache/tuweni/eth/Hash;JLorg/apache/tuweni/eth/Address;JJLorg/apache/tuweni/units/bigints/UInt256;Lorg/apache/tuweni/units/bigints/UInt256;Ljava/util/List;Lorg/apache/tuweni/eth/Hash;Lorg/apache/tuweni/eth/Hash;Ljava/util/List;)V", "getDifficulty", "()Lorg/apache/tuweni/units/bigints/UInt256;", "getGasLimit", "()J", "getGasUsed", "getHash", "()Lorg/apache/tuweni/eth/Hash;", "getMiner", "()Lorg/apache/tuweni/eth/Address;", "getNumber", "getParentHash", "getStateRoot", "getTimestamp", "getTotalDifficulty", "getTransactions", "()Ljava/util/List;", "getTransactionsRoot", "getUncles", "component1", "component10", "component11", "component12", "component13", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "getBlockNumber", "hashCode", "", "toString", "", "ethstats"})
public final class BlockStats {
    @NotNull
    private final UInt256 number;
    @NotNull
    private final Hash hash;
    @NotNull
    private final Hash parentHash;
    private final long timestamp;
    @NotNull
    private final Address miner;
    private final long gasUsed;
    private final long gasLimit;
    @NotNull
    private final UInt256 difficulty;
    @NotNull
    private final UInt256 totalDifficulty;
    @NotNull
    private final List<TxStats> transactions;
    @NotNull
    private final Hash transactionsRoot;
    @NotNull
    private final Hash stateRoot;
    @NotNull
    private final List<Hash> uncles;

    public BlockStats(@NotNull UInt256 number, @NotNull Hash hash, @NotNull Hash parentHash, long timestamp, @NotNull Address miner, long gasUsed, long gasLimit, @NotNull UInt256 difficulty, @NotNull UInt256 totalDifficulty, @NotNull List<TxStats> transactions, @NotNull Hash transactionsRoot, @NotNull Hash stateRoot, @NotNull List<Hash> uncles) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        Intrinsics.checkNotNullParameter((Object)parentHash, (String)"parentHash");
        Intrinsics.checkNotNullParameter((Object)miner, (String)"miner");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)totalDifficulty, (String)"totalDifficulty");
        Intrinsics.checkNotNullParameter(transactions, (String)"transactions");
        Intrinsics.checkNotNullParameter((Object)transactionsRoot, (String)"transactionsRoot");
        Intrinsics.checkNotNullParameter((Object)stateRoot, (String)"stateRoot");
        Intrinsics.checkNotNullParameter(uncles, (String)"uncles");
        this.number = number;
        this.hash = hash;
        this.parentHash = parentHash;
        this.timestamp = timestamp;
        this.miner = miner;
        this.gasUsed = gasUsed;
        this.gasLimit = gasLimit;
        this.difficulty = difficulty;
        this.totalDifficulty = totalDifficulty;
        this.transactions = transactions;
        this.transactionsRoot = transactionsRoot;
        this.stateRoot = stateRoot;
        this.uncles = uncles;
    }

    @NotNull
    public final UInt256 getNumber() {
        return this.number;
    }

    @NotNull
    public final Hash getHash() {
        return this.hash;
    }

    @NotNull
    public final Hash getParentHash() {
        return this.parentHash;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    public final Address getMiner() {
        return this.miner;
    }

    public final long getGasUsed() {
        return this.gasUsed;
    }

    public final long getGasLimit() {
        return this.gasLimit;
    }

    @NotNull
    public final UInt256 getDifficulty() {
        return this.difficulty;
    }

    @NotNull
    public final UInt256 getTotalDifficulty() {
        return this.totalDifficulty;
    }

    @NotNull
    public final List<TxStats> getTransactions() {
        return this.transactions;
    }

    @NotNull
    public final Hash getTransactionsRoot() {
        return this.transactionsRoot;
    }

    @NotNull
    public final Hash getStateRoot() {
        return this.stateRoot;
    }

    @NotNull
    public final List<Hash> getUncles() {
        return this.uncles;
    }

    @JsonGetter(value="number")
    public final long getBlockNumber() {
        return this.number.toLong();
    }

    @NotNull
    public final UInt256 component1() {
        return this.number;
    }

    @NotNull
    public final Hash component2() {
        return this.hash;
    }

    @NotNull
    public final Hash component3() {
        return this.parentHash;
    }

    public final long component4() {
        return this.timestamp;
    }

    @NotNull
    public final Address component5() {
        return this.miner;
    }

    public final long component6() {
        return this.gasUsed;
    }

    public final long component7() {
        return this.gasLimit;
    }

    @NotNull
    public final UInt256 component8() {
        return this.difficulty;
    }

    @NotNull
    public final UInt256 component9() {
        return this.totalDifficulty;
    }

    @NotNull
    public final List<TxStats> component10() {
        return this.transactions;
    }

    @NotNull
    public final Hash component11() {
        return this.transactionsRoot;
    }

    @NotNull
    public final Hash component12() {
        return this.stateRoot;
    }

    @NotNull
    public final List<Hash> component13() {
        return this.uncles;
    }

    @NotNull
    public final BlockStats copy(@NotNull UInt256 number, @NotNull Hash hash, @NotNull Hash parentHash, long timestamp, @NotNull Address miner, long gasUsed, long gasLimit, @NotNull UInt256 difficulty, @NotNull UInt256 totalDifficulty, @NotNull List<TxStats> transactions, @NotNull Hash transactionsRoot, @NotNull Hash stateRoot, @NotNull List<Hash> uncles) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        Intrinsics.checkNotNullParameter((Object)parentHash, (String)"parentHash");
        Intrinsics.checkNotNullParameter((Object)miner, (String)"miner");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)totalDifficulty, (String)"totalDifficulty");
        Intrinsics.checkNotNullParameter(transactions, (String)"transactions");
        Intrinsics.checkNotNullParameter((Object)transactionsRoot, (String)"transactionsRoot");
        Intrinsics.checkNotNullParameter((Object)stateRoot, (String)"stateRoot");
        Intrinsics.checkNotNullParameter(uncles, (String)"uncles");
        return new BlockStats(number, hash, parentHash, timestamp, miner, gasUsed, gasLimit, difficulty, totalDifficulty, transactions, transactionsRoot, stateRoot, uncles);
    }

    public static /* synthetic */ BlockStats copy$default(BlockStats blockStats, UInt256 uInt256, Hash hash, Hash hash2, long l, Address address, long l2, long l3, UInt256 uInt2562, UInt256 uInt2563, List list, Hash hash3, Hash hash4, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            uInt256 = blockStats.number;
        }
        if ((n & 2) != 0) {
            hash = blockStats.hash;
        }
        if ((n & 4) != 0) {
            hash2 = blockStats.parentHash;
        }
        if ((n & 8) != 0) {
            l = blockStats.timestamp;
        }
        if ((n & 0x10) != 0) {
            address = blockStats.miner;
        }
        if ((n & 0x20) != 0) {
            l2 = blockStats.gasUsed;
        }
        if ((n & 0x40) != 0) {
            l3 = blockStats.gasLimit;
        }
        if ((n & 0x80) != 0) {
            uInt2562 = blockStats.difficulty;
        }
        if ((n & 0x100) != 0) {
            uInt2563 = blockStats.totalDifficulty;
        }
        if ((n & 0x200) != 0) {
            list = blockStats.transactions;
        }
        if ((n & 0x400) != 0) {
            hash3 = blockStats.transactionsRoot;
        }
        if ((n & 0x800) != 0) {
            hash4 = blockStats.stateRoot;
        }
        if ((n & 0x1000) != 0) {
            list2 = blockStats.uncles;
        }
        return blockStats.copy(uInt256, hash, hash2, l, address, l2, l3, uInt2562, uInt2563, list, hash3, hash4, list2);
    }

    @NotNull
    public String toString() {
        return "BlockStats(number=" + this.number + ", hash=" + this.hash + ", parentHash=" + this.parentHash + ", timestamp=" + this.timestamp + ", miner=" + this.miner + ", gasUsed=" + this.gasUsed + ", gasLimit=" + this.gasLimit + ", difficulty=" + this.difficulty + ", totalDifficulty=" + this.totalDifficulty + ", transactions=" + this.transactions + ", transactionsRoot=" + this.transactionsRoot + ", stateRoot=" + this.stateRoot + ", uncles=" + this.uncles + ")";
    }

    public int hashCode() {
        int result = this.number.hashCode();
        result = result * 31 + this.hash.hashCode();
        result = result * 31 + this.parentHash.hashCode();
        result = result * 31 + Long.hashCode(this.timestamp);
        result = result * 31 + this.miner.hashCode();
        result = result * 31 + Long.hashCode(this.gasUsed);
        result = result * 31 + Long.hashCode(this.gasLimit);
        result = result * 31 + this.difficulty.hashCode();
        result = result * 31 + this.totalDifficulty.hashCode();
        result = result * 31 + ((Object)this.transactions).hashCode();
        result = result * 31 + this.transactionsRoot.hashCode();
        result = result * 31 + this.stateRoot.hashCode();
        result = result * 31 + ((Object)this.uncles).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BlockStats)) {
            return false;
        }
        BlockStats blockStats = (BlockStats)other;
        if (!Intrinsics.areEqual((Object)this.number, (Object)blockStats.number)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.hash, (Object)blockStats.hash)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.parentHash, (Object)blockStats.parentHash)) {
            return false;
        }
        if (this.timestamp != blockStats.timestamp) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.miner, (Object)blockStats.miner)) {
            return false;
        }
        if (this.gasUsed != blockStats.gasUsed) {
            return false;
        }
        if (this.gasLimit != blockStats.gasLimit) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.difficulty, (Object)blockStats.difficulty)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.totalDifficulty, (Object)blockStats.totalDifficulty)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.transactions, blockStats.transactions)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.transactionsRoot, (Object)blockStats.transactionsRoot)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.stateRoot, (Object)blockStats.stateRoot)) {
            return false;
        }
        return Intrinsics.areEqual(this.uncles, blockStats.uncles);
    }
}

