/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.evm.impl;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.bytes.MutableBytes;
import org.apache.tuweni.units.bigints.UInt256;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0003J\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u0004\u0018\u00010\nJ\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\nJ\u0006\u0010\b\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/apache/tuweni/evm/impl/Stack;", "", "maxSize", "", "(I)V", "mutableStack", "Lorg/apache/tuweni/bytes/MutableBytes;", "kotlin.jvm.PlatformType", "size", "get", "Lorg/apache/tuweni/units/bigints/UInt256;", "i", "overflowed", "", "pop", "push", "value", "Lorg/apache/tuweni/bytes/Bytes32;", "set", "", "elt", "evm"})
public final class Stack {
    private final int maxSize;
    private final MutableBytes mutableStack;
    private int size;

    public Stack(int maxSize) {
        this.maxSize = maxSize;
        this.mutableStack = MutableBytes.create((int)(this.maxSize * 32));
    }

    public /* synthetic */ Stack(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 1025;
        }
        this(n);
    }

    @Nullable
    public final UInt256 get(int i) {
        UInt256 uInt256;
        if (i >= this.size) {
            return null;
        }
        Bytes bytes = this.mutableStack.slice((this.size - i - 1) * 32, 32);
        if (bytes == null) {
            uInt256 = null;
        } else {
            Bytes it = bytes;
            boolean bl = false;
            uInt256 = UInt256.fromBytes((Bytes)it);
        }
        return uInt256;
    }

    @Nullable
    public final UInt256 pop() {
        UInt256 uInt256;
        if (this.size <= 0) {
            return null;
        }
        int n = this.size;
        this.size = n + -1;
        Bytes bytes = this.mutableStack.slice(this.size * 32, 32);
        if (bytes == null) {
            uInt256 = null;
        } else {
            Bytes it = bytes;
            boolean bl = false;
            uInt256 = UInt256.fromBytes((Bytes)it);
        }
        return uInt256;
    }

    public final boolean push(@NotNull Bytes32 value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (this.size >= this.maxSize) {
            return false;
        }
        this.mutableStack.set(this.size * 32, (Bytes)value);
        int n = this.size;
        this.size = n + 1;
        return true;
    }

    public final int size() {
        return this.size;
    }

    public final boolean overflowed() {
        return this.size >= this.maxSize;
    }

    public final void set(int i, @NotNull UInt256 elt) {
        Intrinsics.checkNotNullParameter((Object)elt, (String)"elt");
        this.mutableStack.set((this.size - i - 1) * 32, (Bytes)elt);
    }

    public Stack() {
        this(0, 1, null);
    }
}

