/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.discovery;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.tuweni.crypto.Hash;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.devp2p.EthereumNodeRecord;
import org.apache.tuweni.discovery.DNSEntry;
import org.apache.tuweni.discovery.DNSVisitor;
import org.apache.tuweni.discovery.ENRNode;
import org.apache.tuweni.discovery.ENRTree;
import org.apache.tuweni.discovery.ENRTreeLink;
import org.apache.tuweni.discovery.ENRTreeRoot;
import org.apache.tuweni.discovery.InvalidEntryException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.WireParseException;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 %2\u00020\u0001:\u0001%B'\b\u0007\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0003J \u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001b\u001a\u00020\u0003J\u0010\u0010 \u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001b\u001a\u00020\u0003J\u0016\u0010!\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001dJ\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006&"}, d2={"Lorg/apache/tuweni/discovery/DNSResolver;", "", "dnsServer", "", "seq", "", "resolver", "Lorg/xbill/DNS/Resolver;", "(Ljava/lang/String;JLorg/xbill/DNS/Resolver;)V", "getSeq", "()J", "setSeq", "(J)V", "checkSignature", "", "root", "Lorg/apache/tuweni/discovery/ENRTreeRoot;", "pubKey", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "sig", "Lorg/apache/tuweni/crypto/SECP256K1$Signature;", "collectAll", "", "Lorg/apache/tuweni/devp2p/EthereumNodeRecord;", "enrLink", "internalVisit", "entryName", "domainName", "visitor", "Lorg/apache/tuweni/discovery/DNSVisitor;", "resolveRecord", "Lorg/apache/tuweni/discovery/DNSEntry;", "resolveRecordRaw", "visitTree", "", "link", "Lorg/apache/tuweni/discovery/ENRTreeLink;", "Companion", "dns-discovery"})
public final class DNSResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String dnsServer;
    private long seq;
    @NotNull
    private final Resolver resolver;
    private static final Logger logger = LoggerFactory.getLogger(DNSResolver.class);

    @JvmOverloads
    public DNSResolver(@Nullable String dnsServer, long seq, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        this.dnsServer = dnsServer;
        this.seq = seq;
        this.resolver = resolver;
    }

    public /* synthetic */ DNSResolver(String string, long l, Resolver resolver, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            l = 0L;
        }
        if ((n & 4) != 0) {
            Resolver resolver2;
            if (string != null) {
                String[] stringArray = new String[]{string};
                resolver2 = (Resolver)new ExtendedResolver(stringArray);
            } else {
                resolver2 = (Resolver)new ExtendedResolver();
            }
            resolver = resolver2;
        }
        this(string, l, resolver);
    }

    public final long getSeq() {
        return this.seq;
    }

    public final void setSeq(long l) {
        this.seq = l;
    }

    @Nullable
    public final DNSEntry resolveRecord(@NotNull String domainName) {
        DNSEntry dNSEntry;
        Intrinsics.checkNotNullParameter((Object)domainName, (String)"domainName");
        String string = this.resolveRecordRaw(domainName);
        if (string == null) {
            dNSEntry = null;
        } else {
            String it = string;
            boolean bl = false;
            dNSEntry = DNSEntry.Companion.readDNSEntry(it);
        }
        return dNSEntry;
    }

    private final boolean checkSignature(ENRTreeRoot root, SECP256K1.PublicKey pubKey, SECP256K1.Signature sig) {
        String string = root.signedContent();
        Charset charset = Charsets.UTF_8;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] hash = Hash.keccak256((byte[])byArray);
        return SECP256K1.verifyHashed((byte[])hash, (SECP256K1.Signature)sig, (SECP256K1.PublicKey)pubKey);
    }

    @NotNull
    public final List<EthereumNodeRecord> collectAll(@NotNull String enrLink) {
        Intrinsics.checkNotNullParameter((Object)enrLink, (String)"enrLink");
        List nodes = new ArrayList();
        DNSVisitor visitor2 = new DNSVisitor(nodes){
            final /* synthetic */ List<EthereumNodeRecord> $nodes;
            {
                this.$nodes = $nodes;
            }

            public boolean visit(@NotNull EthereumNodeRecord enr) {
                Intrinsics.checkNotNullParameter((Object)enr, (String)"enr");
                this.$nodes.add(enr);
                return true;
            }
        };
        this.visitTree(enrLink, visitor2);
        logger.info("Resolved " + nodes.size() + " nodes");
        return nodes;
    }

    public final void visitTree(@NotNull String enrLink, @NotNull DNSVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)enrLink, (String)"enrLink");
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        ENRTreeLink link = new ENRTreeLink(enrLink);
        this.visitTree(link, visitor2);
    }

    private final void visitTree(ENRTreeLink link, DNSVisitor visitor2) {
        DNSEntry entry = this.resolveRecord(link.getDomainName());
        if (!(entry instanceof ENRTreeRoot)) {
            logger.debug("Root entry " + entry + " is not an ENR tree root");
            return;
        }
        if (!this.checkSignature((ENRTreeRoot)entry, link.publicKey(), ((ENRTreeRoot)entry).getSig())) {
            logger.debug("ENR tree root " + link.getDomainName() + " failed signature check");
            return;
        }
        if (((ENRTreeRoot)entry).getSeq() <= this.seq) {
            logger.debug("ENR tree root seq " + entry + ".seq is not higher than " + this.seq + ", aborting");
            return;
        }
        this.seq = ((ENRTreeRoot)entry).getSeq();
        this.internalVisit(((ENRTreeRoot)entry).getEnrRoot(), link.getDomainName(), visitor2);
        this.internalVisit(((ENRTreeRoot)entry).getLinkRoot(), link.getDomainName(), visitor2);
    }

    @Nullable
    public final String resolveRecordRaw(@NotNull String domainName) {
        Intrinsics.checkNotNullParameter((Object)domainName, (String)"domainName");
        try {
            this.resolver.setTCP(true);
            int type = 16;
            Name name = Name.fromString((String)domainName, (Name)Name.root);
            Record rec = Record.newRecord((Name)name, (int)type, (int)1);
            Message query = Message.newQuery((Record)rec);
            Message response = this.resolver.send(query);
            List records = response.getSection(1);
            Intrinsics.checkNotNullExpressionValue((Object)records, (String)"records");
            if (!((Collection)records).isEmpty()) {
                return ((Record)records.get(0)).rdataToString();
            }
            logger.debug("No TXT record for " + domainName);
            return null;
        }
        catch (IOException e) {
            logger.warn("I/O exception contacting remote DNS server when resolving " + domainName, (Throwable)e);
            return null;
        }
        catch (WireParseException e) {
            logger.error("Error reading TXT record", (Throwable)e);
            return null;
        }
    }

    private final boolean internalVisit(String entryName, String domainName, DNSVisitor visitor2) {
        try {
            DNSEntry entry = this.resolveRecord(entryName + "." + domainName);
            if (entry == null) {
                return true;
            }
            if (entry instanceof ENRNode) {
                return visitor2.visit(((ENRNode)entry).getNodeRecord());
            }
            if (entry instanceof ENRTree) {
                for (String e : ((ENRTree)entry).getEntries()) {
                    boolean keepGoing = this.internalVisit(e, domainName, visitor2);
                    if (keepGoing) continue;
                    return false;
                }
            } else if (entry instanceof ENRTreeLink) {
                this.visitTree((ENRTreeLink)entry, visitor2);
            } else {
                logger.debug("Unsupported type of node " + entry);
            }
            return true;
        }
        catch (InvalidEntryException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return true;
        }
        catch (IllegalArgumentException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            return true;
        }
    }

    @JvmOverloads
    public DNSResolver(@Nullable String dnsServer, long seq) {
        this(dnsServer, seq, null, 4, null);
    }

    @JvmOverloads
    public DNSResolver(@Nullable String dnsServer) {
        this(dnsServer, 0L, null, 6, null);
    }

    @JvmOverloads
    public DNSResolver() {
        this(null, 0L, null, 7, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/apache/tuweni/discovery/DNSResolver$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger$dns_discovery", "()Lorg/slf4j/Logger;", "dns-discovery"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLogger$dns_discovery() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

