/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.scuttlebutt;

import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.crypto.sodium.Signature;
import org.apache.tuweni.scuttlebutt.Ed25519KeyPairIdentity;
import org.apache.tuweni.scuttlebutt.Ed25519PublicKeyIdentity;
import org.apache.tuweni.scuttlebutt.SECP256K1KeyPairIdentity;
import org.apache.tuweni.scuttlebutt.SECP256K1PublicKeyIdentity;

public interface Identity {
    public static Identity fromKeyPair(Signature.KeyPair keyPair) {
        return new Ed25519KeyPairIdentity(keyPair);
    }

    public static Identity fromKeyPair(SECP256K1.KeyPair keyPair) {
        return new SECP256K1KeyPairIdentity(keyPair);
    }

    public static Identity fromSecretKey(Signature.SecretKey secretKey) {
        return Identity.fromKeyPair(Signature.KeyPair.forSecretKey((Signature.SecretKey)secretKey));
    }

    public static Identity fromSecretKey(SECP256K1.SecretKey secretKey) {
        return Identity.fromKeyPair(SECP256K1.KeyPair.fromSecretKey((SECP256K1.SecretKey)secretKey));
    }

    public static Identity random() {
        return Identity.randomEd25519();
    }

    public static Identity randomEd25519() {
        return new Ed25519KeyPairIdentity(Signature.KeyPair.random());
    }

    public static Identity randomSECP256K1() {
        return new SECP256K1KeyPairIdentity(SECP256K1.KeyPair.random());
    }

    public static Identity fromPublicKey(SECP256K1.PublicKey publicKey) {
        return new SECP256K1PublicKeyIdentity(publicKey);
    }

    public static Identity fromPublicKey(Signature.PublicKey publicKey) {
        return new Ed25519PublicKeyIdentity(publicKey);
    }

    public Bytes sign(Bytes var1);

    public boolean verify(Bytes var1, Bytes var2);

    public String publicKeyAsBase64String();

    public Curve curve();

    default public String curveName() {
        return this.curve().name;
    }

    public Signature.PublicKey ed25519PublicKey();

    public SECP256K1.PublicKey secp256k1PublicKey();

    default public String toCanonicalForm() {
        return "@" + this.publicKeyAsBase64String() + "." + this.curveName();
    }

    public static enum Curve {
        Ed25519("ed25519"),
        SECP256K1("secp256k1");

        public final String name;

        private Curve(String name) {
            this.name = name;
        }
    }
}

