/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.junit;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.apache.tuweni.junit.LuceneIndex;
import org.apache.tuweni.junit.LuceneIndexWriter;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class LuceneIndexWriterExtension
implements ParameterResolver,
AfterAllCallback {
    private Directory index;
    private IndexWriter writer;

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().isAnnotationPresent(LuceneIndexWriter.class) || parameterContext.getParameter().isAnnotationPresent(LuceneIndex.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (this.writer == null) {
            try {
                this.index = new ByteBuffersDirectory();
                StandardAnalyzer analyzer = new StandardAnalyzer();
                IndexWriterConfig config = new IndexWriterConfig((Analyzer)analyzer);
                this.writer = new IndexWriter(this.index, config);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        if (parameterContext.isAnnotated(LuceneIndexWriter.class)) {
            return this.writer;
        }
        return this.index;
    }

    public void afterAll(ExtensionContext context) throws Exception {
        if (this.writer != null) {
            this.writer.close();
        }
        if (this.index != null) {
            this.index.close();
        }
    }
}

