/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.eth;

import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.eth.Hash;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.units.bigints.UInt256;
import org.apache.tuweni.units.ethereum.Wei;

public final class AccountState {
    private static final int DEFAULT_VERSION = 0;
    private final UInt256 nonce;
    private final Wei balance;
    private final Hash storageRoot;
    private final Hash codeHash;
    private final int version;

    public static AccountState fromBytes(Bytes bytes) {
        Objects.requireNonNull(bytes);
        return (AccountState)RLP.decodeList((Bytes)bytes, reader -> new AccountState(reader.readUInt256(), Wei.valueOf((UInt256)reader.readUInt256()), Hash.fromBytes(reader.readValue()), Hash.fromBytes(reader.readValue()), reader.isComplete() ? 0 : reader.readInt()));
    }

    public AccountState(UInt256 nonce, Wei balance, Hash storageRoot, Hash codeHash) {
        this(nonce, balance, storageRoot, codeHash, 0);
    }

    public AccountState(UInt256 nonce, Wei balance, Hash storageRoot, Hash codeHash, int version) {
        this.nonce = nonce;
        this.balance = balance;
        this.storageRoot = storageRoot;
        this.codeHash = codeHash;
        this.version = version;
    }

    public Bytes toBytes() {
        return RLP.encodeList(writer -> {
            writer.writeValue(this.nonce.toMinimalBytes());
            writer.writeValue(this.balance.toMinimalBytes());
            writer.writeValue((Bytes)this.storageRoot);
            writer.writeValue((Bytes)this.codeHash);
            if (this.version != 0) {
                writer.writeInt(this.version);
            }
        });
    }

    public Hash getCodeHash() {
        return this.codeHash;
    }

    public Hash getStorageRoot() {
        return this.storageRoot;
    }

    public int getVersion() {
        return this.version;
    }

    public UInt256 getNonce() {
        return this.nonce;
    }

    public Wei getBalance() {
        return this.balance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountState that = (AccountState)o;
        return this.version == that.version && Objects.equals(this.nonce, that.nonce) && Objects.equals(this.balance, that.balance) && Objects.equals((Object)this.storageRoot, (Object)that.storageRoot) && Objects.equals((Object)this.codeHash, (Object)that.codeHash);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.nonce, this.balance, this.storageRoot, this.codeHash, this.version});
    }
}

