/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.discovery;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.discovery.DNSEntry;
import org.apache.tuweni.discovery.InvalidEntryException;
import org.apache.tuweni.io.Base64URLSafe;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0015\u001a\u00020\u0004J\b\u0010\u0016\u001a\u00020\u0004H\u0016R\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\b\u00a8\u0006\u0017"}, d2={"Lorg/apache/tuweni/discovery/ENRTreeRoot;", "Lorg/apache/tuweni/discovery/DNSEntry;", "attrs", "", "", "(Ljava/util/Map;)V", "enrRoot", "getEnrRoot", "()Ljava/lang/String;", "linkRoot", "getLinkRoot", "seq", "", "getSeq", "()J", "sig", "Lorg/apache/tuweni/crypto/SECP256K1$Signature;", "getSig", "()Lorg/apache/tuweni/crypto/SECP256K1$Signature;", "version", "getVersion", "signedContent", "toString", "dns-discovery"})
public final class ENRTreeRoot
implements DNSEntry {
    @NotNull
    private final String version;
    private final long seq;
    @NotNull
    private final SECP256K1.Signature sig;
    @NotNull
    private final String enrRoot;
    @NotNull
    private final String linkRoot;

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    public final long getSeq() {
        return this.seq;
    }

    @NotNull
    public final SECP256K1.Signature getSig() {
        return this.sig;
    }

    @NotNull
    public final String getEnrRoot() {
        return this.enrRoot;
    }

    @NotNull
    public final String getLinkRoot() {
        return this.linkRoot;
    }

    @NotNull
    public String toString() {
        return "enrtree-root:" + this.version + " e=" + this.enrRoot + ' ' + "l=" + this.linkRoot + " seq=" + this.seq + " sig=" + Base64URLSafe.encode((Bytes)this.sig.bytes());
    }

    @NotNull
    public final String signedContent() {
        return "enrtree-root:" + this.version + " e=" + this.enrRoot + " l=" + this.linkRoot + " seq=" + this.seq;
    }

    public ENRTreeRoot(@NotNull Map<String, String> attrs) {
        Intrinsics.checkNotNullParameter(attrs, (String)"attrs");
        if (attrs.get("enrtree-root") == null || attrs.get("seq") == null || attrs.get("sig") == null || attrs.get("e") == null || attrs.get("l") == null) {
            throw (Throwable)new InvalidEntryException("Missing attributes on root entry");
        }
        String string = attrs.get("enrtree-root");
        Intrinsics.checkNotNull((Object)string);
        this.version = string;
        String string2 = attrs.get("seq");
        Intrinsics.checkNotNull((Object)string2);
        String string3 = string2;
        boolean bl = false;
        this.seq = Long.parseLong(string3);
        String string4 = attrs.get("sig");
        Intrinsics.checkNotNull((Object)string4);
        Bytes sigBytes = Base64URLSafe.decode((String)string4);
        SECP256K1.Signature signature = SECP256K1.Signature.fromBytes((Bytes)Bytes.concatenate((Bytes[])new Bytes[]{sigBytes, Bytes.wrap((byte[])new byte[Math.max(0, 65 - sigBytes.size())])}));
        Intrinsics.checkNotNullExpressionValue((Object)signature, (String)"SECP256K1.Signature.from\u2026s.size())))\n      )\n    )");
        this.sig = signature;
        String string5 = attrs.get("e");
        Intrinsics.checkNotNull((Object)string5);
        this.enrRoot = string5;
        String string6 = attrs.get("l");
        Intrinsics.checkNotNull((Object)string6);
        this.linkRoot = string6;
    }
}

