/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.eth.crawler;

import com.zaxxer.hikari.HikariDataSource;
import io.vertx.core.Vertx;
import io.vertx.core.net.SocketAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Provider;
import java.security.Security;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import org.apache.tuweni.concurrent.AsyncCompletion;
import org.apache.tuweni.concurrent.coroutines.AsyncCompletionKt;
import org.apache.tuweni.config.ConfigurationError;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.devp2p.Peer;
import org.apache.tuweni.devp2p.PeerRepository;
import org.apache.tuweni.devp2p.Scraper;
import org.apache.tuweni.devp2p.eth.BlockchainInformation;
import org.apache.tuweni.devp2p.eth.EthClientKt;
import org.apache.tuweni.devp2p.eth.EthHelloSubprotocol;
import org.apache.tuweni.devp2p.eth.SimpleBlockchainInformation;
import org.apache.tuweni.devp2p.eth.Status;
import org.apache.tuweni.eth.Block;
import org.apache.tuweni.eth.BlockHeader;
import org.apache.tuweni.eth.Hash;
import org.apache.tuweni.eth.crawler.CrawlerApp;
import org.apache.tuweni.eth.crawler.CrawlerAppKt;
import org.apache.tuweni.eth.crawler.CrawlerConfig;
import org.apache.tuweni.eth.crawler.CrawlerEthstatsController;
import org.apache.tuweni.eth.crawler.CrawlerRESTService;
import org.apache.tuweni.eth.crawler.EthstatsDataRepository;
import org.apache.tuweni.eth.crawler.PeerConnectionInfo;
import org.apache.tuweni.eth.crawler.RelationalPeerRepository;
import org.apache.tuweni.eth.genesis.GenesisFile;
import org.apache.tuweni.ethstats.EthStatsServer;
import org.apache.tuweni.ethstats.EthStatsServerController;
import org.apache.tuweni.rlpx.RLPxService;
import org.apache.tuweni.rlpx.vertx.VertxRLPxService;
import org.apache.tuweni.rlpx.wire.WireConnection;
import org.apache.tuweni.units.bigints.UInt256;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.flywaydb.core.Flyway;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lorg/apache/tuweni/eth/crawler/CrawlerApp;", "", "()V", "main", "", "args", "", "", "([Ljava/lang/String;)V", "run", "vertx", "Lio/vertx/core/Vertx;", "config", "Lorg/apache/tuweni/eth/crawler/CrawlerConfig;", "eth-crawler"})
public final class CrawlerApp {
    @NotNull
    public static final CrawlerApp INSTANCE;

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String[] stringArray = args;
        boolean bl = false;
        String[] stringArray2 = stringArray;
        boolean bl2 = false;
        Path configFile = Paths.get(!(stringArray2.length == 0) ? args[0] : "config.toml", new String[0]);
        Security.addProvider((Provider)new BouncyCastleProvider());
        Vertx vertx = Vertx.vertx();
        Path path = configFile;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"configFile");
        CrawlerConfig config = new CrawlerConfig(path);
        if (config.getConfig().hasErrors()) {
            for (ConfigurationError error : config.getConfig().errors()) {
                String string = error.getMessage();
                boolean bl3 = false;
                System.out.println((Object)string);
            }
            System.exit(1);
        }
        Vertx vertx2 = vertx;
        Intrinsics.checkNotNullExpressionValue((Object)vertx2, (String)"vertx");
        INSTANCE.run(vertx2, config);
    }

    /*
     * WARNING - void declaration
     */
    public final void run(@NotNull Vertx vertx, @NotNull CrawlerConfig config) {
        void restService;
        void scraper;
        Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        HikariDataSource ds = new HikariDataSource();
        ds.setJdbcUrl(config.jdbcUrl());
        Flyway flyway = Flyway.configure().dataSource((DataSource)ds).load();
        flyway.migrate();
        RelationalPeerRepository repo = new RelationalPeerRepository((DataSource)ds, null, 2, null);
        EthClientKt.getLogger().info("Initial bootnodes: " + config.bootNodes());
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        List<URI> list = config.bootNodes();
        SocketAddress socketAddress = SocketAddress.inetSocketAddress((int)config.discoveryPort(), (String)config.discoveryNetworkInterface());
        Intrinsics.checkNotNullExpressionValue((Object)socketAddress, (String)"SocketAddress.inetSocket\u2026coveryNetworkInterface())");
        objectRef.element = new Scraper(null, vertx, list, socketAddress, (PeerRepository)repo, null, 0L, 97, null);
        byte[] contents = config.network() == null ? Files.readAllBytes(Paths.get(config.genesisFile(), new String[0])) : CrawlerApp.class.getResourceAsStream('/' + config.network() + ".json").readAllBytes();
        GenesisFile genesisFile = GenesisFile.read((byte[])contents);
        Block genesisBlock = genesisFile.toBlock();
        GenesisFile genesisFile2 = genesisFile;
        Intrinsics.checkNotNullExpressionValue((Object)genesisFile2, (String)"genesisFile");
        UInt256 uInt256 = UInt256.valueOf((long)genesisFile2.getChainId());
        Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"UInt256.valueOf(genesisFile.chainId.toLong())");
        Block block = genesisBlock;
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"genesisBlock");
        BlockHeader blockHeader = block.getHeader();
        Intrinsics.checkNotNullExpressionValue((Object)blockHeader, (String)"genesisBlock.header");
        UInt256 uInt2562 = blockHeader.getDifficulty();
        Intrinsics.checkNotNullExpressionValue((Object)uInt2562, (String)"genesisBlock.header.difficulty");
        BlockHeader blockHeader2 = genesisBlock.getHeader();
        Intrinsics.checkNotNullExpressionValue((Object)blockHeader2, (String)"genesisBlock.header");
        Hash hash = blockHeader2.getHash();
        Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"genesisBlock.header.hash");
        UInt256 uInt2563 = UInt256.valueOf((long)42L);
        Intrinsics.checkNotNullExpressionValue((Object)uInt2563, (String)"UInt256.valueOf(42L)");
        BlockHeader blockHeader3 = genesisBlock.getHeader();
        Intrinsics.checkNotNullExpressionValue((Object)blockHeader3, (String)"genesisBlock.header");
        Hash hash2 = blockHeader3.getHash();
        Intrinsics.checkNotNullExpressionValue((Object)hash2, (String)"genesisBlock.header.hash");
        List list2 = genesisFile.getForks();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"genesisFile.forks");
        SimpleBlockchainInformation blockchainInformation = new SimpleBlockchainInformation(uInt256, uInt2562, hash, uInt2563, hash2, list2);
        EthHelloSubprotocol ethHelloProtocol2 = new EthHelloSubprotocol(null, (BlockchainInformation)blockchainInformation, (Function2)new Function2<WireConnection, Status, Unit>(repo){
            final /* synthetic */ RelationalPeerRepository $repo;

            public final void invoke(@NotNull WireConnection conn, @NotNull Status status) {
                Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
                Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                this.$repo.recordInfo(conn, status);
            }
            {
                this.$repo = relationalPeerRepository;
                super(2);
            }
        }, 1, null);
        VertxRLPxService rlpxService = new VertxRLPxService(vertx, 0, "127.0.0.1", 0, SECP256K1.KeyPair.random(), CollectionsKt.listOf((Object)ethHelloProtocol2), "Apache Tuweni network crawler");
        repo.addListener((Function1<? super Peer, Unit>)((Function1)new Function1<Peer, Unit>(rlpxService){
            final /* synthetic */ VertxRLPxService $rlpxService;

            public final void invoke(@NotNull Peer it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Integer n = it.getEndpoint().getTcpPort();
                CrawlerAppKt.connect((RLPxService)this.$rlpxService, it.getNodeId(), new InetSocketAddress(it.getEndpoint().getAddress(), n != null ? n : 30303));
            }
            {
                this.$rlpxService = vertxRLPxService;
                super(1);
            }
        }));
        Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
        int n = config.restPort();
        String string = config.restNetworkInterface();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"config.restNetworkInterface()");
        objectRef2.element = new CrawlerRESTService(n, string, null, repo, null, 20, null);
        AtomicBoolean refreshLoop = new AtomicBoolean(true);
        EthstatsDataRepository ethstatsDataRepository = new EthstatsDataRepository((DataSource)ds, null, 2, null);
        String string2 = config.ethstatsNetworkInterface();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"config.ethstatsNetworkInterface()");
        int n2 = config.ethstatsPort();
        String string3 = config.ethstatsSecret();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"config.ethstatsSecret()");
        EthStatsServer ethstatsServer = new EthStatsServer(vertx, string2, n2, string3, null, (EthStatsServerController)new CrawlerEthstatsController(ethstatsDataRepository), null, 80, null);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(refreshLoop, (Ref.ObjectRef)scraper, rlpxService, (Ref.ObjectRef)restService, ethstatsServer){
            final /* synthetic */ AtomicBoolean $refreshLoop;
            final /* synthetic */ Ref.ObjectRef $scraper;
            final /* synthetic */ VertxRLPxService $rlpxService;
            final /* synthetic */ Ref.ObjectRef $restService;
            final /* synthetic */ EthStatsServer $ethstatsServer;

            public final void run() {
                BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    private /* synthetic */ Object L$0;
                    int label;
                    final /* synthetic */ run.2 this$0;

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                $this$runBlocking = (CoroutineScope)this.L$0;
                                this.this$0.$refreshLoop.set(false);
                                this.L$0 = $this$runBlocking;
                                this.label = 1;
                                v0 = ((Scraper)this.this$0.$scraper.element).stop().await((Continuation)this);
                                if (v0 == var3_2) {
                                    return var3_2;
                                }
                                ** GOTO lbl17
                            }
                            case 1: {
                                $this$runBlocking = (CoroutineScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl17:
                                // 2 sources

                                v1 = this.this$0.$rlpxService.stop();
                                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"rlpxService.stop()");
                                this.L$0 = $this$runBlocking;
                                this.label = 2;
                                v2 = AsyncCompletionKt.await((AsyncCompletion)v1, (Continuation)this);
                                if (v2 == var3_2) {
                                    return var3_2;
                                }
                                ** GOTO lbl29
                            }
                            case 2: {
                                $this$runBlocking = (CoroutineScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v2 = $result;
lbl29:
                                // 2 sources

                                this.L$0 = $this$runBlocking;
                                this.label = 3;
                                v3 = ((CrawlerRESTService)this.this$0.$restService.element).stop().await((Continuation)this);
                                if (v3 == var3_2) {
                                    return var3_2;
                                }
                                ** GOTO lbl39
                            }
                            case 3: {
                                $this$runBlocking = (CoroutineScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v3 = $result;
lbl39:
                                // 2 sources

                                this.L$0 = null;
                                this.label = 4;
                                v4 = BuildersKt.async$default((CoroutineScope)$this$runBlocking, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                                    int label;
                                    final /* synthetic */ run.1 this$0;

                                    /*
                                     * WARNING - void declaration
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                this.label = 1;
                                                Object object3 = this.this$0.this$0.$ethstatsServer.stop((Continuation)this);
                                                if (object3 != object2) return Unit.INSTANCE;
                                                return object2;
                                            }
                                            case 1: {
                                                void $result;
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object3 = $result;
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        super(2, continuation);
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                        Intrinsics.checkNotNullParameter(completion, (String)"completion");
                                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                        return function2;
                                    }

                                    public final Object invoke(Object object, Object object2) {
                                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)3, null).await((Continuation)this);
                                if (v4 == var3_2) {
                                    return var3_2;
                                }
                                ** GOTO lbl48
                            }
                            case 4: {
                                ResultKt.throwOnFailure((Object)$result);
                                v4 = $result;
lbl48:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.this$0 = var1_1;
                        super(2, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                        Intrinsics.checkNotNullParameter(completion, (String)"completion");
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        Object object = var3_3.L$0 = value;
                        return var3_3;
                    }

                    public final Object invoke(Object object, Object object2) {
                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)1, null);
            }
            {
                this.$refreshLoop = atomicBoolean;
                this.$scraper = objectRef;
                this.$rlpxService = vertxRLPxService;
                this.$restService = objectRef2;
                this.$ethstatsServer = ethStatsServer;
            }
        }));
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Job>, Object>((Ref.ObjectRef)restService, refreshLoop, repo, rlpxService, (Ref.ObjectRef)scraper, ethstatsServer, null){
            private /* synthetic */ Object L$0;
            int label;
            final /* synthetic */ Ref.ObjectRef $restService;
            final /* synthetic */ AtomicBoolean $refreshLoop;
            final /* synthetic */ RelationalPeerRepository $repo;
            final /* synthetic */ VertxRLPxService $rlpxService;
            final /* synthetic */ Ref.ObjectRef $scraper;
            final /* synthetic */ EthStatsServer $ethstatsServer;

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$runBlocking = (CoroutineScope)this.L$0;
                        this.L$0 = $this$runBlocking;
                        this.label = 1;
                        v0 = ((CrawlerRESTService)this.$restService.element).start().await((Continuation)this);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        $this$runBlocking = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        BuildersKt.launch$default((CoroutineScope)$this$runBlocking, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                            int label;
                            final /* synthetic */ run.3 this$0;

                            /*
                             * Unable to fully structure code
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object var1_1) {
                                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
lbl5:
                                        // 3 sources

                                        while (this.this$0.$refreshLoop.get()) {
                                            try {
                                                for (PeerConnectionInfo connectionInfo : RelationalPeerRepository.getPeers$eth_crawler$default(this.this$0.$repo, System.currentTimeMillis() - (long)3600000, null, null, 6, null)) {
                                                    CrawlerAppKt.connect((RLPxService)this.this$0.$rlpxService, connectionInfo.getNodeId(), new InetSocketAddress(connectionInfo.getHost(), connectionInfo.getPort() == 0 ? 30303 : connectionInfo.getPort()));
                                                }
                                            }
                                            catch (Exception e) {
                                                EthClientKt.getLogger().error("Error connecting to pending peers", (Throwable)e);
                                            }
                                            this.label = 1;
                                            v0 = DelayKt.delay((long)300000L, (Continuation)this);
                                            if (v0 != var4_2) continue;
                                            return var4_2;
                                        }
                                        break;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
                                        ** GOTO lbl5
                                    }
                                }
                                return Unit.INSTANCE;
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }
                            {
                                this.this$0 = var1_1;
                                super(2, continuation);
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                return function2;
                            }

                            public final Object invoke(Object object, Object object2) {
                                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        v1 = this.$rlpxService.start();
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"rlpxService.start()");
                        this.L$0 = $this$runBlocking;
                        this.label = 2;
                        v2 = AsyncCompletionKt.await((AsyncCompletion)v1, (Continuation)this);
                        if (v2 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl30
                    }
                    case 2: {
                        $this$runBlocking = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl30:
                        // 2 sources

                        ((Scraper)this.$scraper.element).start();
                        this.L$0 = $this$runBlocking;
                        this.label = 3;
                        v3 = this.$ethstatsServer.start((Continuation)this);
                        if (v3 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl42
                    }
                    case 3: {
                        $this$runBlocking = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl42:
                        // 2 sources

                        return BuildersKt.launch$default((CoroutineScope)$this$runBlocking, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                            int label;
                            final /* synthetic */ run.3 this$0;

                            /*
                             * Unable to fully structure code
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object var1_1) {
                                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
lbl5:
                                        // 3 sources

                                        while (this.this$0.$refreshLoop.get()) {
                                            try {
                                                for (PeerConnectionInfo connectionInfo : this.this$0.$repo.getPendingPeers$eth_crawler()) {
                                                    CrawlerAppKt.connect((RLPxService)this.this$0.$rlpxService, connectionInfo.getNodeId(), new InetSocketAddress(connectionInfo.getHost(), connectionInfo.getPort() == 0 ? 30303 : connectionInfo.getPort()));
                                                }
                                            }
                                            catch (Exception e) {
                                                EthClientKt.getLogger().error("Error connecting to pending peers", (Throwable)e);
                                            }
                                            this.label = 1;
                                            v0 = DelayKt.delay((long)120000L, (Continuation)this);
                                            if (v0 != var4_2) continue;
                                            return var4_2;
                                        }
                                        break;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
                                        ** GOTO lbl5
                                    }
                                }
                                return Unit.INSTANCE;
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }
                            {
                                this.this$0 = var1_1;
                                super(2, continuation);
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                return function2;
                            }

                            public final Object invoke(Object object, Object object2) {
                                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.$restService = objectRef;
                this.$refreshLoop = atomicBoolean;
                this.$repo = relationalPeerRepository;
                this.$rlpxService = vertxRLPxService;
                this.$scraper = objectRef2;
                this.$ethstatsServer = ethStatsServer;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                Object object = var3_3.L$0 = value;
                return var3_3;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    private CrawlerApp() {
    }

    static {
        CrawlerApp crawlerApp;
        INSTANCE = crawlerApp = new CrawlerApp();
    }
}

