/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.ethstats;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.TimeoutStream;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.kotlin.core.http.HttpClientKt;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import org.apache.tuweni.concurrent.AsyncResult;
import org.apache.tuweni.concurrent.CompletableAsyncResult;
import org.apache.tuweni.concurrent.coroutines.AsyncResultKt;
import org.apache.tuweni.eth.EthJsonModule;
import org.apache.tuweni.ethstats.AuthMessage;
import org.apache.tuweni.ethstats.BlockStats;
import org.apache.tuweni.ethstats.EthStatsReporter;
import org.apache.tuweni.ethstats.NodeInfo;
import org.apache.tuweni.ethstats.NodeStats;
import org.apache.tuweni.units.bigints.UInt256;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 P2\u00020\u0001:\u0001PB\u0095\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u0005\u0012\u0006\u0010\u000f\u001a\u00020\u0005\u0012\u0006\u0010\u0010\u001a\u00020\u0005\u0012\u0006\u0010\u0011\u001a\u00020\u0005\u0012\u0018\u0010\u0012\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0007\u0012\u0004\u0012\u00020\u00150\u0013\u0012\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u0012\b\b\u0002\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\u0002\u0010\u001bJ\u0019\u0010.\u001a\u00020\u00152\u0006\u0010/\u001a\u00020\bH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00100J\u001f\u00101\u001a\b\u0012\u0004\u0012\u000203022\u0006\u0010/\u001a\u00020\bH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00100J\u0018\u00104\u001a\u00020\u00152\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0002J\u0010\u00109\u001a\u00020\u00152\u0006\u00107\u001a\u000208H\u0002J\u0018\u0010:\u001a\u00020\u00152\u0006\u0010/\u001a\u00020\b2\u0006\u00107\u001a\u000208H\u0002J\u0010\u0010;\u001a\u00020\u00152\u0006\u0010<\u001a\u00020=H\u0002J\u0014\u0010>\u001a\u00020\u00152\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\"0\u0007J\u000e\u0010@\u001a\u00020\u00152\u0006\u0010A\u001a\u00020\"J\u000e\u0010B\u001a\u00020\u00152\u0006\u0010C\u001a\u00020%J\u000e\u0010D\u001a\u00020\u00152\u0006\u0010E\u001a\u00020\rJ\u0011\u0010F\u001a\u00020\u0015H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010GJ\u0011\u0010H\u001a\u00020\u0015H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010GJ\u0011\u0010I\u001a\u00020\u0015H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010GJ \u0010J\u001a\u00020\u00152\u0006\u00107\u001a\u0002082\u0006\u0010K\u001a\u00020\u00052\u0006\u0010L\u001a\u00020MH\u0002J(\u0010J\u001a\u00020\u00152\u0006\u00107\u001a\u0002082\u0006\u0010K\u001a\u00020\u00052\u0006\u0010N\u001a\u00020\u00052\u0006\u0010L\u001a\u00020MH\u0002J\u0010\u0010O\u001a\u00020\u00152\u0006\u00107\u001a\u000208H\u0002R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0007\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0\u00070!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020%0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020\r0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010'\u001a\u00020(\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006Q"}, d2={"Lorg/apache/tuweni/ethstats/EthStatsReporter;", "Lkotlinx/coroutines/CoroutineScope;", "vertx", "Lio/vertx/core/Vertx;", "id", "", "ethstatsServerURIs", "", "Ljava/net/URI;", "secret", "name", "node", "port", "", "network", "protocol", "os", "osVer", "historyRequester", "Lkotlin/Function1;", "Lorg/apache/tuweni/units/bigints/UInt256;", "", "timeSupplier", "Lkotlin/Function0;", "Ljava/time/Instant;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "(Lio/vertx/core/Vertx;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;Lkotlin/coroutines/CoroutineContext;)V", "client", "Lio/vertx/core/http/HttpClient;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "newHead", "Ljava/util/concurrent/atomic/AtomicReference;", "Lorg/apache/tuweni/ethstats/BlockStats;", "newHistory", "newNodeStats", "Lorg/apache/tuweni/ethstats/NodeStats;", "newTxCount", "nodeInfo", "Lorg/apache/tuweni/ethstats/NodeInfo;", "getNodeInfo", "()Lorg/apache/tuweni/ethstats/NodeInfo;", "started", "Ljava/util/concurrent/atomic/AtomicBoolean;", "waitingOnPong", "attemptConnect", "uri", "(Ljava/net/URI;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "connect", "Lorg/apache/tuweni/concurrent/AsyncResult;", "", "handleEmitEvent", "event", "Lcom/fasterxml/jackson/databind/node/ArrayNode;", "ws", "Lio/vertx/core/http/WebSocket;", "report", "reportPeriodically", "requestHistory", "list", "Lcom/fasterxml/jackson/databind/JsonNode;", "sendHistoryResponse", "blocks", "sendNewHead", "newBlockStats", "sendNewNodeStats", "nodeStats", "sendNewPendingTransactionCount", "txCount", "start", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "startInternal", "stop", "writeCommand", "command", "payload", "", "key", "writePing", "Companion", "ethstats"})
public final class EthStatsReporter
implements CoroutineScope {
    @NotNull
    private final NodeInfo nodeInfo;
    private final AtomicBoolean started;
    private HttpClient client;
    private final AtomicReference<Integer> newTxCount;
    private final AtomicReference<BlockStats> newHead;
    private final AtomicReference<NodeStats> newNodeStats;
    private final AtomicReference<List<BlockStats>> newHistory;
    private final AtomicBoolean waitingOnPong;
    private final Vertx vertx;
    private final String id;
    private final List<URI> ethstatsServerURIs;
    private final String secret;
    private final String name;
    private final String node;
    private final int port;
    private final String network;
    private final String protocol;
    private final String os;
    private final String osVer;
    private final Function1<List<UInt256>, Unit> historyRequester;
    private final Function0<Instant> timeSupplier;
    @NotNull
    private final CoroutineContext coroutineContext;
    @NotNull
    private static final ObjectMapper mapper;
    private static final Logger logger;
    public static final long DELAY = 5000L;
    public static final long REPORTING_PERIOD = 1000L;
    public static final long PING_PERIOD = 15000L;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final NodeInfo getNodeInfo() {
        return this.nodeInfo;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object start(@NotNull Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof start.1)) ** GOTO lbl-1000
        var3_2 = var1_1;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ EthStatsReporter this$0;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.start((Continuation<? super Unit>)this);
                }
                {
                    this.this$0 = ethStatsReporter;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.started.compareAndSet(false, true)) {
                    this.client = this.vertx.createHttpClient(new HttpClientOptions().setLogActivity(true));
                    $continuation.label = 1;
                    v0 = this.startInternal((Continuation<? super Unit>)$continuation);
                    if (v0 == var4_4) {
                        return var4_4;
                    }
                }
                ** GOTO lbl22
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object stop(@NotNull Continuation<? super Unit> $completion) {
        block1: {
            if (!this.started.compareAndSet(true, false)) break block1;
            logger.debug("Stopping the ethstats client service");
            HttpClient httpClient = this.client;
            if (httpClient != null) {
                httpClient.close();
            }
        }
        return Unit.INSTANCE;
    }

    public final void sendNewHead(@NotNull BlockStats newBlockStats) {
        Intrinsics.checkNotNullParameter((Object)newBlockStats, (String)"newBlockStats");
        this.newHead.set(newBlockStats);
    }

    public final void sendNewPendingTransactionCount(int txCount) {
        this.newTxCount.set(txCount);
    }

    public final void sendNewNodeStats(@NotNull NodeStats nodeStats) {
        Intrinsics.checkNotNullParameter((Object)nodeStats, (String)"nodeStats");
        this.newNodeStats.set(nodeStats);
    }

    public final void sendHistoryResponse(@NotNull List<BlockStats> blocks) {
        Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
        this.newHistory.set(blocks);
    }

    final /* synthetic */ Object startInternal(Continuation<? super Unit> $completion) {
        for (URI uri : this.ethstatsServerURIs) {
            BuildersKt.launch$default((CoroutineScope)this, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, uri, null){
                int label;
                final /* synthetic */ EthStatsReporter this$0;
                final /* synthetic */ URI $uri;

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = this.this$0.attemptConnect(this.$uri, (Continuation<? super Unit>)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.this$0 = ethStatsReporter;
                    this.$uri = uRI;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkNotNullParameter(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    final /* synthetic */ Object attemptConnect(URI var1_1, Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof attemptConnect.1)) ** GOTO lbl-1000
        var4_3 = var2_2;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ EthStatsReporter this$0;
                Object L$0;
                Object L$1;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.attemptConnect(null, (Continuation<? super Unit>)this);
                }
                {
                    this.this$0 = ethStatsReporter;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
lbl12:
                // 2 sources

                while (true) {
                    $continuation.L$0 = this;
                    $continuation.L$1 = uri;
                    $continuation.label = 1;
                    v0 = this.connect(uri, (Continuation<? super AsyncResult<Boolean>>)$continuation);
                    if (v0 == var5_5) {
                        return var5_5;
                    }
                    ** GOTO lbl25
                    break;
                }
            }
            case 1: {
                uri = (URI)$continuation.L$1;
                this = (EthStatsReporter)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                $continuation.L$0 = this;
                $continuation.L$1 = uri;
                $continuation.label = 2;
                v1 = AsyncResultKt.await((AsyncResult)((AsyncResult)v0), (Continuation)$continuation);
                if (v1 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl37
            }
            case 2: {
                uri = (URI)$continuation.L$1;
                this = (EthStatsReporter)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl37:
                // 2 sources

                if (((Boolean)v1).booleanValue() || !this.started.get()) break;
                $continuation.L$0 = this;
                $continuation.L$1 = uri;
                $continuation.label = 3;
                v2 = DelayKt.delay((long)5000L, (Continuation)$continuation);
                if (v2 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl50
            }
            case 3: {
                uri = (URI)$continuation.L$1;
                this = (EthStatsReporter)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl50:
                // 2 sources

                ** continue;
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    final /* synthetic */ Object connect(URI var1_1, Continuation<? super AsyncResult<Boolean>> var2_2) {
        if (!(var2_2 instanceof connect.1)) ** GOTO lbl-1000
        var7_3 = var2_2;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ EthStatsReporter this$0;
                Object L$0;
                Object L$1;
                Object L$2;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.connect(null, (Continuation<? super AsyncResult<Boolean>>)this);
                }
                {
                    this.this$0 = ethStatsReporter;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                result = AsyncResult.incomplete();
                options = new WebSocketConnectOptions().setHost(uri.getHost()).setPort(uri.getPort()).setHeaders(MultiMap.caseInsensitiveMultiMap().add("origin", "http://localhost"));
                v0 = this.client;
                Intrinsics.checkNotNull((Object)v0);
                v1 = options;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"options");
                $continuation.L$0 = this;
                $continuation.L$1 = uri;
                $continuation.L$2 = result;
                $continuation.label = 1;
                v2 = HttpClientKt.webSocketAwait((HttpClient)v0, (WebSocketConnectOptions)v1, (Continuation)$continuation);
                if (v2 == var8_5) {
                    return var8_5;
                }
                ** GOTO lbl32
            }
            case 1: {
                result = (CompletableAsyncResult)$continuation.L$2;
                uri = (URI)$continuation.L$1;
                this = (EthStatsReporter)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl32:
                // 2 sources

                ws = (WebSocket)v2;
                ws.closeHandler((Handler)new Handler<Void>(this, uri){
                    final /* synthetic */ EthStatsReporter this$0;
                    final /* synthetic */ URI $uri;

                    public final void handle(Void it) {
                        BuildersKt.launch$default((CoroutineScope)this.this$0, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                            int label;
                            final /* synthetic */ connect.2 this$0;

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = this.this$0.this$0.attemptConnect(this.this$0.$uri, (Continuation<? super Unit>)this);
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }
                            {
                                this.this$0 = var1_1;
                                super(2, continuation);
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                return function2;
                            }

                            public final Object invoke(Object object, Object object2) {
                                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                    }
                    {
                        this.this$0 = ethStatsReporter;
                        this.$uri = uRI;
                    }
                });
                ws.exceptionHandler((Handler)connect.3.INSTANCE);
                ws.textMessageHandler((Handler)new Handler<String>(this, result, uri, ws){
                    final /* synthetic */ EthStatsReporter this$0;
                    final /* synthetic */ CompletableAsyncResult $result;
                    final /* synthetic */ URI $uri;
                    final /* synthetic */ WebSocket $ws;

                    public final void handle(String message) {
                        try {
                            JsonNode emitEvent;
                            JsonNode node = EthStatsReporter.Companion.getMapper().readTree(message);
                            JsonNode jsonNode = emitEvent = node.get("emit");
                            Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"emitEvent");
                            if (jsonNode.isArray()) {
                                String eventValue = emitEvent.get(0).textValue();
                                CompletableAsyncResult completableAsyncResult = this.$result;
                                Intrinsics.checkNotNullExpressionValue((Object)completableAsyncResult, (String)"result");
                                if (!completableAsyncResult.isDone()) {
                                    if (Intrinsics.areEqual((Object)"ready", (Object)eventValue) ^ true) {
                                        EthStatsReporter.Companion.getLogger().warn(message);
                                        this.$result.complete((Object)false);
                                    } else {
                                        EthStatsReporter.Companion.getLogger().debug("Connected OK! {}", (Object)message);
                                        this.$result.complete((Object)true);
                                        EthStatsReporter.access$reportPeriodically(this.this$0, this.$uri, this.$ws);
                                        EthStatsReporter.access$writePing(this.this$0, this.$ws);
                                        EthStatsReporter.access$report(this.this$0, this.$ws);
                                    }
                                } else {
                                    EthStatsReporter.access$handleEmitEvent(this.this$0, (ArrayNode)emitEvent, this.$ws);
                                }
                            } else {
                                EthStatsReporter.Companion.getLogger().warn(message);
                                this.$result.complete((Object)false);
                            }
                        }
                        catch (IOException e) {
                            throw (Throwable)new UncheckedIOException(e);
                        }
                    }
                    {
                        this.this$0 = ethStatsReporter;
                        this.$result = completableAsyncResult;
                        this.$uri = uRI;
                        this.$ws = webSocket;
                    }
                });
                this.writeCommand(ws, "hello", new AuthMessage(this.nodeInfo, this.id, this.secret));
                v3 = result;
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"result");
                return v3;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void handleEmitEvent(ArrayNode event, WebSocket ws) {
        String command = event.get(0).textValue();
        String string = command;
        if (Intrinsics.areEqual((Object)string, (Object)"node-pong")) {
            logger.debug("Received a pong {}", (Object)event.get(1));
            if (!this.waitingOnPong.compareAndSet(true, false)) {
                logger.warn("Received pong when we didn't expect one");
            } else {
                long start2 = event.get(1).get("clientTime").longValue();
                long latency = (Instant.now().toEpochMilli() - start2) / (long)2000;
                this.writeCommand(ws, "latency", "latency", latency);
            }
        } else if (Intrinsics.areEqual((Object)string, (Object)"history")) {
            logger.debug("History request {}", (Object)event.get(1));
            JsonNode jsonNode = event.get(1);
            Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"event.get(1)");
            this.requestHistory(jsonNode);
        } else {
            logger.warn("Unexpected message {}", (Object)command);
        }
    }

    private final void requestHistory(JsonNode list) {
        boolean bl = false;
        List request = new ArrayList();
        for (JsonNode elt : list) {
            UInt256 uInt256 = UInt256.fromHexString((String)elt.asText());
            Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"UInt256.fromHexString(elt.asText())");
            request.add(uInt256);
        }
        this.historyRequester.invoke((Object)request);
    }

    private final void writePing(WebSocket ws) {
        this.waitingOnPong.set(true);
        this.writeCommand(ws, "node-ping", "clientTime", this.timeSupplier.invoke());
    }

    private final void reportPeriodically(URI uri, WebSocket ws) {
        TimeoutStream reportingStream2 = this.vertx.periodicStream(1000L).handler((Handler)new Handler<Long>(this, ws){
            final /* synthetic */ EthStatsReporter this$0;
            final /* synthetic */ WebSocket $ws;

            public final void handle(Long it) {
                EthStatsReporter.access$report(this.this$0, this.$ws);
            }
            {
                this.this$0 = ethStatsReporter;
                this.$ws = webSocket;
            }
        });
        TimeoutStream pingStream2 = this.vertx.periodicStream(15000L).handler((Handler)new Handler<Long>(this, ws){
            final /* synthetic */ EthStatsReporter this$0;
            final /* synthetic */ WebSocket $ws;

            public final void handle(Long it) {
                EthStatsReporter.access$writePing(this.this$0, this.$ws);
            }
            {
                this.this$0 = ethStatsReporter;
                this.$ws = webSocket;
            }
        });
        ws.closeHandler((Handler)new Handler<Void>(this, reportingStream2, pingStream2, uri){
            final /* synthetic */ EthStatsReporter this$0;
            final /* synthetic */ TimeoutStream $reportingStream;
            final /* synthetic */ TimeoutStream $pingStream;
            final /* synthetic */ URI $uri;

            public final void handle(Void it) {
                this.$reportingStream.cancel();
                this.$pingStream.cancel();
                BuildersKt.launch$default((CoroutineScope)this.this$0, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ reportPeriodically.1 this$0;

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = this.this$0.this$0.attemptConnect(this.this$0.$uri, (Continuation<? super Unit>)this);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.this$0 = var1_1;
                        super(2, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                        Intrinsics.checkNotNullParameter(completion, (String)"completion");
                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        return function2;
                    }

                    public final Object invoke(Object object, Object object2) {
                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
            {
                this.this$0 = ethStatsReporter;
                this.$reportingStream = timeoutStream;
                this.$pingStream = timeoutStream2;
                this.$uri = uRI;
            }
        });
    }

    private final void report(WebSocket ws) {
        List newBlocks;
        NodeStats nodeStats;
        Integer count;
        BlockStats head = this.newHead.getAndSet(null);
        if (head != null) {
            this.writeCommand(ws, "block", "block", head);
        }
        if ((count = (Integer)this.newTxCount.getAndSet(null)) != null) {
            Map<String, Integer> map = Collections.singletonMap("pending", count);
            Intrinsics.checkNotNullExpressionValue(map, (String)"Collections.singletonMap(\"pending\", count)");
            this.writeCommand(ws, "pending", "stats", map);
        }
        if ((nodeStats = (NodeStats)this.newNodeStats.getAndSet(null)) != null) {
            this.writeCommand(ws, "stats", "stats", nodeStats);
        }
        if ((newBlocks = (List)this.newHistory.getAndSet(null)) != null && !newBlocks.isEmpty()) {
            this.writeCommand(ws, "history", "history", newBlocks);
        }
    }

    private final void writeCommand(WebSocket ws, String command, Object payload) {
        try {
            String message = mapper.writer().writeValueAsString(Collections.singletonMap("emit", Arrays.asList(command, payload)));
            logger.debug("Sending {} message {}", (Object)command, (Object)message);
            ws.writeTextMessage(message);
        }
        catch (JsonProcessingException e) {
            throw (Throwable)new UncheckedIOException((IOException)((Object)e));
        }
    }

    private final void writeCommand(WebSocket ws, String command, String key, Object payload) {
        boolean bl = false;
        Map body = new LinkedHashMap();
        body.put("id", this.id);
        body.put(key, payload);
        this.writeCommand(ws, command, body);
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    public EthStatsReporter(@NotNull Vertx vertx, @NotNull String id, @NotNull List<URI> ethstatsServerURIs, @NotNull String secret, @NotNull String name, @NotNull String node, int port, @NotNull String network, @NotNull String protocol, @NotNull String os, @NotNull String osVer, @NotNull Function1<? super List<UInt256>, Unit> historyRequester, @NotNull Function0<Instant> timeSupplier, @NotNull CoroutineContext coroutineContext) {
        Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(ethstatsServerURIs, (String)"ethstatsServerURIs");
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        Intrinsics.checkNotNullParameter((Object)osVer, (String)"osVer");
        Intrinsics.checkNotNullParameter(historyRequester, (String)"historyRequester");
        Intrinsics.checkNotNullParameter(timeSupplier, (String)"timeSupplier");
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        this.vertx = vertx;
        this.id = id;
        this.ethstatsServerURIs = ethstatsServerURIs;
        this.secret = secret;
        this.name = name;
        this.node = node;
        this.port = port;
        this.network = network;
        this.protocol = protocol;
        this.os = os;
        this.osVer = osVer;
        this.historyRequester = historyRequester;
        this.timeSupplier = timeSupplier;
        this.coroutineContext = coroutineContext;
        this.nodeInfo = new NodeInfo(this.name, this.node, this.port, this.network, this.protocol, null, this.os, this.osVer, false, null, 800, null);
        this.started = new AtomicBoolean(false);
        this.newTxCount = new AtomicReference();
        this.newHead = new AtomicReference();
        this.newNodeStats = new AtomicReference();
        this.newHistory = new AtomicReference();
        this.waitingOnPong = new AtomicBoolean(false);
    }

    public /* synthetic */ EthStatsReporter(Vertx vertx, String string, List list, String string2, String string3, String string4, int n, String string5, String string6, String string7, String string8, Function1 function1, Function0 function0, CoroutineContext coroutineContext, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x2000) != 0) {
            coroutineContext = (CoroutineContext)Dispatchers.getDefault();
        }
        this(vertx, string, list, string2, string3, string4, n, string5, string6, string7, string8, (Function1<? super List<UInt256>, Unit>)function1, (Function0<Instant>)function0, coroutineContext);
    }

    static {
        Companion = new Companion(null);
        mapper = new ObjectMapper();
        mapper.registerModule((Module)new EthJsonModule());
        logger = LoggerFactory.getLogger(EthStatsReporter.class);
    }

    public static final /* synthetic */ void access$reportPeriodically(EthStatsReporter $this, URI uri, WebSocket ws) {
        $this.reportPeriodically(uri, ws);
    }

    public static final /* synthetic */ void access$writePing(EthStatsReporter $this, WebSocket ws) {
        $this.writePing(ws);
    }

    public static final /* synthetic */ void access$report(EthStatsReporter $this, WebSocket ws) {
        $this.report(ws);
    }

    public static final /* synthetic */ void access$handleEmitEvent(EthStatsReporter $this, ArrayNode event, WebSocket ws) {
        $this.handleEmitEvent(event, ws);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/apache/tuweni/ethstats/EthStatsReporter$Companion;", "", "()V", "DELAY", "", "PING_PERIOD", "REPORTING_PERIOD", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/slf4j/Logger;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "ethstats"})
    public static final class Companion {
        @NotNull
        public final ObjectMapper getMapper() {
            return mapper;
        }

        public final Logger getLogger() {
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

