/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.tuweni.config.Configuration;
import org.apache.tuweni.config.ConfigurationError;
import org.apache.tuweni.config.DocumentPosition;
import org.apache.tuweni.config.InvalidConfigurationPropertyTypeException;
import org.apache.tuweni.config.NoConfigurationPropertyException;
import org.apache.tuweni.config.Schema;
import org.apache.tuweni.config.TomlSerializer;
import org.apache.tuweni.toml.Toml;
import org.apache.tuweni.toml.TomlArray;
import org.apache.tuweni.toml.TomlInvalidTypeException;
import org.apache.tuweni.toml.TomlParseResult;
import org.apache.tuweni.toml.TomlPosition;
import org.apache.tuweni.toml.TomlTable;

final class TomlBackedConfiguration
implements Configuration {
    private final TomlTable toml;
    private final Schema schema;
    private final List<ConfigurationError> errors;

    TomlBackedConfiguration(TomlParseResult toml, @Nullable Schema schema) {
        ArrayList<ConfigurationError> errors = new ArrayList<ConfigurationError>();
        toml.errors().forEach(err -> errors.add(new ConfigurationError(this.documentPosition(err.position()), err.getMessage(), (Throwable)err)));
        if (schema != null) {
            schema.validate(new TomlBackedConfiguration(toml, null)).forEach(errors::add);
        } else {
            schema = Schema.EMPTY;
        }
        this.toml = toml;
        this.schema = schema;
        this.errors = errors;
    }

    TomlBackedConfiguration(TomlTable toml, @Nullable Schema schema) {
        ArrayList<ConfigurationError> errors = new ArrayList<ConfigurationError>();
        if (schema != null) {
            schema.validate(new TomlBackedConfiguration(toml, null)).forEach(errors::add);
        } else {
            schema = Schema.EMPTY;
        }
        this.toml = toml;
        this.schema = schema;
        this.errors = errors;
    }

    @Override
    public List<ConfigurationError> errors() {
        return this.errors;
    }

    @Override
    public void toToml(Appendable appendable) throws IOException {
        new TomlSerializer(this, this.schema).writeTo(appendable);
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(this.toml.dottedKeySet());
        keys.addAll(this.schema.defaultsKeySet());
        return keys;
    }

    @Override
    public Set<String> keySet(String prefix) {
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(this.toml.dottedKeySet().stream().filter(key -> key.startsWith(prefix)).collect(Collectors.toSet()));
        keys.addAll(this.schema.defaultsKeySet(prefix));
        return keys;
    }

    @Override
    public Configuration getConfigurationSection(String name) {
        TomlTable table = this.toml.getTableOrEmpty(name);
        return new TomlBackedConfiguration(table, this.schema.getSubSection(name));
    }

    @Override
    public Set<String> sections(String prefix) {
        HashSet<String> keys = new HashSet<String>();
        TomlTable table = this.toml.getTable(prefix);
        if (table != null) {
            keys.addAll(table.keyPathSet().stream().map(key -> (String)key.get(0)).collect(Collectors.toSet()));
        }
        return keys;
    }

    @Override
    public boolean contains(String key) {
        return this.toml.contains(key) || this.schema.hasDefault(key);
    }

    @Override
    @Nullable
    public Object get(String key) {
        Object obj = this.toml.get(key);
        if (obj != null) {
            if (obj instanceof TomlArray) {
                return TomlBackedConfiguration.deepToList((TomlArray)obj);
            }
            if (obj instanceof TomlTable) {
                return TomlBackedConfiguration.deepToMap((TomlTable)obj);
            }
            return obj;
        }
        return this.schema.getDefault(key);
    }

    @Override
    @Nullable
    public DocumentPosition inputPositionOf(String key) {
        TomlPosition position = this.toml.inputPositionOf(key);
        if (position == null) {
            return null;
        }
        return this.documentPosition(position);
    }

    private DocumentPosition inputPositionOf(List<String> keyPath) {
        TomlPosition position = this.toml.inputPositionOf(keyPath);
        if (position == null) {
            return null;
        }
        return this.documentPosition(position);
    }

    @Override
    public String getString(String key) {
        String sectionKey = this.schema.getSubSectionPrefix(key);
        if (sectionKey == null) {
            return this.getValue(key, arg_0 -> ((TomlTable)this.toml).getString(arg_0), this.schema::getDefaultString);
        }
        Schema section = this.schema.getSubSection(sectionKey);
        String subSectionKey = key.substring(sectionKey.length() + 1);
        TomlTable table = this.toml.getTableOrEmpty(sectionKey);
        return this.getValue(subSectionKey, arg_0 -> ((TomlTable)table).getString(arg_0), section::getDefaultString);
    }

    @Override
    public int getInteger(String key) {
        TomlTable table;
        Schema section;
        String sectionKey = this.schema.getSubSectionPrefix(key);
        if (sectionKey != null) {
            section = this.schema.getSubSection(sectionKey);
            key = key.substring(sectionKey.length() + 1);
            table = this.toml.getTableOrEmpty(sectionKey);
        } else {
            section = this.schema;
            table = this.toml;
        }
        return this.getValue(key, keyPath -> {
            Long longValue = table.getLong(keyPath);
            if (longValue != null && (longValue > Integer.MAX_VALUE || longValue < Integer.MIN_VALUE)) {
                throw new InvalidConfigurationPropertyTypeException(this.inputPositionOf((List<String>)keyPath), "Value of property '" + Toml.joinKeyPath((List)keyPath) + "' is too large for an integer");
            }
            return longValue != null ? Integer.valueOf(longValue.intValue()) : null;
        }, section::getDefaultInteger);
    }

    @Override
    public long getLong(String key) {
        String sectionKey = this.schema.getSubSectionPrefix(key);
        if (sectionKey == null) {
            return this.getValue(key, arg_0 -> ((TomlTable)this.toml).getLong(arg_0), this.schema::getDefaultLong);
        }
        Schema section = this.schema.getSubSection(sectionKey);
        String subSectionKey = key.substring(sectionKey.length() + 1);
        TomlTable table = this.toml.getTableOrEmpty(sectionKey);
        return this.getValue(subSectionKey, arg_0 -> ((TomlTable)table).getLong(arg_0), section::getDefaultLong);
    }

    @Override
    public double getDouble(String key) {
        String sectionKey = this.schema.getSubSectionPrefix(key);
        if (sectionKey == null) {
            return this.getValue(key, arg_0 -> ((TomlTable)this.toml).getDouble(arg_0), this.schema::getDefaultDouble);
        }
        Schema section = this.schema.getSubSection(sectionKey);
        String subSectionKey = key.substring(sectionKey.length() + 1);
        TomlTable table = this.toml.getTableOrEmpty(sectionKey);
        return this.getValue(subSectionKey, arg_0 -> ((TomlTable)table).getDouble(arg_0), section::getDefaultDouble);
    }

    @Override
    public boolean getBoolean(String key) {
        String sectionKey = this.schema.getSubSectionPrefix(key);
        if (sectionKey == null) {
            return this.getValue(key, arg_0 -> ((TomlTable)this.toml).getBoolean(arg_0), this.schema::getDefaultBoolean);
        }
        Schema section = this.schema.getSubSection(sectionKey);
        String subSectionKey = key.substring(sectionKey.length() + 1);
        TomlTable table = this.toml.getTableOrEmpty(sectionKey);
        return this.getValue(subSectionKey, arg_0 -> ((TomlTable)table).getBoolean(arg_0), section::getDefaultBoolean);
    }

    @Override
    public Map<String, Object> getMap(String key) {
        TomlTable table;
        Schema section;
        String sectionKey = this.schema.getSubSectionPrefix(key);
        if (sectionKey != null) {
            section = this.schema.getSubSection(sectionKey);
            key = key.substring(sectionKey.length() + 1);
            table = this.toml.getTableOrEmpty(sectionKey);
        } else {
            section = this.schema;
            table = this.toml;
        }
        return this.getValue(key, keyPath -> {
            TomlTable map = table.getTable(keyPath);
            if (map == null) {
                return null;
            }
            return TomlBackedConfiguration.deepToMap(map);
        }, section::getDefaultMap);
    }

    @Override
    public List<Object> getList(String key) {
        TomlTable table;
        Schema section;
        String sectionKey = this.schema.getSubSectionPrefix(key);
        if (sectionKey != null) {
            section = this.schema.getSubSection(sectionKey);
            key = key.substring(sectionKey.length() + 1);
            table = this.toml.getTableOrEmpty(sectionKey);
        } else {
            section = this.schema;
            table = this.toml;
        }
        return this.getValue(key, keyPath -> {
            TomlArray array = table.getArray(keyPath);
            if (array == null) {
                return null;
            }
            return TomlBackedConfiguration.deepToList(array);
        }, section::getDefaultList);
    }

    @Override
    public List<String> getListOfString(String key) {
        return this.getList(key, "strings", TomlArray::containsStrings, schema -> schema::getDefaultListOfString);
    }

    @Override
    public List<Integer> getListOfInteger(String key) {
        return this.getValue(key, keyPath -> {
            TomlArray array = this.toml.getArray(keyPath);
            if (array == null) {
                return null;
            }
            if (!array.containsLongs()) {
                throw new InvalidConfigurationPropertyTypeException(this.inputPositionOf((List<String>)keyPath), "List property '" + Toml.joinKeyPath((List)keyPath) + "' does not contain integers");
            }
            List longList = array.toList();
            return IntStream.range(0, longList.size()).mapToObj(i -> {
                Long value = (Long)longList.get(i);
                if (value > Integer.MAX_VALUE) {
                    throw new InvalidConfigurationPropertyTypeException(this.inputPositionOf((List<String>)keyPath), "Value of property '" + Toml.joinKeyPath((List)keyPath) + "', index " + i + ", is too large for an integer");
                }
                return value.intValue();
            }).collect(Collectors.toList());
        }, this.schema::getDefaultListOfInteger);
    }

    @Override
    public List<Long> getListOfLong(String key) {
        return this.getList(key, "longs", TomlArray::containsLongs, schema -> schema::getDefaultListOfLong);
    }

    @Override
    public List<Double> getListOfDouble(String key) {
        return this.getList(key, "doubles", TomlArray::containsDoubles, schema -> schema::getDefaultListOfDouble);
    }

    @Override
    public List<Boolean> getListOfBoolean(String key) {
        return this.getList(key, "booleans", TomlArray::containsBooleans, schema -> schema::getDefaultListOfBoolean);
    }

    @Override
    public List<Map<String, Object>> getListOfMap(String key) {
        TomlTable table;
        Schema section;
        String sectionKey = this.schema.getSubSectionPrefix(key);
        if (sectionKey != null) {
            section = this.schema.getSubSection(sectionKey);
            key = key.substring(sectionKey.length() + 1);
            table = this.toml.getTableOrEmpty(sectionKey);
        } else {
            section = this.schema;
            table = this.toml;
        }
        return this.getValue(key, keyPath -> {
            TomlArray array = table.getArray(keyPath);
            if (array == null) {
                return null;
            }
            if (!array.containsTables()) {
                throw new InvalidConfigurationPropertyTypeException(this.inputPositionOf((List<String>)keyPath), "List property '" + Toml.joinKeyPath((List)keyPath) + "' does not contain maps");
            }
            List<Object> typedList = TomlBackedConfiguration.deepToList(array);
            return typedList;
        }, section::getDefaultListOfMap);
    }

    private DocumentPosition documentPosition(TomlPosition position) {
        return DocumentPosition.positionAt(position.line(), position.column());
    }

    private <T> T getValue(String key, Function<List<String>, T> tomlGet, Function<String, T> defaultGet) {
        T value;
        List keyPath = Toml.parseDottedKey((String)key);
        try {
            value = tomlGet.apply(keyPath);
        }
        catch (TomlInvalidTypeException e) {
            throw new InvalidConfigurationPropertyTypeException(this.inputPositionOf(keyPath), e.getMessage(), e);
        }
        if (value != null) {
            return value;
        }
        String canonicalKey = Toml.joinKeyPath((List)keyPath);
        value = defaultGet.apply(canonicalKey);
        if (value != null) {
            return value;
        }
        throw new NoConfigurationPropertyException("No value for property '" + canonicalKey + "'");
    }

    private <T> List<T> getList(String key, String typeName, Predicate<TomlArray> tomlCheck, Function<Schema, Function<String, List<T>>> defaultGet) {
        TomlTable table;
        Schema section;
        String sectionKey = this.schema.getSubSectionPrefix(key);
        if (sectionKey != null) {
            section = this.schema.getSubSection(sectionKey);
            key = key.substring(sectionKey.length() + 1);
            table = this.toml.getTableOrEmpty(sectionKey);
        } else {
            section = this.schema;
            table = this.toml;
        }
        Function<String, List<T>> defaultGetFn = defaultGet.apply(section);
        return this.getValue(key, keyPath -> {
            TomlArray array = table.getArray(keyPath);
            if (array == null) {
                return null;
            }
            if (!tomlCheck.test(array)) {
                throw new InvalidConfigurationPropertyTypeException(this.inputPositionOf((List<String>)keyPath), "List property '" + Toml.joinKeyPath((List)keyPath) + "' does not contain " + typeName);
            }
            List typedList = array.toList();
            return typedList;
        }, defaultGetFn);
    }

    private static List<Object> deepToList(TomlArray array) {
        return array.toList().stream().map(o -> {
            if (o instanceof TomlArray) {
                return TomlBackedConfiguration.deepToList((TomlArray)o);
            }
            if (o instanceof TomlTable) {
                return TomlBackedConfiguration.deepToMap((TomlTable)o);
            }
            return o;
        }).collect(Collectors.toList());
    }

    private static Map<String, Object> deepToMap(TomlTable table) {
        return table.toMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            Object o = e.getValue();
            if (o instanceof TomlArray) {
                return TomlBackedConfiguration.deepToList((TomlArray)o);
            }
            if (o instanceof TomlTable) {
                return TomlBackedConfiguration.deepToMap((TomlTable)o);
            }
            return o;
        }));
    }
}

