/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.jsonrpc;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import java.io.Closeable;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import org.apache.tuweni.eth.Address;
import org.apache.tuweni.eth.Transaction;
import org.apache.tuweni.jsonrpc.ClientRequestException;
import org.apache.tuweni.jsonrpc.JSONRPCClientKt;
import org.apache.tuweni.units.bigints.UInt256;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0019\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J\u0019\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J\u0019\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001cH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001dR\u0019\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001e"}, d2={"Lorg/apache/tuweni/jsonrpc/JSONRPCClient;", "Ljava/io/Closeable;", "vertx", "Lio/vertx/core/Vertx;", "serverPort", "", "serverHost", "", "(Lio/vertx/core/Vertx;ILjava/lang/String;)V", "client", "Lio/vertx/ext/web/client/WebClient;", "kotlin.jvm.PlatformType", "getClient", "()Lio/vertx/ext/web/client/WebClient;", "getServerHost", "()Ljava/lang/String;", "getServerPort", "()I", "close", "", "getBalance_latest", "Lorg/apache/tuweni/units/bigints/UInt256;", "address", "Lorg/apache/tuweni/eth/Address;", "(Lorg/apache/tuweni/eth/Address;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getTransactionCount_latest", "sendRawTransaction", "tx", "Lorg/apache/tuweni/eth/Transaction;", "(Lorg/apache/tuweni/eth/Transaction;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "jsonrpc"})
public final class JSONRPCClient
implements Closeable {
    private final WebClient client;
    private final int serverPort;
    @NotNull
    private final String serverHost;

    public final WebClient getClient() {
        return this.client;
    }

    @Nullable
    public final Object sendRawTransaction(@NotNull Transaction tx, @NotNull Continuation<? super String> $completion) {
        Map body = MapsKt.mapOf((Pair[])new Pair[]{new Pair((Object)"jsonrpc", (Object)"2.0"), new Pair((Object)"method", (Object)"eth_sendRawTransaction"), new Pair((Object)"id", (Object)Boxing.boxInt((int)1)), new Pair((Object)"params", (Object)CollectionsKt.listOf((Object)tx.toBytes().toHexString()))});
        CompletableDeferred deferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        this.client.post(this.serverPort, this.serverHost, "/").putHeader("Content-Type", "application/json").sendBuffer(Buffer.buffer((byte[])JSONRPCClientKt.getMapper().writeValueAsBytes((Object)body)), (Handler)new Handler<AsyncResult<HttpResponse<Buffer>>>(deferred){
            final /* synthetic */ CompletableDeferred $deferred;

            public final void handle(AsyncResult<HttpResponse<Buffer>> response) {
                if (response.failed()) {
                    Throwable throwable = response.cause();
                    Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"response.cause()");
                    this.$deferred.completeExceptionally(throwable);
                } else {
                    JsonObject jsonResponse = ((HttpResponse)response.result()).bodyAsJsonObject();
                    JsonObject err = jsonResponse.getJsonObject("error");
                    if (err != null) {
                        String errorMessage = "Code " + err.getInteger("code") + ": " + err.getString("message");
                        this.$deferred.completeExceptionally((Throwable)new ClientRequestException(errorMessage));
                    } else {
                        String string = jsonResponse.getString("result");
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonResponse.getString(\"result\")");
                        this.$deferred.complete((Object)string);
                    }
                }
            }
            {
                this.$deferred = completableDeferred;
            }
        });
        return deferred.await($completion);
    }

    @Nullable
    public final Object getBalance_latest(@NotNull Address address, @NotNull Continuation<? super UInt256> $completion) {
        Map body = MapsKt.mapOf((Pair[])new Pair[]{new Pair((Object)"jsonrpc", (Object)"2.0"), new Pair((Object)"method", (Object)"eth_getBalance"), new Pair((Object)"id", (Object)Boxing.boxInt((int)1)), new Pair((Object)"params", (Object)CollectionsKt.listOf((Object[])new String[]{address.toHexString(), "latest"}))});
        CompletableDeferred deferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        this.client.post(this.serverPort, this.serverHost, "/").putHeader("Content-Type", "application/json").sendBuffer(Buffer.buffer((byte[])JSONRPCClientKt.getMapper().writeValueAsBytes((Object)body)), (Handler)new Handler<AsyncResult<HttpResponse<Buffer>>>(deferred){
            final /* synthetic */ CompletableDeferred $deferred;

            public final void handle(AsyncResult<HttpResponse<Buffer>> response) {
                if (response.failed()) {
                    Throwable throwable = response.cause();
                    Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"response.cause()");
                    this.$deferred.completeExceptionally(throwable);
                } else {
                    JsonObject jsonResponse = ((HttpResponse)response.result()).bodyAsJsonObject();
                    UInt256 uInt256 = UInt256.fromHexString((String)jsonResponse.getString("result"));
                    Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"UInt256.fromHexString(js\u2026onse.getString(\"result\"))");
                    this.$deferred.complete((Object)uInt256);
                }
            }
            {
                this.$deferred = completableDeferred;
            }
        });
        return deferred.await($completion);
    }

    @Nullable
    public final Object getTransactionCount_latest(@NotNull Address address, @NotNull Continuation<? super UInt256> $completion) {
        Map body = MapsKt.mapOf((Pair[])new Pair[]{new Pair((Object)"jsonrpc", (Object)"2.0"), new Pair((Object)"method", (Object)"eth_getTransactionCount"), new Pair((Object)"id", (Object)Boxing.boxInt((int)1)), new Pair((Object)"params", (Object)CollectionsKt.listOf((Object[])new String[]{address.toHexString(), "latest"}))});
        CompletableDeferred deferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        this.client.post(this.serverPort, this.serverHost, "/").putHeader("Content-Type", "application/json").sendBuffer(Buffer.buffer((byte[])JSONRPCClientKt.getMapper().writeValueAsBytes((Object)body)), (Handler)new Handler<AsyncResult<HttpResponse<Buffer>>>(deferred){
            final /* synthetic */ CompletableDeferred $deferred;

            public final void handle(AsyncResult<HttpResponse<Buffer>> response) {
                if (response.failed()) {
                    Throwable throwable = response.cause();
                    Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"response.cause()");
                    this.$deferred.completeExceptionally(throwable);
                } else {
                    JsonObject jsonResponse = ((HttpResponse)response.result()).bodyAsJsonObject();
                    UInt256 uInt256 = UInt256.fromHexString((String)jsonResponse.getString("result"));
                    Intrinsics.checkNotNullExpressionValue((Object)uInt256, (String)"UInt256.fromHexString(js\u2026onse.getString(\"result\"))");
                    this.$deferred.complete((Object)uInt256);
                }
            }
            {
                this.$deferred = completableDeferred;
            }
        });
        return deferred.await($completion);
    }

    @Override
    public void close() {
        this.client.close();
    }

    public final int getServerPort() {
        return this.serverPort;
    }

    @NotNull
    public final String getServerHost() {
        return this.serverHost;
    }

    public JSONRPCClient(@NotNull Vertx vertx, int serverPort, @NotNull String serverHost) {
        Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
        Intrinsics.checkNotNullParameter((Object)serverHost, (String)"serverHost");
        this.serverPort = serverPort;
        this.serverHost = serverHost;
        this.client = WebClient.create((Vertx)vertx);
    }
}

