/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.evm.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.evm.EVMExecutionStatusCode;
import org.apache.tuweni.evm.EVMMessage;
import org.apache.tuweni.evm.EVMResult;
import org.apache.tuweni.evm.EthereumVirtualMachineKt;
import org.apache.tuweni.evm.EvmVm;
import org.apache.tuweni.evm.HardFork;
import org.apache.tuweni.evm.HostContext;
import org.apache.tuweni.evm.impl.GasManager;
import org.apache.tuweni.evm.impl.Memory;
import org.apache.tuweni.evm.impl.Opcode;
import org.apache.tuweni.evm.impl.OpcodeRegistry;
import org.apache.tuweni.evm.impl.Result;
import org.apache.tuweni.evm.impl.Stack;
import org.apache.tuweni.units.bigints.UInt256;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0011\u0010\u0005\u001a\u00020\u0006H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007J1\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0015H\u0016\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0019"}, d2={"Lorg/apache/tuweni/evm/impl/EvmVmImpl;", "Lorg/apache/tuweni/evm/EvmVm;", "()V", "capabilities", "", "close", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "execute", "Lorg/apache/tuweni/evm/EVMResult;", "hostContext", "Lorg/apache/tuweni/evm/HostContext;", "fork", "Lorg/apache/tuweni/evm/HardFork;", "msg", "Lorg/apache/tuweni/evm/EVMMessage;", "code", "Lorg/apache/tuweni/bytes/Bytes;", "(Lorg/apache/tuweni/evm/HostContext;Lorg/apache/tuweni/evm/HardFork;Lorg/apache/tuweni/evm/EVMMessage;Lorg/apache/tuweni/bytes/Bytes;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setOption", "key", "", "value", "version", "Companion", "evm"})
public final class EvmVmImpl
implements EvmVm {
    @NotNull
    private static final OpcodeRegistry registry;
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    @Override
    public void setOption(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = "Not yet implemented";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public String version() {
        return "0.0.1";
    }

    @Override
    @Nullable
    public Object close(@NotNull Continuation<? super Unit> $completion) {
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object execute(@NotNull HostContext hostContext, @NotNull HardFork fork, @NotNull EVMMessage msg, @NotNull Bytes code, @NotNull Continuation<? super EVMResult> $completion) {
        byte by;
        Result result;
        logger.trace("Code: " + code);
        Stack stack = new Stack(0, 1, null);
        int current = 0;
        GasManager gasManager = new GasManager(msg.getGas());
        Memory memory = new Memory();
        int n = 0;
        List executionPath = new ArrayList();
        while (current < code.size()) {
            boolean $i$f$map;
            boolean bl;
            Logger logger = EvmVmImpl.logger;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
            if (logger.isTraceEnabled()) {
                EvmVmImpl.logger.trace("Stack contents (" + stack.size() + "):");
                n = 0;
                int n2 = stack.size();
                while (n < n2) {
                    void i;
                    UInt256 uInt256 = stack.get((int)i);
                    EvmVmImpl.logger.trace((int)i + " - " + (uInt256 != null ? uInt256.toHexString() : null));
                    ++i;
                }
            }
            executionPath.add(Boxing.boxByte((byte)code.get(current)));
            Opcode opcode = registry.get(fork, code.get(current));
            if (opcode == null) {
                EvmVmImpl.logger.error("Could not find opcode for " + code.slice(current, 1) + " at position " + current);
                return new EVMResult(EVMExecutionStatusCode.INVALID_INSTRUCTION, gasManager, hostContext, null, 8, null);
            }
            byte currentOpcodeByte = code.get(current);
            int n3 = current;
            current = n3 + 1;
            result = opcode.execute(gasManager, hostContext, stack, msg, code, current, memory);
            StringBuilder stringBuilder = new StringBuilder().append(">> OPCODE: ");
            String string = EthereumVirtualMachineKt.getOpcodes().get(Boxing.boxByte((byte)currentOpcodeByte));
            if (string == null) {
                byte by2 = currentOpcodeByte;
                int n4 = 16;
                bl = false;
                byte by3 = by2;
                int n5 = CharsKt.checkRadix((int)n4);
                boolean bl2 = false;
                String string2 = Integer.toString(by3, CharsKt.checkRadix((int)n5));
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
            }
            EvmVmImpl.logger.trace(stringBuilder.append(string).append(' ').append("gas: ").append(gasManager.gasLeft()).append(" cost: ").append(gasManager.lastGasCost()).toString());
            Result result2 = result;
            if ((result2 != null ? result2.getStatus() : null) != null) {
                Logger logger2 = EvmVmImpl.logger;
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"logger");
                if (logger2.isTraceEnabled()) {
                    Collection<String> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = executionPath;
                    Logger logger3 = EvmVmImpl.logger;
                    $i$f$map = false;
                    void var16_23 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        byte by4 = ((Number)item$iv$iv).byteValue();
                        collection = destination$iv$iv;
                        boolean bl3 = false;
                        String string3 = EthereumVirtualMachineKt.getOpcodes().get(Boxing.boxByte((byte)it));
                        if (string3 == null) {
                            void var23_40 = it;
                            int n6 = 16;
                            boolean bl4 = false;
                            void var26_46 = var23_40;
                            int n7 = CharsKt.checkRadix((int)n6);
                            boolean bl5 = false;
                            String string4 = Integer.toString((int)var26_46, CharsKt.checkRadix((int)n7));
                            string3 = string4;
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
                        }
                        String string5 = string3;
                        collection.add(string5);
                    }
                    collection = (List)destination$iv$iv;
                    logger3.trace(CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)">", null, null, (int)0, null, null, (int)62, null));
                }
                if (result.getStatus() == EVMExecutionStatusCode.SUCCESS && !gasManager.hasGasLeft()) {
                    return new EVMResult(EVMExecutionStatusCode.OUT_OF_GAS, gasManager, hostContext, null, 8, null);
                }
                return new EVMResult(result.getStatus(), gasManager, hostContext, result.getOutput());
            }
            Object object = result;
            if (object != null && (object = ((Result)object).getNewCodePosition()) != null) {
                Object $this$map$iv = object;
                $i$f$map = false;
                bl = false;
                int it = ((Number)$this$map$iv).intValue();
                by = 0;
                current = result.getNewCodePosition();
            }
            if (!gasManager.hasGasLeft()) {
                return new EVMResult(EVMExecutionStatusCode.OUT_OF_GAS, gasManager, hostContext, null, 8, null);
            }
            if (stack.overflowed()) {
                return new EVMResult(EVMExecutionStatusCode.STACK_OVERFLOW, gasManager, hostContext, null, 8, null);
            }
            Result result3 = result;
            if ((result3 != null ? result3.getValidationStatus() : null) == null) continue;
            return new EVMResult(result.getValidationStatus(), gasManager, hostContext, null, 8, null);
        }
        Logger logger = EvmVmImpl.logger;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        if (logger.isTraceEnabled()) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable opcode = executionPath;
            Logger logger4 = EvmVmImpl.logger;
            boolean $i$f$map = false;
            result = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                by = ((Number)item$iv$iv).byteValue();
                collection = destination$iv$iv;
                boolean bl = false;
                String string = EthereumVirtualMachineKt.getOpcodes().get(Boxing.boxByte((byte)it));
                if (string == null) {
                    void var20_35 = it;
                    int n8 = 16;
                    boolean bl6 = false;
                    void var23_41 = var20_35;
                    int n9 = CharsKt.checkRadix((int)n8);
                    boolean bl7 = false;
                    String string6 = Integer.toString((int)var23_41, CharsKt.checkRadix((int)n9));
                    string = string6;
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
                }
                String string7 = string;
                collection.add(string7);
            }
            collection = (List)destination$iv$iv;
            logger4.trace(CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)">", null, null, (int)0, null, null, (int)62, null));
        }
        return new EVMResult(EVMExecutionStatusCode.SUCCESS, gasManager, hostContext, null, 8, null);
    }

    @Override
    public int capabilities() {
        String string = "Not yet implemented";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    static {
        Companion = new Companion(null);
        registry = OpcodeRegistry.Companion.create();
        logger = LoggerFactory.getLogger(EvmVmImpl.class);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\f\u001a\u00020\rR\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/apache/tuweni/evm/impl/EvmVmImpl$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/slf4j/Logger;", "registry", "Lorg/apache/tuweni/evm/impl/OpcodeRegistry;", "getRegistry", "()Lorg/apache/tuweni/evm/impl/OpcodeRegistry;", "create", "Lorg/apache/tuweni/evm/EvmVm;", "evm"})
    public static final class Companion {
        @NotNull
        public final EvmVm create() {
            return new EvmVmImpl();
        }

        @NotNull
        public final OpcodeRegistry getRegistry() {
            return registry;
        }

        public final Logger getLogger() {
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

