/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.peer.repository.memory;

import java.time.Instant;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.peer.repository.Connection;
import org.apache.tuweni.peer.repository.Identity;
import org.apache.tuweni.peer.repository.Peer;
import org.apache.tuweni.peer.repository.PeerRepository;
import org.apache.tuweni.peer.repository.memory.MemoryConnection;
import org.apache.tuweni.peer.repository.memory.MemoryIdentity;
import org.apache.tuweni.peer.repository.memory.MemoryPeer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u000bH\u0016J\u0018\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J\u0018\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u000bH\u0016J\u0018\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u0010H\u0016J \u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J$\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u000b2\b\u0010$\u001a\u0004\u0018\u00010%2\b\u0010&\u001a\u0004\u0018\u00010%H\u0016R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR!\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00100\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\b\u00a8\u0006'"}, d2={"Lorg/apache/tuweni/peer/repository/memory/MemoryPeerRepository;", "Lorg/apache/tuweni/peer/repository/PeerRepository;", "()V", "connections", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/apache/tuweni/peer/repository/Connection;", "getConnections", "()Ljava/util/concurrent/ConcurrentHashMap;", "identities", "Ljava/util/HashSet;", "Lorg/apache/tuweni/peer/repository/Identity;", "Lkotlin/collections/HashSet;", "getIdentities", "()Ljava/util/HashSet;", "peerMap", "Lorg/apache/tuweni/peer/repository/Peer;", "getPeerMap", "addConnection", "", "peer", "identity", "createConnectionKey", "markConnectionInactive", "peerDiscoveredAt", "time", "", "randomPeer", "storeIdentity", "networkInterface", "port", "", "publicKey", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "storePeer", "id", "lastContacted", "Ljava/time/Instant;", "lastDiscovered", "peer-repository"})
public final class MemoryPeerRepository
implements PeerRepository {
    @NotNull
    private final ConcurrentHashMap<Identity, Peer> peerMap = new ConcurrentHashMap();
    @NotNull
    private final HashSet<Identity> identities = new HashSet();
    @NotNull
    private final ConcurrentHashMap<String, Connection> connections = new ConcurrentHashMap();

    @NotNull
    public final ConcurrentHashMap<Identity, Peer> getPeerMap() {
        return this.peerMap;
    }

    @NotNull
    public final HashSet<Identity> getIdentities() {
        return this.identities;
    }

    @NotNull
    public final ConcurrentHashMap<String, Connection> getConnections() {
        return this.connections;
    }

    @Override
    @NotNull
    public Peer storePeer(@NotNull Identity id, @Nullable Instant lastContacted, @Nullable Instant lastDiscovered) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        MemoryPeer peer = new MemoryPeer(id, lastContacted, lastDiscovered);
        ((Map)this.peerMap).put(peer.id(), peer);
        return peer;
    }

    @Override
    @Nullable
    public Peer randomPeer() {
        Collection<Peer> collection = this.peerMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"peerMap.values");
        return (Peer)CollectionsKt.firstOrNull((Iterable)collection);
    }

    @Override
    @NotNull
    public Identity storeIdentity(@NotNull String networkInterface, int port, @NotNull SECP256K1.PublicKey publicKey) {
        Intrinsics.checkNotNullParameter((Object)networkInterface, (String)"networkInterface");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        MemoryIdentity identity = new MemoryIdentity(networkInterface, port, publicKey);
        this.identities.add(identity);
        return identity;
    }

    @Override
    public void addConnection(@NotNull Peer peer, @NotNull Identity identity) {
        Intrinsics.checkNotNullParameter((Object)peer, (String)"peer");
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        Instant now = Instant.now();
        MemoryConnection conn = new MemoryConnection(true, peer, identity);
        ((Map)this.connections).put(this.createConnectionKey(peer, identity), conn);
        ((MemoryPeer)peer).getConnections().add(conn);
        ((MemoryPeer)peer).setLastContacted$peer_repository(now);
        ((MemoryIdentity)identity).getConnections$peer_repository().add(conn);
    }

    @Override
    public void markConnectionInactive(@NotNull Peer peer, @NotNull Identity identity) {
        Intrinsics.checkNotNullParameter((Object)peer, (String)"peer");
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        Connection connection = this.connections.get(this.createConnectionKey(peer, identity));
        if (connection == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.apache.tuweni.peer.repository.memory.MemoryConnection");
        }
        ((MemoryConnection)connection).setActive(false);
    }

    @Override
    public void peerDiscoveredAt(@NotNull Peer peer, long time) {
        Intrinsics.checkNotNullParameter((Object)peer, (String)"peer");
        Instant timestamp = Instant.ofEpochMilli(time);
        Instant lastDiscovered = peer.lastDiscovered();
        if (lastDiscovered == null || lastDiscovered.isBefore(timestamp)) {
            ((MemoryPeer)peer).setLastDiscovered$peer_repository(timestamp);
        }
    }

    private final String createConnectionKey(Peer peer, Identity identity) {
        return peer.id() + '-' + identity.publicKey().toHexString();
    }
}

