/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p.v5;

import java.net.InetAddress;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.devp2p.v5.Message;
import org.apache.tuweni.devp2p.v5.MessageType;
import org.apache.tuweni.devp2p.v5.PongMessage;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.rlp.RLPWriter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B)\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0014\u001a\u00020\u0003H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0018"}, d2={"Lorg/apache/tuweni/devp2p/v5/PongMessage;", "Lorg/apache/tuweni/devp2p/v5/Message;", "requestId", "Lorg/apache/tuweni/bytes/Bytes;", "enrSeq", "", "recipientIp", "", "recipientPort", "", "(Lorg/apache/tuweni/bytes/Bytes;JLjava/lang/String;I)V", "encodedMessageType", "getEnrSeq", "()J", "getRecipientIp", "()Ljava/lang/String;", "getRecipientPort", "()I", "getRequestId", "()Lorg/apache/tuweni/bytes/Bytes;", "toRLP", "type", "Lorg/apache/tuweni/devp2p/v5/MessageType;", "Companion", "devp2p"})
public final class PongMessage
implements Message {
    private final Bytes encodedMessageType;
    @NotNull
    private final Bytes requestId;
    private final long enrSeq;
    @NotNull
    private final String recipientIp;
    private final int recipientPort;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public MessageType type() {
        return MessageType.PONG;
    }

    @Override
    @NotNull
    public Bytes toRLP() {
        Bytes bytes = RLP.encodeList((Consumer)new Consumer<RLPWriter>(this){
            final /* synthetic */ PongMessage this$0;

            public final void accept(RLPWriter writer) {
                writer.writeValue(this.this$0.getRequestId());
                writer.writeLong(this.this$0.getEnrSeq());
                InetAddress inetAddress = InetAddress.getByName(this.this$0.getRecipientIp());
                Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"InetAddress.getByName(recipientIp)");
                Bytes bytesIp = Bytes.wrap((byte[])inetAddress.getAddress());
                writer.writeValue(bytesIp);
                writer.writeInt(this.this$0.getRecipientPort());
            }
            {
                this.this$0 = pongMessage;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"RLP.encodeList { writer \u2026eInt(recipientPort)\n    }");
        return bytes;
    }

    @NotNull
    public final Bytes getRequestId() {
        return this.requestId;
    }

    public final long getEnrSeq() {
        return this.enrSeq;
    }

    @NotNull
    public final String getRecipientIp() {
        return this.recipientIp;
    }

    public final int getRecipientPort() {
        return this.recipientPort;
    }

    public PongMessage(@NotNull Bytes requestId, long enrSeq, @NotNull String recipientIp, int recipientPort) {
        Intrinsics.checkNotNullParameter((Object)requestId, (String)"requestId");
        Intrinsics.checkNotNullParameter((Object)recipientIp, (String)"recipientIp");
        this.requestId = requestId;
        this.enrSeq = enrSeq;
        this.recipientIp = recipientIp;
        this.recipientPort = recipientPort;
        Bytes bytes = Bytes.fromHexString((CharSequence)"0x02");
        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"Bytes.fromHexString(\"0x02\")");
        this.encodedMessageType = bytes;
    }

    public /* synthetic */ PongMessage(Bytes bytes, long l, String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            bytes = Message.Companion.requestId();
        }
        if ((n2 & 2) != 0) {
            l = 0L;
        }
        this(bytes, l, string, n);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/apache/tuweni/devp2p/v5/PongMessage$Companion;", "", "()V", "create", "Lorg/apache/tuweni/devp2p/v5/PongMessage;", "content", "Lorg/apache/tuweni/bytes/Bytes;", "devp2p"})
    public static final class Companion {
        @NotNull
        public final PongMessage create(@NotNull Bytes content) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Object object = RLP.decodeList((Bytes)content, (Function)create.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"RLP.decodeList(content) \u2026s, recipientPort)\n      }");
            return (PongMessage)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

