/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p.v5;

import io.vertx.core.net.SocketAddress;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.coroutines.CoroutineScope;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.concurrent.AsyncResult;
import org.apache.tuweni.concurrent.CompletableAsyncResult;
import org.apache.tuweni.crypto.Hash;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.devp2p.EthereumNodeRecord;
import org.apache.tuweni.devp2p.v5.FindNodeMessage;
import org.apache.tuweni.devp2p.v5.HandshakeSession;
import org.apache.tuweni.devp2p.v5.HandshakeSessionKt;
import org.apache.tuweni.devp2p.v5.HandshakeSessionKt$sam$java_util_function_Function$0;
import org.apache.tuweni.devp2p.v5.Message;
import org.apache.tuweni.devp2p.v5.MessageType;
import org.apache.tuweni.devp2p.v5.RandomMessage;
import org.apache.tuweni.devp2p.v5.WhoAreYouMessage;
import org.apache.tuweni.devp2p.v5.encrypt.AES128GCM;
import org.apache.tuweni.devp2p.v5.encrypt.SessionKey;
import org.apache.tuweni.devp2p.v5.encrypt.SessionKeyGenerator;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.rlp.RLPReader;
import org.apache.tuweni.rlp.RLPWriter;
import org.apache.tuweni.units.bigints.UInt256;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u0000 72\u00020\u0001:\u00017BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00140+J\u0017\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00140+H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010-J\u0019\u0010.\u001a\u00020\u000b2\u0006\u0010/\u001a\u00020\nH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00100J\u0006\u00101\u001a\u00020\u0018J(\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\n2\u0006\u00105\u001a\u00020\n2\u0006\u00106\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010%\u001a\u0012\u0012\u0004\u0012\u00020\n0&j\b\u0012\u0004\u0012\u00020\n`'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010(\u001a\n )*\u0004\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00068"}, d2={"Lorg/apache/tuweni/devp2p/v5/HandshakeSession;", "Lkotlinx/coroutines/CoroutineScope;", "keyPair", "Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;", "address", "Lio/vertx/core/net/SocketAddress;", "publicKey", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "sendFn", "Lkotlin/Function2;", "Lorg/apache/tuweni/bytes/Bytes;", "", "enr", "Lkotlin/Function0;", "Lorg/apache/tuweni/devp2p/EthereumNodeRecord;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "(Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;Lio/vertx/core/net/SocketAddress;Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function0;Lkotlin/coroutines/CoroutineContext;)V", "connected", "Lorg/apache/tuweni/concurrent/CompletableAsyncResult;", "Lorg/apache/tuweni/devp2p/v5/encrypt/SessionKey;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "nodeId", "Lorg/apache/tuweni/bytes/Bytes32;", "getNodeId", "()Lorg/apache/tuweni/bytes/Bytes32;", "receivedEnr", "getReceivedEnr", "()Lorg/apache/tuweni/devp2p/EthereumNodeRecord;", "setReceivedEnr", "(Lorg/apache/tuweni/devp2p/EthereumNodeRecord;)V", "requestId", "getRequestId", "()Lorg/apache/tuweni/bytes/Bytes;", "setRequestId", "(Lorg/apache/tuweni/bytes/Bytes;)V", "tokens", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "whoAreYouHeader", "kotlin.jvm.PlatformType", "awaitConnection", "Lorg/apache/tuweni/concurrent/AsyncResult;", "connect", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "processMessage", "messageBytes", "(Lorg/apache/tuweni/bytes/Bytes;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "tag", "verifySignature", "", "signatureBytes", "idNonce", "ephemeralPublicKey", "Companion", "devp2p"})
public final class HandshakeSession
implements CoroutineScope {
    @Nullable
    private Bytes requestId;
    private final CompletableAsyncResult<SessionKey> connected;
    @Nullable
    private EthereumNodeRecord receivedEnr;
    @NotNull
    private final Bytes32 nodeId;
    private final Bytes32 whoAreYouHeader;
    private final ArrayList<Bytes> tokens;
    private final SECP256K1.KeyPair keyPair;
    private final SocketAddress address;
    private SECP256K1.PublicKey publicKey;
    private final Function2<SocketAddress, Bytes, Unit> sendFn;
    private final Function0<EthereumNodeRecord> enr;
    @NotNull
    private final CoroutineContext coroutineContext;
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public final Bytes getRequestId() {
        return this.requestId;
    }

    public final void setRequestId(@Nullable Bytes bytes) {
        this.requestId = bytes;
    }

    @Nullable
    public final EthereumNodeRecord getReceivedEnr() {
        return this.receivedEnr;
    }

    public final void setReceivedEnr(@Nullable EthereumNodeRecord ethereumNodeRecord) {
        this.receivedEnr = ethereumNodeRecord;
    }

    @NotNull
    public final Bytes32 getNodeId() {
        return this.nodeId;
    }

    @Nullable
    public final Object connect(@NotNull Continuation<? super AsyncResult<SessionKey>> $completion) {
        RandomMessage message = new RandomMessage(null, null, 3, null);
        this.tokens.add(message.getAuthTag());
        Bytes32 tag = this.tag();
        Bytes rlpAuthTag = RLP.encodeValue((Bytes)message.getAuthTag());
        Bytes content = Bytes.concatenate((Bytes[])new Bytes[]{(Bytes)tag, rlpAuthTag, message.toRLP()});
        logger.trace("Sending random packet {} {}", (Object)this.address, (Object)content);
        Bytes bytes = content;
        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"content");
        this.sendFn.invoke((Object)this.address, (Object)bytes);
        return this.connected;
    }

    @Nullable
    public final Object processMessage(@NotNull Bytes messageBytes, @NotNull Continuation<? super Unit> $completion) {
        if (messageBytes.size() > 1280) {
            logger.trace("Message too long, dropping from {}", (Object)this.address);
            return Unit.INSTANCE;
        }
        if (messageBytes.size() < 32) {
            logger.trace("Message too short, dropping from {}", (Object)this.address);
        }
        logger.trace("Received message from {}", (Object)this.address);
        Bytes tag = messageBytes.slice(0, 32);
        Bytes content = messageBytes.slice(32);
        if (Intrinsics.areEqual((Object)this.whoAreYouHeader, (Object)tag)) {
            logger.trace("Identified a WHOAREYOU message");
            Bytes bytes = tag;
            Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"tag");
            Bytes bytes2 = content;
            Intrinsics.checkNotNullExpressionValue((Object)bytes2, (String)"content");
            WhoAreYouMessage message = WhoAreYouMessage.Companion.create(bytes, bytes2);
            if (!this.tokens.contains(message.getToken())) {
                logger.trace("Unexpected WHOAREYOU packet {}", (Object)message.getToken());
                return Unit.INSTANCE;
            }
            SECP256K1.KeyPair ephemeralKeyPair = SECP256K1.KeyPair.random();
            SECP256K1.SecretKey ephemeralKey = ephemeralKeyPair.secretKey();
            SECP256K1.PublicKey publicKey = this.publicKey;
            Intrinsics.checkNotNull((Object)publicKey);
            Bytes32 destNodeId = EthereumNodeRecord.Companion.nodeId(publicKey);
            Bytes bytes3 = (Bytes)ephemeralKey.bytes();
            SECP256K1.PublicKey publicKey2 = this.publicKey;
            Intrinsics.checkNotNull((Object)publicKey2);
            Bytes secret = SECP256K1.deriveECDHKeyAgreement((Bytes)bytes3, (Bytes)publicKey2.bytes());
            Bytes bytes4 = (Bytes)this.nodeId;
            Bytes bytes5 = (Bytes)destNodeId;
            Bytes bytes6 = secret;
            Intrinsics.checkNotNullExpressionValue((Object)bytes6, (String)"secret");
            SessionKey newSession2 = SessionKeyGenerator.INSTANCE.generate(bytes4, bytes5, bytes6, message.getIdNonce());
            Bytes signValue = Bytes.concatenate((Bytes[])new Bytes[]{HandshakeSessionKt.access$getDISCOVERY_ID_NONCE$p(), message.getIdNonce(), ephemeralKeyPair.publicKey().bytes()});
            SECP256K1.Signature signature = SECP256K1.signHashed((Bytes32)Hash.sha2_256((Bytes)signValue), (SECP256K1.KeyPair)this.keyPair);
            Bytes plain2 = RLP.encodeList((Consumer)new Consumer<RLPWriter>(this, signature){
                final /* synthetic */ HandshakeSession this$0;
                final /* synthetic */ SECP256K1.Signature $signature;

                public final void accept(RLPWriter writer) {
                    writer.writeInt(5);
                    writer.writeValue(Bytes.concatenate((Bytes[])new Bytes[]{(Bytes)UInt256.valueOf((BigInteger)this.$signature.r()).toBytes(), (Bytes)UInt256.valueOf((BigInteger)this.$signature.s()).toBytes()}));
                    writer.writeRLP(((EthereumNodeRecord)HandshakeSession.access$getEnr$p(this.this$0).invoke()).toRLP());
                }
                {
                    this.this$0 = handshakeSession2;
                    this.$signature = signature;
                }
            });
            Bytes zeroNonce = Bytes.wrap((byte[])new byte[12]);
            Bytes bytes7 = newSession2.getAuthRespKey();
            Bytes bytes8 = zeroNonce;
            Intrinsics.checkNotNullExpressionValue((Object)bytes8, (String)"zeroNonce");
            Bytes bytes9 = plain2;
            Intrinsics.checkNotNullExpressionValue((Object)bytes9, (String)"plain");
            Bytes bytes10 = Bytes.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)bytes10, (String)"Bytes.EMPTY");
            Bytes authResponse = AES128GCM.INSTANCE.encrypt(bytes7, bytes8, bytes9, bytes10);
            Bytes authTag = Message.Companion.authTag();
            Bytes32 newTag = this.tag();
            FindNodeMessage findNode = new FindNodeMessage(null, 0, 3, null);
            this.requestId = findNode.getRequestId();
            Bytes bytes11 = newSession2.getInitiatorKey();
            Bytes bytes12 = Bytes.concatenate((Bytes[])new Bytes[]{Bytes.of((byte[])new byte[]{MessageType.FINDNODE.byte()}), findNode.toRLP()});
            Intrinsics.checkNotNullExpressionValue((Object)bytes12, (String)"Bytes.concatenate(Bytes.\u2026yte()), findNode.toRLP())");
            Bytes encryptedMessage = AES128GCM.INSTANCE.encrypt(bytes11, authTag, bytes12, (Bytes)newTag);
            Bytes response2 = Bytes.concatenate((Bytes[])new Bytes[]{(Bytes)newTag, RLP.encodeList((Consumer)new Consumer<RLPWriter>(authTag, message, ephemeralKeyPair, authResponse){
                final /* synthetic */ Bytes $authTag;
                final /* synthetic */ WhoAreYouMessage $message;
                final /* synthetic */ SECP256K1.KeyPair $ephemeralKeyPair;
                final /* synthetic */ Bytes $authResponse;

                public final void accept(RLPWriter it) {
                    it.writeValue(this.$authTag);
                    it.writeValue(this.$message.getIdNonce());
                    String string = "gcm";
                    Charset charset = Charsets.UTF_8;
                    boolean bl = false;
                    byte[] byArray = string.getBytes(charset);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                    it.writeValue(Bytes.wrap((byte[])byArray));
                    it.writeValue(this.$ephemeralKeyPair.publicKey().bytes());
                    it.writeValue(this.$authResponse);
                }
                {
                    this.$authTag = bytes;
                    this.$message = whoAreYouMessage;
                    this.$ephemeralKeyPair = keyPair;
                    this.$authResponse = bytes2;
                }
            }), encryptedMessage});
            logger.trace("Sending handshake FindNode {}", (Object)response2);
            this.connected.complete((Object)newSession2);
            Bytes bytes13 = response2;
            Intrinsics.checkNotNullExpressionValue((Object)bytes13, (String)"response");
            Object object = this.sendFn.invoke((Object)this.address, (Object)bytes13);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
        } else {
            Boolean hasHeader2;
            Object object = processMessage.hasHeader.1.INSTANCE;
            if (object != null) {
                Function1 ephemeralKeyPair = object;
                object = new HandshakeSessionKt$sam$java_util_function_Function$0(ephemeralKeyPair);
            }
            Boolean bl = hasHeader2 = (Boolean)RLP.decode((Bytes)content, (Function)((Function)object));
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"hasHeader");
            if (bl.booleanValue()) {
                logger.trace("Identified a valid message");
                Object object2 = RLP.decodeList((Bytes)content, (Function)new Function<RLPReader, Boolean>(this, tag){
                    final /* synthetic */ HandshakeSession this$0;
                    final /* synthetic */ Bytes $tag;

                    public final Boolean apply(RLPReader it) {
                        it.skipNext();
                        Bytes idNonce = it.readValue();
                        it.skipNext();
                        SECP256K1.PublicKey ephemeralPublicKey = SECP256K1.PublicKey.fromBytes((Bytes)it.readValue());
                        Bytes authResponse = it.readValue();
                        Bytes secret = SECP256K1.deriveECDHKeyAgreement((Bytes)((Bytes)HandshakeSession.access$getKeyPair$p(this.this$0).secretKey().bytes()), (Bytes)ephemeralPublicKey.bytes());
                        Bytes bytes = this.$tag;
                        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"tag");
                        Bytes senderNodeId = Message.Companion.getSourceFromTag(bytes, (Bytes)this.this$0.getNodeId());
                        Bytes bytes2 = (Bytes)this.this$0.getNodeId();
                        Bytes bytes3 = secret;
                        Intrinsics.checkNotNullExpressionValue((Object)bytes3, (String)"secret");
                        Bytes bytes4 = idNonce;
                        Intrinsics.checkNotNullExpressionValue((Object)bytes4, (String)"idNonce");
                        SessionKey sessionKey = SessionKeyGenerator.INSTANCE.generate(senderNodeId, bytes2, bytes3, bytes4);
                        Bytes[] bytesArray = new Bytes[1];
                        Bytes bytes5 = sessionKey.getAuthRespKey();
                        Bytes bytes6 = Bytes.wrap((byte[])new byte[12]);
                        Intrinsics.checkNotNullExpressionValue((Object)bytes6, (String)"Bytes.wrap(ByteArray(12))");
                        Bytes bytes7 = authResponse;
                        Intrinsics.checkNotNullExpressionValue((Object)bytes7, (String)"authResponse");
                        Bytes bytes8 = Bytes.EMPTY;
                        Intrinsics.checkNotNullExpressionValue((Object)bytes8, (String)"Bytes.EMPTY");
                        bytesArray[0] = AES128GCM.INSTANCE.decrypt(bytes5, bytes6, bytes7, bytes8);
                        Bytes decryptedAuthResponse = Bytes.wrap((Bytes[])bytesArray);
                        return (Boolean)RLP.decodeList((Bytes)decryptedAuthResponse, (Function)new Function<RLPReader, Boolean>(this, idNonce, ephemeralPublicKey, sessionKey){
                            final /* synthetic */ processMessage.2 this$0;
                            final /* synthetic */ Bytes $idNonce;
                            final /* synthetic */ SECP256K1.PublicKey $ephemeralPublicKey;
                            final /* synthetic */ SessionKey $sessionKey;

                            public final Boolean apply(RLPReader reader) {
                                reader.skipNext();
                                Bytes signatureBytes = reader.readValue();
                                EthereumNodeRecord enr2 = (EthereumNodeRecord)reader.readList((Function)processMessage.enr.1.INSTANCE);
                                this.this$0.this$0.setReceivedEnr(enr2);
                                HandshakeSession.access$setPublicKey$p(this.this$0.this$0, enr2.publicKey());
                                HandshakeSession handshakeSession2 = this.this$0.this$0;
                                Bytes bytes = signatureBytes;
                                Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"signatureBytes");
                                Bytes bytes2 = this.$idNonce;
                                Intrinsics.checkNotNullExpressionValue((Object)bytes2, (String)"idNonce");
                                SECP256K1.PublicKey publicKey = this.$ephemeralPublicKey;
                                Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"ephemeralPublicKey");
                                boolean signatureVerified = HandshakeSession.access$verifySignature(handshakeSession2, bytes, bytes2, publicKey, enr2.publicKey());
                                if (!signatureVerified) {
                                    throw (Throwable)new IllegalArgumentException("Signature is not verified");
                                }
                                HandshakeSession.access$getLogger$cp().trace("Finalized handshake");
                                return HandshakeSession.access$getConnected$p(this.this$0.this$0).complete((Object)this.$sessionKey);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$idNonce = bytes;
                                this.$ephemeralPublicKey = publicKey;
                                this.$sessionKey = sessionKey;
                            }
                        });
                    }
                    {
                        this.this$0 = handshakeSession2;
                        this.$tag = bytes;
                    }
                });
                if (object2 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object2;
                }
            } else {
                Bytes32 whoAreYouTag;
                logger.trace("Identified a RANDOM message");
                Bytes token = RLP.decodeValue((Bytes)content);
                Bytes bytes = tag;
                Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"tag");
                Bytes peerNodeId = Message.Companion.getSourceFromTag(bytes, (Bytes)this.nodeId);
                logger.trace("Found peerNodeId " + peerNodeId);
                Bytes[] bytesArray = new Bytes[2];
                bytesArray[0] = peerNodeId;
                String secret = "WHOAREYOU";
                Charset charset = Charsets.UTF_8;
                boolean bl2 = false;
                byte[] byArray = secret.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                bytesArray[1] = Bytes.wrap((byte[])byArray);
                Bytes32 bytes32 = whoAreYouTag = Hash.sha2_256((Bytes)Bytes.concatenate((Bytes[])bytesArray));
                Intrinsics.checkNotNullExpressionValue((Object)bytes32, (String)"whoAreYouTag");
                Bytes bytes14 = (Bytes)bytes32;
                Bytes bytes15 = token;
                Intrinsics.checkNotNullExpressionValue((Object)bytes15, (String)"token");
                WhoAreYouMessage response3 = new WhoAreYouMessage(bytes14, bytes15, Message.Companion.idNonce(), ((EthereumNodeRecord)this.enr.invoke()).seq());
                this.tokens.add(token);
                logger.trace("Sending WHOAREYOU to {}", (Object)this.address);
                Object object3 = this.sendFn.invoke((Object)this.address, (Object)response3.toRLP());
                if (object3 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object3;
                }
            }
        }
        return Unit.INSTANCE;
    }

    private final boolean verifySignature(Bytes signatureBytes, Bytes idNonce, SECP256K1.PublicKey ephemeralPublicKey, SECP256K1.PublicKey publicKey) {
        SECP256K1.Signature signature = SECP256K1.Signature.create((byte)1, (BigInteger)signatureBytes.slice(0, 32).toUnsignedBigInteger(), (BigInteger)signatureBytes.slice(32).toUnsignedBigInteger());
        Bytes signValue = Bytes.concatenate((Bytes[])new Bytes[]{HandshakeSessionKt.access$getDISCOVERY_ID_NONCE$p(), idNonce, ephemeralPublicKey.bytes()});
        Bytes32 hashedSignValue = Hash.sha2_256((Bytes)signValue);
        if (!SECP256K1.verifyHashed((Bytes32)hashedSignValue, (SECP256K1.Signature)signature, (SECP256K1.PublicKey)publicKey)) {
            SECP256K1.Signature signature0 = SECP256K1.Signature.create((byte)0, (BigInteger)signatureBytes.slice(0, 32).toUnsignedBigInteger(), (BigInteger)signatureBytes.slice(32).toUnsignedBigInteger());
            return SECP256K1.verifyHashed((Bytes32)hashedSignValue, (SECP256K1.Signature)signature0, (SECP256K1.PublicKey)publicKey);
        }
        return true;
    }

    @NotNull
    public final AsyncResult<SessionKey> awaitConnection() {
        return (AsyncResult)this.connected;
    }

    @NotNull
    public final Bytes32 tag() {
        SECP256K1.PublicKey publicKey = this.publicKey;
        Intrinsics.checkNotNull((Object)publicKey);
        return Message.Companion.tag(this.nodeId, (Bytes)EthereumNodeRecord.Companion.nodeId(publicKey));
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    public HandshakeSession(@NotNull SECP256K1.KeyPair keyPair, @NotNull SocketAddress address, @Nullable SECP256K1.PublicKey publicKey, @NotNull Function2<? super SocketAddress, ? super Bytes, Unit> sendFn, @NotNull Function0<EthereumNodeRecord> enr2, @NotNull CoroutineContext coroutineContext) {
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter(sendFn, (String)"sendFn");
        Intrinsics.checkNotNullParameter(enr2, (String)"enr");
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        this.keyPair = keyPair;
        this.address = address;
        this.publicKey = publicKey;
        this.sendFn = sendFn;
        this.enr = enr2;
        this.coroutineContext = coroutineContext;
        CompletableAsyncResult completableAsyncResult = AsyncResult.incomplete();
        Intrinsics.checkNotNullExpressionValue((Object)completableAsyncResult, (String)"AsyncResult.incomplete()");
        this.connected = completableAsyncResult;
        SECP256K1.PublicKey publicKey2 = this.keyPair.publicKey();
        Intrinsics.checkNotNullExpressionValue((Object)publicKey2, (String)"keyPair.publicKey()");
        this.nodeId = EthereumNodeRecord.Companion.nodeId(publicKey2);
        Bytes[] bytesArray = new Bytes[2];
        bytesArray[0] = (Bytes)this.nodeId;
        String string = "WHOAREYOU";
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        bytesArray[1] = Bytes.wrap((byte[])byArray);
        this.whoAreYouHeader = Hash.sha2_256((Bytes)Bytes.concatenate((Bytes[])bytesArray));
        this.tokens = new ArrayList();
    }

    public /* synthetic */ HandshakeSession(SECP256K1.KeyPair keyPair, SocketAddress socketAddress, SECP256K1.PublicKey publicKey, Function2 function2, Function0 function0, CoroutineContext coroutineContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            publicKey = null;
        }
        this(keyPair, socketAddress, publicKey, (Function2<? super SocketAddress, ? super Bytes, Unit>)function2, (Function0<EthereumNodeRecord>)function0, coroutineContext);
    }

    static {
        Companion = new Companion(null);
        logger = LoggerFactory.getLogger(HandshakeSession.class);
    }

    public static final /* synthetic */ Function0 access$getEnr$p(HandshakeSession $this) {
        return $this.enr;
    }

    public static final /* synthetic */ SECP256K1.KeyPair access$getKeyPair$p(HandshakeSession $this) {
        return $this.keyPair;
    }

    public static final /* synthetic */ SECP256K1.PublicKey access$getPublicKey$p(HandshakeSession $this) {
        return $this.publicKey;
    }

    public static final /* synthetic */ void access$setPublicKey$p(HandshakeSession $this, SECP256K1.PublicKey publicKey) {
        $this.publicKey = publicKey;
    }

    public static final /* synthetic */ boolean access$verifySignature(HandshakeSession $this, Bytes signatureBytes, Bytes idNonce, SECP256K1.PublicKey ephemeralPublicKey, SECP256K1.PublicKey publicKey) {
        return $this.verifySignature(signatureBytes, idNonce, ephemeralPublicKey, publicKey);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ CompletableAsyncResult access$getConnected$p(HandshakeSession $this) {
        return $this.connected;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/apache/tuweni/devp2p/v5/HandshakeSession$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "devp2p"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

