/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p.v5;

import io.vertx.core.Vertx;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Dispatchers;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.devp2p.EthereumNodeRecord;
import org.apache.tuweni.devp2p.v5.DefaultDiscoveryV5Service;
import org.apache.tuweni.devp2p.v5.DefaultENRStorage;
import org.apache.tuweni.devp2p.v5.DiscoveryV5Service;
import org.apache.tuweni.devp2p.v5.ENRStorage;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JX\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0007\u00a8\u0006\u0016"}, d2={"Lorg/apache/tuweni/devp2p/v5/DiscoveryService;", "", "()V", "open", "Lorg/apache/tuweni/devp2p/v5/DiscoveryV5Service;", "vertx", "Lio/vertx/core/Vertx;", "keyPair", "Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;", "localPort", "", "bindAddress", "Ljava/net/InetSocketAddress;", "enrSeq", "", "bootstrapENRList", "", "", "enrStorage", "Lorg/apache/tuweni/devp2p/v5/ENRStorage;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "devp2p"})
public final class DiscoveryService {
    @NotNull
    public static final DiscoveryService INSTANCE;

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final DiscoveryV5Service open(@NotNull Vertx vertx, @NotNull SECP256K1.KeyPair keyPair, int localPort, @NotNull InetSocketAddress bindAddress, long enrSeq, @NotNull List<String> bootstrapENRList, @NotNull ENRStorage enrStorage, @NotNull CoroutineContext coroutineContext) {
        Intrinsics.checkNotNullParameter((Object)vertx, (String)"vertx");
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        Intrinsics.checkNotNullParameter((Object)bindAddress, (String)"bindAddress");
        Intrinsics.checkNotNullParameter(bootstrapENRList, (String)"bootstrapENRList");
        Intrinsics.checkNotNullParameter((Object)enrStorage, (String)"enrStorage");
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        Map map2 = MapsKt.emptyMap();
        Map map3 = MapsKt.emptyMap();
        InetAddress inetAddress = bindAddress.getAddress();
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"bindAddress.address");
        EthereumNodeRecord selfENR = EthereumNodeRecord.Companion.create(keyPair, enrSeq, map2, map3, inetAddress, bindAddress.getPort(), bindAddress.getPort());
        return new DefaultDiscoveryV5Service(vertx, bindAddress, bootstrapENRList, enrStorage, keyPair, selfENR, null, null, coroutineContext, 192, null);
    }

    public static /* synthetic */ DiscoveryV5Service open$default(Vertx vertx, SECP256K1.KeyPair keyPair, int n, InetSocketAddress inetSocketAddress, long l, List list, ENRStorage eNRStorage, CoroutineContext coroutineContext, int n2, Object object) {
        if ((n2 & 8) != 0) {
            inetSocketAddress = new InetSocketAddress(InetAddress.getLoopbackAddress(), n);
        }
        if ((n2 & 0x10) != 0) {
            l = Instant.now().toEpochMilli();
        }
        if ((n2 & 0x20) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n2 & 0x40) != 0) {
            eNRStorage = new DefaultENRStorage();
        }
        if ((n2 & 0x80) != 0) {
            coroutineContext = (CoroutineContext)Dispatchers.getDefault();
        }
        return DiscoveryService.open(vertx, keyPair, n, inetSocketAddress, l, list, eNRStorage, coroutineContext);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final DiscoveryV5Service open(@NotNull Vertx vertx, @NotNull SECP256K1.KeyPair keyPair, int localPort, @NotNull InetSocketAddress bindAddress, long enrSeq, @NotNull List<String> bootstrapENRList, @NotNull ENRStorage enrStorage) {
        return DiscoveryService.open$default(vertx, keyPair, localPort, bindAddress, enrSeq, bootstrapENRList, enrStorage, null, 128, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final DiscoveryV5Service open(@NotNull Vertx vertx, @NotNull SECP256K1.KeyPair keyPair, int localPort, @NotNull InetSocketAddress bindAddress, long enrSeq, @NotNull List<String> bootstrapENRList) {
        return DiscoveryService.open$default(vertx, keyPair, localPort, bindAddress, enrSeq, bootstrapENRList, null, null, 192, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final DiscoveryV5Service open(@NotNull Vertx vertx, @NotNull SECP256K1.KeyPair keyPair, int localPort, @NotNull InetSocketAddress bindAddress, long enrSeq) {
        return DiscoveryService.open$default(vertx, keyPair, localPort, bindAddress, enrSeq, null, null, null, 224, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final DiscoveryV5Service open(@NotNull Vertx vertx, @NotNull SECP256K1.KeyPair keyPair, int localPort, @NotNull InetSocketAddress bindAddress) {
        return DiscoveryService.open$default(vertx, keyPair, localPort, bindAddress, 0L, null, null, null, 240, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final DiscoveryV5Service open(@NotNull Vertx vertx, @NotNull SECP256K1.KeyPair keyPair, int localPort) {
        return DiscoveryService.open$default(vertx, keyPair, localPort, null, 0L, null, null, null, 248, null);
    }

    private DiscoveryService() {
    }

    static {
        DiscoveryService discoveryService;
        INSTANCE = discoveryService = new DiscoveryService();
    }
}

