/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p;

import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.bytes.MutableBytes;
import org.apache.tuweni.crypto.Hash;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.devp2p.EthereumNodeRecord;
import org.apache.tuweni.devp2p.InvalidNodeRecordException;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.rlp.RLPReader;
import org.apache.tuweni.rlp.RLPWriter;
import org.apache.tuweni.units.bigints.UInt256;
import org.bouncycastle.math.ec.ECPoint;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 (2\u00020\u0001:\u0001(BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u0007\u0012\u001a\b\u0002\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\n0\u0007\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\fJ\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\r\u0010!\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\u0002\u0010\"J\u0006\u0010#\u001a\u00020\u0003J\b\u0010$\u001a\u00020\bH\u0016J\r\u0010%\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\u0002\u0010\"J\u0006\u0010&\u001a\u00020'R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR#\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\n0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011\u00a8\u0006)"}, d2={"Lorg/apache/tuweni/devp2p/EthereumNodeRecord;", "", "signature", "Lorg/apache/tuweni/bytes/Bytes;", "seq", "", "data", "", "", "listData", "", "rlp", "(Lorg/apache/tuweni/bytes/Bytes;JLjava/util/Map;Ljava/util/Map;Lorg/apache/tuweni/bytes/Bytes;)V", "getData", "()Ljava/util/Map;", "getListData", "getRlp", "()Lorg/apache/tuweni/bytes/Bytes;", "getSeq", "()J", "getSignature", "equals", "", "other", "hashCode", "", "ip", "Ljava/net/InetAddress;", "nodeId", "Lorg/apache/tuweni/bytes/Bytes32;", "publicKey", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "publicKeyBytes", "tcp", "()Ljava/lang/Integer;", "toRLP", "toString", "udp", "validate", "", "Companion", "devp2p"})
public final class EthereumNodeRecord {
    @NotNull
    private final Bytes signature;
    private final long seq;
    @NotNull
    private final Map<String, Bytes> data;
    @NotNull
    private final Map<String, List<Bytes>> listData;
    @NotNull
    private final Bytes rlp;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void validate() {
        SECP256K1.Signature sig0;
        SECP256K1.PublicKey recovered0;
        SECP256K1.PublicKey recovered;
        String string = "v4";
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        if (Intrinsics.areEqual((Object)Bytes.wrap((byte[])byArray), (Object)this.data.get("id")) ^ true) {
            throw (Throwable)new InvalidNodeRecordException("id attribute is not set to v4");
        }
        Bytes encoded2 = RLP.encodeList((Consumer)new Consumer<RLPWriter>(this){
            final /* synthetic */ EthereumNodeRecord this$0;

            public final void accept(RLPWriter it) {
                Map<String, Bytes> map2 = this.this$0.getData();
                long l = this.this$0.getSeq();
                RLPWriter rLPWriter = it;
                Intrinsics.checkNotNullExpressionValue((Object)rLPWriter, (String)"it");
                RLPWriter rLPWriter2 = rLPWriter;
                Map map3 = null;
                long l2 = l;
                Integer n = null;
                Integer n2 = null;
                InetAddress inetAddress = null;
                Map<String, Bytes> map4 = map2;
                org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.encode$default(EthereumNodeRecord.Companion, null, l2, inetAddress, n2, n, map4, map3, rLPWriter2, 93, null);
            }
            {
                this.this$0 = ethereumNodeRecord;
            }
        });
        SECP256K1.Signature sig = SECP256K1.Signature.create((byte)1, (BigInteger)this.signature.slice(0, 32).toUnsignedBigInteger(), (BigInteger)this.signature.slice(32).toUnsignedBigInteger());
        SECP256K1.PublicKey pubKey = this.publicKey();
        if (Intrinsics.areEqual((Object)pubKey, (Object)(recovered = SECP256K1.PublicKey.recoverFromSignature((Bytes)encoded2, (SECP256K1.Signature)sig))) ^ true && Intrinsics.areEqual((Object)pubKey, (Object)(recovered0 = SECP256K1.PublicKey.recoverFromSignature((Bytes)encoded2, (SECP256K1.Signature)(sig0 = SECP256K1.Signature.create((byte)0, (BigInteger)this.signature.slice(0, 32).toUnsignedBigInteger(), (BigInteger)this.signature.slice(32).toUnsignedBigInteger()))))) ^ true) {
            throw (Throwable)new InvalidNodeRecordException("Public key does not match signature");
        }
    }

    @NotNull
    public final SECP256K1.PublicKey publicKey() {
        SECP256K1.PublicKey publicKey = SECP256K1.PublicKey.fromBytes((Bytes)this.publicKeyBytes());
        Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"SECP256K1.PublicKey.fromBytes(publicKeyBytes())");
        return publicKey;
    }

    @NotNull
    public final Bytes publicKeyBytes() {
        Bytes bytes = this.data.get("secp256k1");
        if (bytes == null) {
            throw (Throwable)new InvalidNodeRecordException("Missing secp256k1 entry");
        }
        Bytes keyBytes = bytes;
        ECPoint ecPoint = SECP256K1.Parameters.CURVE.getCurve().decodePoint(keyBytes.toArrayUnsafe());
        Bytes bytes2 = Bytes.wrap((byte[])ecPoint.getEncoded(false)).slice(1);
        Intrinsics.checkNotNullExpressionValue((Object)bytes2, (String)"Bytes.wrap(ecPoint.getEncoded(false)).slice(1)");
        return bytes2;
    }

    @NotNull
    public final Bytes32 nodeId() {
        return Companion.nodeId(this.publicKey());
    }

    @NotNull
    public final InetAddress ip() {
        Object object;
        block3: {
            block2: {
                object = this.data.get("ip");
                if (object == null) break block2;
                Bytes bytes = object;
                boolean bl = false;
                boolean bl2 = false;
                Bytes it = bytes;
                boolean bl3 = false;
                object = InetAddress.getByAddress(it.toArrayUnsafe());
                if (object != null) break block3;
            }
            InetAddress inetAddress = InetAddress.getLoopbackAddress();
            object = inetAddress;
            Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"InetAddress.getLoopbackAddress()");
        }
        return object;
    }

    @Nullable
    public final Integer tcp() {
        Bytes bytes = this.data.get("tcp");
        return bytes != null ? Integer.valueOf(bytes.toInt()) : null;
    }

    @Nullable
    public final Integer udp() {
        Bytes bytes = this.data.get("udp");
        return bytes != null ? Integer.valueOf(bytes.toInt()) : this.tcp();
    }

    public final long seq() {
        return this.seq;
    }

    @NotNull
    public String toString() {
        return "enr:" + this.ip() + ':' + this.tcp() + "?udp=" + this.udp();
    }

    @NotNull
    public final Bytes toRLP() {
        return this.rlp;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.apache.tuweni.devp2p.EthereumNodeRecord");
        }
        EthereumNodeRecord cfr_ignored_0 = (EthereumNodeRecord)object2;
        return !(Intrinsics.areEqual((Object)this.rlp, (Object)((EthereumNodeRecord)other).rlp) ^ true);
    }

    public int hashCode() {
        return this.rlp.hashCode();
    }

    @NotNull
    public final Bytes getSignature() {
        return this.signature;
    }

    public final long getSeq() {
        return this.seq;
    }

    @NotNull
    public final Map<String, Bytes> getData() {
        return this.data;
    }

    @NotNull
    public final Map<String, List<Bytes>> getListData() {
        return this.listData;
    }

    @NotNull
    public final Bytes getRlp() {
        return this.rlp;
    }

    public EthereumNodeRecord(@NotNull Bytes signature, long seq, @NotNull Map<String, ? extends Bytes> data, @NotNull Map<String, ? extends List<? extends Bytes>> listData, @NotNull Bytes rlp) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter(listData, (String)"listData");
        Intrinsics.checkNotNullParameter((Object)rlp, (String)"rlp");
        this.signature = signature;
        this.seq = seq;
        this.data = data;
        this.listData = listData;
        this.rlp = rlp;
    }

    public /* synthetic */ EthereumNodeRecord(Bytes bytes, long l, Map map2, Map map3, Bytes bytes2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            map3 = MapsKt.emptyMap();
        }
        this(bytes, l, map2, map3, bytes2);
    }

    @JvmStatic
    @NotNull
    public static final EthereumNodeRecord fromRLP(@NotNull Bytes rlp) {
        return Companion.fromRLP(rlp);
    }

    @JvmStatic
    @NotNull
    public static final EthereumNodeRecord fromRLP(@NotNull RLPReader reader) {
        return Companion.fromRLP(reader);
    }

    @JvmStatic
    @NotNull
    public static final EthereumNodeRecord fromRLP(@NotNull RLPReader reader, @NotNull Bytes rlp) {
        return Companion.fromRLP(reader, rlp);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final EthereumNodeRecord create(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @Nullable Map<String, ? extends Bytes> data, @Nullable Map<String, ? extends List<? extends Bytes>> listData, @NotNull InetAddress ip, @Nullable Integer tcp, @Nullable Integer udp) {
        return Companion.create(signatureKeyPair, seq, data, listData, ip, tcp, udp);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final EthereumNodeRecord create(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @Nullable Map<String, ? extends Bytes> data, @Nullable Map<String, ? extends List<? extends Bytes>> listData, @NotNull InetAddress ip, @Nullable Integer tcp) {
        return org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.create$default(Companion, signatureKeyPair, seq, data, listData, ip, tcp, null, 64, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final EthereumNodeRecord create(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @Nullable Map<String, ? extends Bytes> data, @Nullable Map<String, ? extends List<? extends Bytes>> listData, @NotNull InetAddress ip) {
        return org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.create$default(Companion, signatureKeyPair, seq, data, listData, ip, null, null, 96, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final EthereumNodeRecord create(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @Nullable Map<String, ? extends Bytes> data, @NotNull InetAddress ip) {
        return org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.create$default(Companion, signatureKeyPair, seq, data, null, ip, null, null, 104, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final EthereumNodeRecord create(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @NotNull InetAddress ip) {
        return org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.create$default(Companion, signatureKeyPair, seq, null, null, ip, null, null, 108, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final EthereumNodeRecord create(@NotNull SECP256K1.KeyPair signatureKeyPair, @NotNull InetAddress ip) {
        return org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.create$default(Companion, signatureKeyPair, 0L, null, null, ip, null, null, 110, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Bytes toRLP(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @Nullable Map<String, ? extends Bytes> data, @Nullable Map<String, ? extends List<? extends Bytes>> listData, @NotNull InetAddress ip, @Nullable Integer tcp, @Nullable Integer udp) {
        return Companion.toRLP(signatureKeyPair, seq, data, listData, ip, tcp, udp);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Bytes toRLP(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @Nullable Map<String, ? extends Bytes> data, @Nullable Map<String, ? extends List<? extends Bytes>> listData, @NotNull InetAddress ip, @Nullable Integer tcp) {
        return org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.toRLP$default(Companion, signatureKeyPair, seq, data, listData, ip, tcp, null, 64, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Bytes toRLP(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @Nullable Map<String, ? extends Bytes> data, @Nullable Map<String, ? extends List<? extends Bytes>> listData, @NotNull InetAddress ip) {
        return org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.toRLP$default(Companion, signatureKeyPair, seq, data, listData, ip, null, null, 96, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Bytes toRLP(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @Nullable Map<String, ? extends Bytes> data, @NotNull InetAddress ip) {
        return org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.toRLP$default(Companion, signatureKeyPair, seq, data, null, ip, null, null, 104, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Bytes toRLP(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @NotNull InetAddress ip) {
        return org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.toRLP$default(Companion, signatureKeyPair, seq, null, null, ip, null, null, 108, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Bytes toRLP(@NotNull SECP256K1.KeyPair signatureKeyPair, @NotNull InetAddress ip) {
        return org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.toRLP$default(Companion, signatureKeyPair, 0L, null, null, ip, null, null, 110, null);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Ju\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0016\b\u0002\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\n2\u001c\b\u0002\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000e\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0007\u00a2\u0006\u0002\u0010\u0014J\u0083\u0001\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0016\b\u0002\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\n2\u001c\b\u0002\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000e\u0018\u00010\n2\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\fH\u0007J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J\u0018\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\fH\u0007J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!Ju\u0010\"\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0016\b\u0002\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\n2\u001c\b\u0002\u0010\r\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000e\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0007\u00a2\u0006\u0002\u0010#\u00a8\u0006$"}, d2={"Lorg/apache/tuweni/devp2p/EthereumNodeRecord$Companion;", "", "()V", "create", "Lorg/apache/tuweni/devp2p/EthereumNodeRecord;", "signatureKeyPair", "Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;", "seq", "", "data", "", "", "Lorg/apache/tuweni/bytes/Bytes;", "listData", "", "ip", "Ljava/net/InetAddress;", "tcp", "", "udp", "(Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;JLjava/util/Map;Ljava/util/Map;Ljava/net/InetAddress;Ljava/lang/Integer;Ljava/lang/Integer;)Lorg/apache/tuweni/devp2p/EthereumNodeRecord;", "encode", "", "writer", "Lorg/apache/tuweni/rlp/RLPWriter;", "(Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;JLjava/net/InetAddress;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/util/Map;Ljava/util/Map;Lorg/apache/tuweni/rlp/RLPWriter;)V", "fromRLP", "rlp", "reader", "Lorg/apache/tuweni/rlp/RLPReader;", "nodeId", "Lorg/apache/tuweni/bytes/Bytes32;", "publicKey", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "toRLP", "(Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;JLjava/util/Map;Ljava/util/Map;Ljava/net/InetAddress;Ljava/lang/Integer;Ljava/lang/Integer;)Lorg/apache/tuweni/bytes/Bytes;", "devp2p"})
    public static final class Companion {
        @NotNull
        public final Bytes32 nodeId(@NotNull SECP256K1.PublicKey publicKey) {
            ECPoint pt;
            Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
            ECPoint eCPoint = pt = publicKey.asEcPoint();
            Intrinsics.checkNotNullExpressionValue((Object)eCPoint, (String)"pt");
            Bytes32 xPart = UInt256.valueOf((BigInteger)eCPoint.getXCoord().toBigInteger()).toBytes();
            Bytes32 yPart = UInt256.valueOf((BigInteger)pt.getYCoord().toBigInteger()).toBytes();
            Bytes32 bytes32 = Hash.keccak256((Bytes)Bytes.concatenate((Bytes[])new Bytes[]{(Bytes)xPart, (Bytes)yPart}));
            Intrinsics.checkNotNullExpressionValue((Object)bytes32, (String)"Hash.keccak256(Bytes.concatenate(xPart, yPart))");
            return bytes32;
        }

        @JvmStatic
        @NotNull
        public final EthereumNodeRecord fromRLP(@NotNull Bytes rlp) {
            Intrinsics.checkNotNullParameter((Object)rlp, (String)"rlp");
            if (rlp.size() > 300) {
                throw (Throwable)new IllegalArgumentException("Record too long");
            }
            Object object = RLP.decodeList((Bytes)rlp, (Function)new Function<RLPReader, EthereumNodeRecord>(rlp){
                final /* synthetic */ Bytes $rlp;

                public final EthereumNodeRecord apply(RLPReader it) {
                    RLPReader rLPReader = it;
                    Intrinsics.checkNotNullExpressionValue((Object)rLPReader, (String)"it");
                    return EthereumNodeRecord.Companion.fromRLP(rLPReader, this.$rlp);
                }
                {
                    this.$rlp = bytes;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"RLP.decodeList(rlp) { fromRLP(it, rlp) }");
            return (EthereumNodeRecord)object;
        }

        @JvmStatic
        @NotNull
        public final EthereumNodeRecord fromRLP(@NotNull RLPReader reader) {
            Bytes encoded2;
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            Bytes bytes = Bytes.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"Bytes.EMPTY");
            EthereumNodeRecord tempRecord = this.fromRLP(reader, bytes);
            Bytes bytes2 = encoded2 = RLP.encodeList((Consumer)new Consumer<RLPWriter>(tempRecord){
                final /* synthetic */ EthereumNodeRecord $tempRecord;

                public final void accept(RLPWriter it) {
                    it.writeValue(this.$tempRecord.getSignature());
                    Map<String, Bytes> map2 = this.$tempRecord.getData();
                    long l = this.$tempRecord.getSeq();
                    RLPWriter rLPWriter = it;
                    Intrinsics.checkNotNullExpressionValue((Object)rLPWriter, (String)"it");
                    RLPWriter rLPWriter2 = rLPWriter;
                    Map map3 = null;
                    long l2 = l;
                    Integer n = null;
                    Integer n2 = null;
                    InetAddress inetAddress = null;
                    Map<String, Bytes> map4 = map2;
                    org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.encode$default(EthereumNodeRecord.Companion, null, l2, inetAddress, n2, n, map4, map3, rLPWriter2, 93, null);
                }
                {
                    this.$tempRecord = ethereumNodeRecord;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)bytes2, (String)"encoded");
            return this.fromRLP(bytes2);
        }

        @JvmStatic
        @NotNull
        public final EthereumNodeRecord fromRLP(@NotNull RLPReader reader, @NotNull Bytes rlp) {
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            Intrinsics.checkNotNullParameter((Object)rlp, (String)"rlp");
            Bytes sig = reader.readValue();
            long seq = reader.readLong();
            boolean bl = false;
            Map data = new LinkedHashMap();
            boolean bl2 = false;
            Map listData = new LinkedHashMap();
            while (!reader.isComplete()) {
                String key = reader.readString();
                if (reader.nextIsList()) {
                    String string = key;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key");
                    List list = reader.readListContents((Function)fromRLP.2.INSTANCE);
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"reader.readListContents \u2026            }\n          }");
                    listData.put(string, CollectionsKt.filterNotNull((Iterable)list));
                    continue;
                }
                Bytes value = reader.readValue();
                String string = key;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key");
                Bytes bytes = value;
                Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"value");
                data.put(string, bytes);
            }
            Bytes bytes = sig;
            Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"sig");
            return new EthereumNodeRecord(bytes, seq, data, listData, rlp);
        }

        public final void encode(@Nullable SECP256K1.KeyPair signatureKeyPair, long seq, @Nullable InetAddress ip, @Nullable Integer tcp, @Nullable Integer udp, @Nullable Map<String, ? extends Bytes> data, @Nullable Map<String, ? extends List<? extends Bytes>> listData, @NotNull RLPWriter writer) {
            Object it;
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            writer.writeLong(seq);
            Map map2 = data;
            if (map2 == null || (map2 = MapsKt.toMutableMap(map2)) == null) {
                boolean bl = false;
                map2 = new LinkedHashMap();
            }
            Map mutableData = map2;
            Object object = "v4";
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            byte[] byArray = ((String)object).getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            Bytes bytes = Bytes.wrap((byte[])byArray);
            Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"Bytes.wrap(\"v4\".toByteArray())");
            mutableData.put("id", bytes);
            SECP256K1.KeyPair keyPair = signatureKeyPair;
            if (keyPair != null) {
                object = keyPair;
                boolean bl2 = false;
                bl = false;
                it = object;
                boolean bl3 = false;
                Bytes bytes2 = Bytes.wrap((byte[])it.publicKey().asEcPoint().getEncoded(true));
                Intrinsics.checkNotNullExpressionValue((Object)bytes2, (String)"Bytes.wrap(it.publicKey(\u2026Point().getEncoded(true))");
                mutableData.put("secp256k1", bytes2);
            }
            InetAddress inetAddress = ip;
            if (inetAddress != null) {
                object = inetAddress;
                boolean bl4 = false;
                bl = false;
                it = object;
                boolean bl5 = false;
                Bytes bytes3 = Bytes.wrap((byte[])((InetAddress)it).getAddress());
                Intrinsics.checkNotNullExpressionValue((Object)bytes3, (String)"Bytes.wrap(it.address)");
                mutableData.put("ip", bytes3);
            }
            Integer n = tcp;
            if (n != null) {
                object = n;
                boolean bl6 = false;
                bl = false;
                int it2 = ((Number)object).intValue();
                boolean bl7 = false;
                Bytes bytes4 = Bytes.ofUnsignedShort((int)it2);
                Intrinsics.checkNotNullExpressionValue((Object)bytes4, (String)"Bytes.ofUnsignedShort(it)");
                mutableData.put("tcp", bytes4);
            }
            Integer n2 = udp;
            if (n2 != null) {
                object = n2;
                boolean bl8 = false;
                bl = false;
                int it3 = ((Number)object).intValue();
                boolean bl9 = false;
                Bytes bytes5 = Bytes.ofUnsignedShort((int)it3);
                Intrinsics.checkNotNullExpressionValue((Object)bytes5, (String)"Bytes.ofUnsignedShort(it)");
                mutableData.put("udp", bytes5);
            }
            boolean bl10 = false;
            List keys = new ArrayList();
            keys.addAll(mutableData.keySet());
            Map<String, ? extends List<? extends Bytes>> map3 = listData;
            if (map3 != null) {
                Map<String, ? extends List<? extends Bytes>> map4 = map3;
                bl = false;
                boolean bl11 = false;
                Map<String, ? extends List<? extends Bytes>> it4 = map4;
                boolean bl12 = false;
                keys.addAll((Collection)it4.keySet());
            }
            Iterable $this$forEach$iv = CollectionsKt.sorted((Iterable)keys);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object2;
                Bytes value;
                Object object3;
                boolean bl13;
                boolean bl14;
                String key = (String)element$iv;
                boolean bl15 = false;
                if ((Bytes)mutableData.get(key) != null) {
                    bl14 = false;
                    bl13 = false;
                    value = object3;
                    boolean bl16 = false;
                    writer.writeString(key);
                    writer.writeValue(value);
                }
                if ((object2 = listData) == null || (object2 = object2.get(key)) == null) continue;
                object3 = object2;
                bl14 = false;
                bl13 = false;
                value = object3;
                boolean bl17 = false;
                writer.writeString(key);
                writer.writeList((List)value, (BiConsumer)encode.6.2.1.INSTANCE);
            }
        }

        public static /* synthetic */ void encode$default(Companion companion, SECP256K1.KeyPair keyPair, long l, InetAddress inetAddress, Integer n, Integer n2, Map map2, Map map3, RLPWriter rLPWriter, int n3, Object object) {
            if ((n3 & 1) != 0) {
                keyPair = null;
            }
            if ((n3 & 2) != 0) {
                l = Instant.now().toEpochMilli();
            }
            if ((n3 & 4) != 0) {
                inetAddress = null;
            }
            if ((n3 & 8) != 0) {
                n = null;
            }
            if ((n3 & 0x10) != 0) {
                n2 = null;
            }
            if ((n3 & 0x20) != 0) {
                map2 = null;
            }
            if ((n3 & 0x40) != 0) {
                map3 = null;
            }
            companion.encode(keyPair, l, inetAddress, n, n2, map2, map3, rLPWriter);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final EthereumNodeRecord create(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @Nullable Map<String, ? extends Bytes> data, @Nullable Map<String, ? extends List<? extends Bytes>> listData, @NotNull InetAddress ip, @Nullable Integer tcp, @Nullable Integer udp) {
            Intrinsics.checkNotNullParameter((Object)signatureKeyPair, (String)"signatureKeyPair");
            Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
            return this.fromRLP(this.toRLP(signatureKeyPair, seq, data, listData, ip, tcp, udp));
        }

        public static /* synthetic */ EthereumNodeRecord create$default(Companion companion, SECP256K1.KeyPair keyPair, long l, Map map2, Map map3, InetAddress inetAddress, Integer n, Integer n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                l = Instant.now().toEpochMilli();
            }
            if ((n3 & 4) != 0) {
                map2 = null;
            }
            if ((n3 & 8) != 0) {
                map3 = null;
            }
            if ((n3 & 0x20) != 0) {
                n = null;
            }
            if ((n3 & 0x40) != 0) {
                n2 = null;
            }
            return companion.create(keyPair, l, map2, map3, inetAddress, n, n2);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final EthereumNodeRecord create(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @Nullable Map<String, ? extends Bytes> data, @Nullable Map<String, ? extends List<? extends Bytes>> listData, @NotNull InetAddress ip, @Nullable Integer tcp) {
            return org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.create$default(this, signatureKeyPair, seq, data, listData, ip, tcp, null, 64, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final EthereumNodeRecord create(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @Nullable Map<String, ? extends Bytes> data, @Nullable Map<String, ? extends List<? extends Bytes>> listData, @NotNull InetAddress ip) {
            return org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.create$default(this, signatureKeyPair, seq, data, listData, ip, null, null, 96, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final EthereumNodeRecord create(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @Nullable Map<String, ? extends Bytes> data, @NotNull InetAddress ip) {
            return org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.create$default(this, signatureKeyPair, seq, data, null, ip, null, null, 104, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final EthereumNodeRecord create(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @NotNull InetAddress ip) {
            return org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.create$default(this, signatureKeyPair, seq, null, null, ip, null, null, 108, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final EthereumNodeRecord create(@NotNull SECP256K1.KeyPair signatureKeyPair, @NotNull InetAddress ip) {
            return org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.create$default(this, signatureKeyPair, 0L, null, null, ip, null, null, 110, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Bytes toRLP(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @Nullable Map<String, ? extends Bytes> data, @Nullable Map<String, ? extends List<? extends Bytes>> listData, @NotNull InetAddress ip, @Nullable Integer tcp, @Nullable Integer udp) {
            Bytes completeEncoding2;
            Intrinsics.checkNotNullParameter((Object)signatureKeyPair, (String)"signatureKeyPair");
            Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
            Bytes encoded2 = RLP.encodeList((Consumer)new Consumer<RLPWriter>(signatureKeyPair, seq, ip, tcp, udp, data, listData){
                final /* synthetic */ SECP256K1.KeyPair $signatureKeyPair;
                final /* synthetic */ long $seq;
                final /* synthetic */ InetAddress $ip;
                final /* synthetic */ Integer $tcp;
                final /* synthetic */ Integer $udp;
                final /* synthetic */ Map $data;
                final /* synthetic */ Map $listData;

                public final void accept(RLPWriter writer) {
                    RLPWriter rLPWriter = writer;
                    Intrinsics.checkNotNullExpressionValue((Object)rLPWriter, (String)"writer");
                    EthereumNodeRecord.Companion.encode(this.$signatureKeyPair, this.$seq, this.$ip, this.$tcp, this.$udp, this.$data, this.$listData, rLPWriter);
                }
                {
                    this.$signatureKeyPair = keyPair;
                    this.$seq = l;
                    this.$ip = inetAddress;
                    this.$tcp = n;
                    this.$udp = n2;
                    this.$data = map2;
                    this.$listData = map3;
                }
            });
            SECP256K1.Signature signature = SECP256K1.sign((Bytes)encoded2, (SECP256K1.KeyPair)signatureKeyPair);
            MutableBytes sigBytes = MutableBytes.create((int)64);
            UInt256.valueOf((BigInteger)signature.r()).toBytes().copyTo(sigBytes, 0);
            UInt256.valueOf((BigInteger)signature.s()).toBytes().copyTo(sigBytes, 32);
            Bytes bytes = completeEncoding2 = RLP.encodeList((Consumer)new Consumer<RLPWriter>(sigBytes, signatureKeyPair, seq, ip, tcp, udp, data, listData){
                final /* synthetic */ MutableBytes $sigBytes;
                final /* synthetic */ SECP256K1.KeyPair $signatureKeyPair;
                final /* synthetic */ long $seq;
                final /* synthetic */ InetAddress $ip;
                final /* synthetic */ Integer $tcp;
                final /* synthetic */ Integer $udp;
                final /* synthetic */ Map $data;
                final /* synthetic */ Map $listData;

                public final void accept(RLPWriter writer) {
                    writer.writeValue((Bytes)this.$sigBytes);
                    RLPWriter rLPWriter = writer;
                    Intrinsics.checkNotNullExpressionValue((Object)rLPWriter, (String)"writer");
                    EthereumNodeRecord.Companion.encode(this.$signatureKeyPair, this.$seq, this.$ip, this.$tcp, this.$udp, this.$data, this.$listData, rLPWriter);
                }
                {
                    this.$sigBytes = mutableBytes;
                    this.$signatureKeyPair = keyPair;
                    this.$seq = l;
                    this.$ip = inetAddress;
                    this.$tcp = n;
                    this.$udp = n2;
                    this.$data = map2;
                    this.$listData = map3;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"completeEncoding");
            return bytes;
        }

        public static /* synthetic */ Bytes toRLP$default(Companion companion, SECP256K1.KeyPair keyPair, long l, Map map2, Map map3, InetAddress inetAddress, Integer n, Integer n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                l = Instant.now().toEpochMilli();
            }
            if ((n3 & 4) != 0) {
                map2 = null;
            }
            if ((n3 & 8) != 0) {
                map3 = null;
            }
            if ((n3 & 0x20) != 0) {
                n = null;
            }
            if ((n3 & 0x40) != 0) {
                n2 = null;
            }
            return companion.toRLP(keyPair, l, map2, map3, inetAddress, n, n2);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Bytes toRLP(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @Nullable Map<String, ? extends Bytes> data, @Nullable Map<String, ? extends List<? extends Bytes>> listData, @NotNull InetAddress ip, @Nullable Integer tcp) {
            return org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.toRLP$default(this, signatureKeyPair, seq, data, listData, ip, tcp, null, 64, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Bytes toRLP(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @Nullable Map<String, ? extends Bytes> data, @Nullable Map<String, ? extends List<? extends Bytes>> listData, @NotNull InetAddress ip) {
            return org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.toRLP$default(this, signatureKeyPair, seq, data, listData, ip, null, null, 96, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Bytes toRLP(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @Nullable Map<String, ? extends Bytes> data, @NotNull InetAddress ip) {
            return org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.toRLP$default(this, signatureKeyPair, seq, data, null, ip, null, null, 104, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Bytes toRLP(@NotNull SECP256K1.KeyPair signatureKeyPair, long seq, @NotNull InetAddress ip) {
            return org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.toRLP$default(this, signatureKeyPair, seq, null, null, ip, null, null, 108, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Bytes toRLP(@NotNull SECP256K1.KeyPair signatureKeyPair, @NotNull InetAddress ip) {
            return org.apache.tuweni.devp2p.EthereumNodeRecord$Companion.toRLP$default(this, signatureKeyPair, 0L, null, null, ip, null, null, 110, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

