/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.scuttlebutt;

import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.crypto.sodium.Signature;
import org.apache.tuweni.scuttlebutt.Identity;

final class Ed25519PublicKeyIdentity
implements Identity {
    private final Signature.PublicKey publicKey;

    Ed25519PublicKeyIdentity(Signature.PublicKey keyPair) {
        this.publicKey = keyPair;
    }

    @Override
    public Bytes sign(Bytes message) {
        throw new UnsupportedOperationException("Cannot sign messages with a public key identity");
    }

    @Override
    public boolean verify(Bytes signature, Bytes message) {
        return Signature.verifyDetached((Bytes)message, (Bytes)signature, (Signature.PublicKey)this.publicKey);
    }

    @Override
    public String publicKeyAsBase64String() {
        return this.publicKey.bytes().toBase64String();
    }

    @Override
    public Identity.Curve curve() {
        return Identity.Curve.Ed25519;
    }

    @Override
    public Signature.PublicKey ed25519PublicKey() {
        return this.publicKey;
    }

    @Override
    public SECP256K1.PublicKey secp256k1PublicKey() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ed25519PublicKeyIdentity identity = (Ed25519PublicKeyIdentity)o;
        return this.publicKey.equals((Object)identity.publicKey);
    }

    public int hashCode() {
        return Objects.hash(this.publicKey);
    }

    public String toString() {
        return this.toCanonicalForm();
    }
}

