/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.eth;

import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.eth.Log;
import org.apache.tuweni.eth.LogsBloomFilter;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.rlp.RLPReader;
import org.apache.tuweni.rlp.RLPWriter;

public final class TransactionReceipt {
    private final Bytes32 stateRoot;
    private final long cumulativeGasUsed;
    private final List<Log> logs;
    private final LogsBloomFilter bloomFilter;
    private final Integer status;

    public static TransactionReceipt fromBytes(Bytes bytes) {
        return (TransactionReceipt)RLP.decode((Bytes)bytes, TransactionReceipt::readFrom);
    }

    public static TransactionReceipt readFrom(RLPReader reader) {
        return (TransactionReceipt)reader.readList(input -> {
            Bytes statusOrRootState = input.readValue();
            long cumulativeGas = input.readLong();
            LogsBloomFilter bloomFilter = new LogsBloomFilter(input.readValue());
            List logs = input.readListContents(Log::readFrom);
            if (statusOrRootState.size() == 32) {
                return new TransactionReceipt(Bytes32.wrap((Bytes)statusOrRootState), cumulativeGas, bloomFilter, (List<Log>)logs);
            }
            int status = statusOrRootState.toInt();
            return new TransactionReceipt(status, cumulativeGas, bloomFilter, (List<Log>)logs);
        });
    }

    public TransactionReceipt(Bytes32 stateRoot, long cumulativeGasUsed, LogsBloomFilter bloomFilter, List<Log> logs) {
        this(stateRoot, null, cumulativeGasUsed, bloomFilter, logs);
    }

    public TransactionReceipt(int status, long cumulativeGasUsed, LogsBloomFilter bloomFilter, List<Log> logs) {
        this(null, status, cumulativeGasUsed, bloomFilter, logs);
    }

    private TransactionReceipt(@Nullable Bytes32 stateRoot, @Nullable Integer status, long cumulativeGasUsed, LogsBloomFilter bloomFilter, List<Log> logs) {
        this.stateRoot = stateRoot;
        this.cumulativeGasUsed = cumulativeGasUsed;
        this.status = status;
        this.logs = logs;
        this.bloomFilter = bloomFilter;
    }

    public Bytes toBytes() {
        return RLP.encode(this::writeTo);
    }

    public void writeTo(RLPWriter writer) {
        writer.writeList(out -> {
            if (this.stateRoot != null) {
                out.writeValue((Bytes)this.stateRoot);
            } else {
                out.writeLong((long)this.status.intValue());
            }
            out.writeLong(this.cumulativeGasUsed);
            out.writeValue(this.bloomFilter.toBytes());
            out.writeList(this.logs, (logWriter, log) -> log.writeTo((RLPWriter)logWriter));
        });
    }

    public Bytes32 getStateRoot() {
        return this.stateRoot;
    }

    public long getCumulativeGasUsed() {
        return this.cumulativeGasUsed;
    }

    public List<Log> getLogs() {
        return this.logs;
    }

    public LogsBloomFilter getBloomFilter() {
        return this.bloomFilter;
    }

    public boolean isValid() {
        return LogsBloomFilter.compute(this.logs).equals(this.bloomFilter);
    }

    public Integer getStatus() {
        return this.status;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TransactionReceipt)) {
            return false;
        }
        TransactionReceipt other = (TransactionReceipt)obj;
        return this.logs.equals(other.logs) && Objects.equals(this.stateRoot, other.stateRoot) && this.cumulativeGasUsed == other.cumulativeGasUsed && Objects.equals(this.status, other.status);
    }

    public int hashCode() {
        return Objects.hash(this.logs, this.stateRoot, this.cumulativeGasUsed);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("stateRoot", (Object)this.stateRoot).add("cumulativeGasUsed", this.cumulativeGasUsed).add("logs", this.logs).add("bloomFilter", (Object)this.bloomFilter).add("status", (Object)this.status).toString();
    }
}

