/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p.eth;

import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.devp2p.eth.Status;
import org.apache.tuweni.devp2p.eth.StatusMessage;
import org.apache.tuweni.eth.Hash;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.rlp.RLPWriter;
import org.apache.tuweni.units.bigints.UInt256;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\b\u0018\u0000 .2\u00020\u0001:\u0001.BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\bH\u00c6\u0003J\t\u0010 \u001a\u00020\bH\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\u0010\u0010\"\u001a\u0004\u0018\u00010\rH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0012JX\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u00c6\u0001\u00a2\u0006\u0002\u0010$J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010(\u001a\u00020\u0003H\u00d6\u0001J\u0006\u0010)\u001a\u00020\u000bJ\u0006\u0010*\u001a\u00020+J\t\u0010,\u001a\u00020-H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0015\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018\u00a8\u0006/"}, d2={"Lorg/apache/tuweni/devp2p/eth/StatusMessage;", "", "protocolVersion", "", "networkID", "Lorg/apache/tuweni/units/bigints/UInt256;", "totalDifficulty", "bestHash", "Lorg/apache/tuweni/eth/Hash;", "genesisHash", "forkHash", "Lorg/apache/tuweni/bytes/Bytes;", "forkBlock", "", "(ILorg/apache/tuweni/units/bigints/UInt256;Lorg/apache/tuweni/units/bigints/UInt256;Lorg/apache/tuweni/eth/Hash;Lorg/apache/tuweni/eth/Hash;Lorg/apache/tuweni/bytes/Bytes;Ljava/lang/Long;)V", "getBestHash", "()Lorg/apache/tuweni/eth/Hash;", "getForkBlock", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getForkHash", "()Lorg/apache/tuweni/bytes/Bytes;", "getGenesisHash", "getNetworkID", "()Lorg/apache/tuweni/units/bigints/UInt256;", "getProtocolVersion", "()I", "getTotalDifficulty", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "(ILorg/apache/tuweni/units/bigints/UInt256;Lorg/apache/tuweni/units/bigints/UInt256;Lorg/apache/tuweni/eth/Hash;Lorg/apache/tuweni/eth/Hash;Lorg/apache/tuweni/bytes/Bytes;Ljava/lang/Long;)Lorg/apache/tuweni/devp2p/eth/StatusMessage;", "equals", "", "other", "hashCode", "toBytes", "toStatus", "Lorg/apache/tuweni/devp2p/eth/Status;", "toString", "", "Companion", "devp2p-eth"})
public final class StatusMessage {
    private final int protocolVersion;
    @NotNull
    private final UInt256 networkID;
    @NotNull
    private final UInt256 totalDifficulty;
    @NotNull
    private final Hash bestHash;
    @NotNull
    private final Hash genesisHash;
    @Nullable
    private final Bytes forkHash;
    @Nullable
    private final Long forkBlock;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Bytes toBytes() {
        Bytes bytes = RLP.encodeList((Consumer)new Consumer<RLPWriter>(this){
            final /* synthetic */ StatusMessage this$0;

            public final void accept(RLPWriter it) {
                it.writeInt(this.this$0.getProtocolVersion());
                it.writeUInt256(this.this$0.getNetworkID());
                it.writeUInt256(this.this$0.getTotalDifficulty());
                it.writeValue((Bytes)this.this$0.getBestHash());
                it.writeValue((Bytes)this.this$0.getGenesisHash());
                if (this.this$0.getForkHash() != null && this.this$0.getForkBlock() != null) {
                    it.writeList((Consumer)new Consumer<RLPWriter>(this){
                        final /* synthetic */ toBytes.1 this$0;

                        public final void accept(RLPWriter forkWriter) {
                            forkWriter.writeValue(this.this$0.this$0.getForkHash());
                            forkWriter.writeValue(Bytes.ofUnsignedLong((long)this.this$0.this$0.getForkBlock()).trimLeadingZeros());
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
            }
            {
                this.this$0 = statusMessage;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"RLP.encodeList {\n    it.\u2026eros())\n      }\n    }\n  }");
        return bytes;
    }

    @NotNull
    public final Status toStatus() {
        return new Status(this.protocolVersion, this.networkID, this.totalDifficulty, (Bytes32)this.bestHash, (Bytes32)this.genesisHash, this.forkHash, this.forkBlock);
    }

    public final int getProtocolVersion() {
        return this.protocolVersion;
    }

    @NotNull
    public final UInt256 getNetworkID() {
        return this.networkID;
    }

    @NotNull
    public final UInt256 getTotalDifficulty() {
        return this.totalDifficulty;
    }

    @NotNull
    public final Hash getBestHash() {
        return this.bestHash;
    }

    @NotNull
    public final Hash getGenesisHash() {
        return this.genesisHash;
    }

    @Nullable
    public final Bytes getForkHash() {
        return this.forkHash;
    }

    @Nullable
    public final Long getForkBlock() {
        return this.forkBlock;
    }

    public StatusMessage(int protocolVersion, @NotNull UInt256 networkID, @NotNull UInt256 totalDifficulty, @NotNull Hash bestHash, @NotNull Hash genesisHash, @Nullable Bytes forkHash, @Nullable Long forkBlock) {
        Intrinsics.checkNotNullParameter((Object)networkID, (String)"networkID");
        Intrinsics.checkNotNullParameter((Object)totalDifficulty, (String)"totalDifficulty");
        Intrinsics.checkNotNullParameter((Object)bestHash, (String)"bestHash");
        Intrinsics.checkNotNullParameter((Object)genesisHash, (String)"genesisHash");
        this.protocolVersion = protocolVersion;
        this.networkID = networkID;
        this.totalDifficulty = totalDifficulty;
        this.bestHash = bestHash;
        this.genesisHash = genesisHash;
        this.forkHash = forkHash;
        this.forkBlock = forkBlock;
    }

    public final int component1() {
        return this.protocolVersion;
    }

    @NotNull
    public final UInt256 component2() {
        return this.networkID;
    }

    @NotNull
    public final UInt256 component3() {
        return this.totalDifficulty;
    }

    @NotNull
    public final Hash component4() {
        return this.bestHash;
    }

    @NotNull
    public final Hash component5() {
        return this.genesisHash;
    }

    @Nullable
    public final Bytes component6() {
        return this.forkHash;
    }

    @Nullable
    public final Long component7() {
        return this.forkBlock;
    }

    @NotNull
    public final StatusMessage copy(int protocolVersion, @NotNull UInt256 networkID, @NotNull UInt256 totalDifficulty, @NotNull Hash bestHash, @NotNull Hash genesisHash, @Nullable Bytes forkHash, @Nullable Long forkBlock) {
        Intrinsics.checkNotNullParameter((Object)networkID, (String)"networkID");
        Intrinsics.checkNotNullParameter((Object)totalDifficulty, (String)"totalDifficulty");
        Intrinsics.checkNotNullParameter((Object)bestHash, (String)"bestHash");
        Intrinsics.checkNotNullParameter((Object)genesisHash, (String)"genesisHash");
        return new StatusMessage(protocolVersion, networkID, totalDifficulty, bestHash, genesisHash, forkHash, forkBlock);
    }

    public static /* synthetic */ StatusMessage copy$default(StatusMessage statusMessage, int n, UInt256 uInt256, UInt256 uInt2562, Hash hash, Hash hash2, Bytes bytes, Long l, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = statusMessage.protocolVersion;
        }
        if ((n2 & 2) != 0) {
            uInt256 = statusMessage.networkID;
        }
        if ((n2 & 4) != 0) {
            uInt2562 = statusMessage.totalDifficulty;
        }
        if ((n2 & 8) != 0) {
            hash = statusMessage.bestHash;
        }
        if ((n2 & 0x10) != 0) {
            hash2 = statusMessage.genesisHash;
        }
        if ((n2 & 0x20) != 0) {
            bytes = statusMessage.forkHash;
        }
        if ((n2 & 0x40) != 0) {
            l = statusMessage.forkBlock;
        }
        return statusMessage.copy(n, uInt256, uInt2562, hash, hash2, bytes, l);
    }

    @NotNull
    public String toString() {
        return "StatusMessage(protocolVersion=" + this.protocolVersion + ", networkID=" + this.networkID + ", totalDifficulty=" + this.totalDifficulty + ", bestHash=" + this.bestHash + ", genesisHash=" + this.genesisHash + ", forkHash=" + this.forkHash + ", forkBlock=" + this.forkBlock + ")";
    }

    public int hashCode() {
        UInt256 uInt256 = this.networkID;
        UInt256 uInt2562 = this.totalDifficulty;
        Hash hash = this.bestHash;
        Hash hash2 = this.genesisHash;
        Bytes bytes = this.forkHash;
        Long l = this.forkBlock;
        return (((((Integer.hashCode(this.protocolVersion) * 31 + (uInt256 != null ? uInt256.hashCode() : 0)) * 31 + (uInt2562 != null ? uInt2562.hashCode() : 0)) * 31 + (hash != null ? hash.hashCode() : 0)) * 31 + (hash2 != null ? hash2.hashCode() : 0)) * 31 + (bytes != null ? bytes.hashCode() : 0)) * 31 + (l != null ? ((Object)l).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof StatusMessage)) break block3;
                StatusMessage statusMessage = (StatusMessage)object;
                if (this.protocolVersion != statusMessage.protocolVersion || !Intrinsics.areEqual((Object)this.networkID, (Object)statusMessage.networkID) || !Intrinsics.areEqual((Object)this.totalDifficulty, (Object)statusMessage.totalDifficulty) || !Intrinsics.areEqual((Object)this.bestHash, (Object)statusMessage.bestHash) || !Intrinsics.areEqual((Object)this.genesisHash, (Object)statusMessage.genesisHash) || !Intrinsics.areEqual((Object)this.forkHash, (Object)statusMessage.forkHash) || !Intrinsics.areEqual((Object)this.forkBlock, (Object)statusMessage.forkBlock)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/apache/tuweni/devp2p/eth/StatusMessage$Companion;", "", "()V", "read", "Lorg/apache/tuweni/devp2p/eth/StatusMessage;", "payload", "Lorg/apache/tuweni/bytes/Bytes;", "devp2p-eth"})
    public static final class Companion {
        @NotNull
        public final StatusMessage read(@NotNull Bytes payload) {
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            Object object = RLP.decode((Bytes)payload, (Function)read.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"RLP.decode(payload) {\n  \u2026)\n        )\n      }\n    }");
            return (StatusMessage)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

