/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p.eth;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Dispatchers;
import org.apache.tuweni.devp2p.eth.BlockchainInformation;
import org.apache.tuweni.devp2p.eth.ConnectionSelectionStrategy;
import org.apache.tuweni.devp2p.eth.EthClient;
import org.apache.tuweni.devp2p.eth.EthClient66;
import org.apache.tuweni.devp2p.eth.EthController;
import org.apache.tuweni.devp2p.eth.EthHandler;
import org.apache.tuweni.devp2p.eth.EthHandler66;
import org.apache.tuweni.devp2p.eth.EthRequestsManager;
import org.apache.tuweni.devp2p.eth.Status;
import org.apache.tuweni.eth.repository.BlockchainRepository;
import org.apache.tuweni.eth.repository.TransactionPool;
import org.apache.tuweni.rlpx.RLPxService;
import org.apache.tuweni.rlpx.WireConnectionRepository;
import org.apache.tuweni.rlpx.wire.SubProtocol;
import org.apache.tuweni.rlpx.wire.SubProtocolClient;
import org.apache.tuweni.rlpx.wire.SubProtocolHandler;
import org.apache.tuweni.rlpx.wire.SubProtocolIdentifier;
import org.apache.tuweni.rlpx.wire.WireConnection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 $2\u00020\u0001:\u0001$BY\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u0012\u001a\b\u0002\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u000f\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0015H\u0016J\u0016\u0010\u001d\u001a\u0010\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u00190\u00190\u001eH\u0016J\b\u0010 \u001a\u00020\u0019H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0019H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/apache/tuweni/devp2p/eth/EthSubprotocol;", "Lorg/apache/tuweni/rlpx/wire/SubProtocol;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "blockchainInfo", "Lorg/apache/tuweni/devp2p/eth/BlockchainInformation;", "repository", "Lorg/apache/tuweni/eth/repository/BlockchainRepository;", "pendingTransactionsPool", "Lorg/apache/tuweni/eth/repository/TransactionPool;", "selectionStrategy", "Lkotlin/Function1;", "Lorg/apache/tuweni/rlpx/WireConnectionRepository;", "Lorg/apache/tuweni/devp2p/eth/ConnectionSelectionStrategy;", "listener", "Lkotlin/Function2;", "Lorg/apache/tuweni/rlpx/wire/WireConnection;", "Lorg/apache/tuweni/devp2p/eth/Status;", "", "(Lkotlin/coroutines/CoroutineContext;Lorg/apache/tuweni/devp2p/eth/BlockchainInformation;Lorg/apache/tuweni/eth/repository/BlockchainRepository;Lorg/apache/tuweni/eth/repository/TransactionPool;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;)V", "createClient", "Lorg/apache/tuweni/rlpx/wire/SubProtocolClient;", "service", "Lorg/apache/tuweni/rlpx/RLPxService;", "identifier", "Lorg/apache/tuweni/rlpx/wire/SubProtocolIdentifier;", "createHandler", "Lorg/apache/tuweni/rlpx/wire/SubProtocolHandler;", "client", "getCapabilities", "", "kotlin.jvm.PlatformType", "id", "supports", "", "subProtocolIdentifier", "Companion", "devp2p-eth"})
public final class EthSubprotocol
implements SubProtocol {
    private final CoroutineContext coroutineContext;
    private final BlockchainInformation blockchainInfo;
    private final BlockchainRepository repository;
    private final TransactionPool pendingTransactionsPool;
    private final Function1<WireConnectionRepository, ConnectionSelectionStrategy> selectionStrategy;
    private final Function2<WireConnection, Status, Unit> listener;
    private static final SubProtocolIdentifier ETH62;
    private static final SubProtocolIdentifier ETH63;
    private static final SubProtocolIdentifier ETH64;
    private static final SubProtocolIdentifier ETH65;
    private static final SubProtocolIdentifier ETH66;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public SubProtocolIdentifier id() {
        SubProtocolIdentifier subProtocolIdentifier = ETH66;
        Intrinsics.checkNotNullExpressionValue((Object)subProtocolIdentifier, (String)"ETH66");
        return subProtocolIdentifier;
    }

    public boolean supports(@NotNull SubProtocolIdentifier subProtocolIdentifier) {
        Intrinsics.checkNotNullParameter((Object)subProtocolIdentifier, (String)"subProtocolIdentifier");
        return "eth".equals(subProtocolIdentifier.name()) && (subProtocolIdentifier.version() == ETH62.version() || subProtocolIdentifier.version() == ETH63.version() || subProtocolIdentifier.version() == ETH64.version() || subProtocolIdentifier.version() == ETH65.version() || subProtocolIdentifier.version() == ETH66.version());
    }

    @NotNull
    public SubProtocolHandler createHandler(@NotNull RLPxService service, @NotNull SubProtocolClient client) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        EthController controller = new EthController(this.repository, this.pendingTransactionsPool, (EthRequestsManager)client, this.listener);
        if (client instanceof EthClient66) {
            return new EthHandler66(this.coroutineContext, this.blockchainInfo, service, controller);
        }
        return new EthHandler(this.coroutineContext, this.blockchainInfo, service, controller);
    }

    @NotNull
    public List<SubProtocolIdentifier> getCapabilities() {
        return CollectionsKt.mutableListOf((Object[])new SubProtocolIdentifier[]{ETH62, ETH63, ETH64, ETH65, ETH66});
    }

    @NotNull
    public SubProtocolClient createClient(@NotNull RLPxService service, @NotNull SubProtocolIdentifier identifier) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        if (Intrinsics.areEqual((Object)identifier, (Object)ETH66)) {
            WireConnectionRepository wireConnectionRepository = service.repository();
            Intrinsics.checkNotNullExpressionValue((Object)wireConnectionRepository, (String)"service.repository()");
            return new EthClient66(service, this.pendingTransactionsPool, (ConnectionSelectionStrategy)this.selectionStrategy.invoke((Object)wireConnectionRepository));
        }
        WireConnectionRepository wireConnectionRepository = service.repository();
        Intrinsics.checkNotNullExpressionValue((Object)wireConnectionRepository, (String)"service.repository()");
        return new EthClient(service, this.pendingTransactionsPool, (ConnectionSelectionStrategy)this.selectionStrategy.invoke((Object)wireConnectionRepository));
    }

    public EthSubprotocol(@NotNull CoroutineContext coroutineContext, @NotNull BlockchainInformation blockchainInfo, @NotNull BlockchainRepository repository, @NotNull TransactionPool pendingTransactionsPool, @NotNull Function1<? super WireConnectionRepository, ? extends ConnectionSelectionStrategy> selectionStrategy, @NotNull Function2<? super WireConnection, ? super Status, Unit> listener) {
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        Intrinsics.checkNotNullParameter((Object)blockchainInfo, (String)"blockchainInfo");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)pendingTransactionsPool, (String)"pendingTransactionsPool");
        Intrinsics.checkNotNullParameter(selectionStrategy, (String)"selectionStrategy");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.coroutineContext = coroutineContext;
        this.blockchainInfo = blockchainInfo;
        this.repository = repository;
        this.pendingTransactionsPool = pendingTransactionsPool;
        this.selectionStrategy = selectionStrategy;
        this.listener = listener;
    }

    public /* synthetic */ EthSubprotocol(CoroutineContext coroutineContext, BlockchainInformation blockchainInformation, BlockchainRepository blockchainRepository, TransactionPool transactionPool, Function1 function1, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            coroutineContext = (CoroutineContext)Dispatchers.getDefault();
        }
        if ((n & 0x10) != 0) {
            function1 = 1.INSTANCE;
        }
        if ((n & 0x20) != 0) {
            function2 = 2.INSTANCE;
        }
        this(coroutineContext, blockchainInformation, blockchainRepository, transactionPool, (Function1<? super WireConnectionRepository, ? extends ConnectionSelectionStrategy>)function1, (Function2<? super WireConnection, ? super Status, Unit>)function2);
    }

    static {
        Companion = new Companion(null);
        ETH62 = SubProtocolIdentifier.of((String)"eth", (int)62, (int)8);
        ETH63 = SubProtocolIdentifier.of((String)"eth", (int)63, (int)17);
        ETH64 = SubProtocolIdentifier.of((String)"eth", (int)64, (int)17);
        ETH65 = SubProtocolIdentifier.of((String)"eth", (int)65, (int)17);
        ETH66 = SubProtocolIdentifier.of((String)"eth", (int)66, (int)17);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0019\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0019\u0010\f\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0019\u0010\u000e\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lorg/apache/tuweni/devp2p/eth/EthSubprotocol$Companion;", "", "()V", "ETH62", "Lorg/apache/tuweni/rlpx/wire/SubProtocolIdentifier;", "kotlin.jvm.PlatformType", "getETH62", "()Lorg/apache/tuweni/rlpx/wire/SubProtocolIdentifier;", "ETH63", "getETH63", "ETH64", "getETH64", "ETH65", "getETH65", "ETH66", "getETH66", "devp2p-eth"})
    public static final class Companion {
        public final SubProtocolIdentifier getETH62() {
            return ETH62;
        }

        public final SubProtocolIdentifier getETH63() {
            return ETH63;
        }

        public final SubProtocolIdentifier getETH64() {
            return ETH64;
        }

        public final SubProtocolIdentifier getETH65() {
            return ETH65;
        }

        public final SubProtocolIdentifier getETH66() {
            return ETH66;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

