/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.guava;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.guava.Cancelled;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u0013\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019J\r\u0010\u001a\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u001e\u0010\u001a\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0096\u0002\u00a2\u0006\u0002\u0010 J\u0015\u0010!\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020\u0012H\u0016J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020&H\u0016R2\u0010\u0006\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lkotlinx/coroutines/guava/JobListenableFuture;", "T", "Lcom/google/common/util/concurrent/ListenableFuture;", "jobToCancel", "Lkotlinx/coroutines/Job;", "(Lkotlinx/coroutines/Job;)V", "auxFuture", "Lcom/google/common/util/concurrent/SettableFuture;", "", "kotlin.jvm.PlatformType", "addListener", "", "listener", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "executor", "Ljava/util/concurrent/Executor;", "cancel", "", "mayInterruptIfRunning", "complete", "result", "(Ljava/lang/Object;)Z", "completeExceptionallyOrCancel", "t", "", "get", "()Ljava/lang/Object;", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "getInternal", "(Ljava/lang/Object;)Ljava/lang/Object;", "isCancelled", "isDone", "toString", "", "kotlinx-coroutines-guava"})
final class JobListenableFuture<T>
implements ListenableFuture<T> {
    private final SettableFuture<Object> auxFuture;
    private final Job jobToCancel;

    public final boolean complete(T result) {
        return this.auxFuture.set(result);
    }

    public final boolean completeExceptionallyOrCancel(@NotNull Throwable t) {
        return t instanceof CancellationException ? this.auxFuture.set((Object)new Cancelled((CancellationException)t)) : this.auxFuture.setException(t);
    }

    public boolean isCancelled() {
        return this.auxFuture.isCancelled() || this.isDone() && Uninterruptibles.getUninterruptibly((Future)((Future)this.auxFuture)) instanceof Cancelled;
    }

    public T get() {
        return this.getInternal(this.auxFuture.get());
    }

    public T get(long timeout, @NotNull TimeUnit unit) {
        return this.getInternal(this.auxFuture.get(timeout, unit));
    }

    private final T getInternal(Object result) {
        if (result instanceof Cancelled) {
            throw new CancellationException().initCause(((Cancelled)result).exception);
        }
        return (T)result;
    }

    public void addListener(@NotNull Runnable listener, @NotNull Executor executor) {
        this.auxFuture.addListener(listener, executor);
    }

    public boolean isDone() {
        return this.auxFuture.isDone();
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean bl;
        if (this.auxFuture.cancel(mayInterruptIfRunning)) {
            Job.DefaultImpls.cancel$default((Job)this.jobToCancel, null, (int)1, null);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        block7: {
            boolean bl = false;
            boolean bl2 = false;
            stringBuilder = new StringBuilder();
            boolean bl3 = false;
            boolean bl4 = false;
            StringBuilder $this$buildString = stringBuilder;
            boolean bl5 = false;
            $this$buildString.append(super.toString());
            $this$buildString.append("[status=");
            if (this.isDone()) {
                try {
                    Object result = Uninterruptibles.getUninterruptibly((Future)((Future)this.auxFuture));
                    if (result instanceof Cancelled) {
                        $this$buildString.append("CANCELLED, cause=[" + ((Cancelled)result).exception + ']');
                        break block7;
                    }
                    $this$buildString.append("SUCCESS, result=[" + result);
                }
                catch (CancellationException e) {
                    $this$buildString.append("CANCELLED");
                }
                catch (ExecutionException e) {
                    $this$buildString.append("FAILURE, cause=[" + e.getCause() + ']');
                }
                catch (Throwable t) {
                    $this$buildString.append("UNKNOWN, cause=[" + t.getClass() + " thrown from get()]");
                }
            } else {
                $this$buildString.append("PENDING, delegate=[" + this.auxFuture + ']');
            }
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public JobListenableFuture(@NotNull Job jobToCancel) {
        this.jobToCancel = jobToCancel;
        this.auxFuture = SettableFuture.create();
    }
}

