/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.gossip;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.tuweni.plumtree.Peer;
import org.apache.tuweni.plumtree.PeerPruning;

final class CountingPeerPruningFunction
implements PeerPruning {
    private final int numberOfOccurrences;
    private final Map<Peer, Integer> countingOccurrences = Collections.synchronizedMap(new WeakHashMap());

    public CountingPeerPruningFunction(int numberOfOccurrences) {
        this.numberOfOccurrences = numberOfOccurrences;
    }

    public boolean prunePeer(Peer peer) {
        Integer currentValue = this.countingOccurrences.putIfAbsent(peer, 1);
        if (currentValue != null) {
            if (currentValue + 1 >= this.numberOfOccurrences) {
                this.countingOccurrences.remove(peer);
                return true;
            }
            this.countingOccurrences.put(peer, currentValue + 1);
        }
        return false;
    }
}

