@rem
@rem Copyright 2015 the original author or authors.
@rem
@rem Licensed under the Apache License, Version 2.0 (the "License");
@rem you may not use this file except in compliance with the License.
@rem You may obtain a copy of the License at
@rem
@rem      https://www.apache.org/licenses/LICENSE-2.0
@rem
@rem Unless required by applicable law or agreed to in writing, software
@rem distributed under the License is distributed on an "AS IS" BASIS,
@rem WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@rem See the License for the specific language governing permissions and
@rem limitations under the License.
@rem

@if "%DEBUG%" == "" @echo off
@rem ##########################################################################
@rem
@rem  crawler startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%" == "" set DIRNAME=.
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Resolve any "." and ".." in APP_HOME to make it shorter.
for %%i in ("%APP_HOME%") do set APP_HOME=%%~fi

@rem Add default JVM options here. You can also use JAVA_OPTS and CRAWLER_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS=

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if "%ERRORLEVEL%" == "0" goto init

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto init

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:init
@rem Get command-line arguments, handling Windows variants

if not "%OS%" == "Windows_NT" goto win9xME_args

:win9xME_args
@rem Slurp the command line arguments.
set CMD_LINE_ARGS=
set _SKIP=2

:win9xME_args_slurp
if "x%~1" == "x" goto execute

set CMD_LINE_ARGS=%*

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\tuweni-eth-crawler-2.0.0.jar;%APP_HOME%\lib\tuweni-devp2p-2.0.0.jar;%APP_HOME%\lib\tuweni-devp2p-eth-2.0.0.jar;%APP_HOME%\lib\tuweni-ethstats-2.0.0.jar;%APP_HOME%\lib\tuweni-eth-repository-2.0.0.jar;%APP_HOME%\lib\tuweni-eth-2.0.0.jar;%APP_HOME%\lib\tuweni-rlpx-2.0.0.jar;%APP_HOME%\lib\tuweni-merkle-trie-2.0.0.jar;%APP_HOME%\lib\tuweni-crypto-2.0.0.jar;%APP_HOME%\lib\tuweni-rlp-2.0.0.jar;%APP_HOME%\lib\tuweni-units-2.0.0.jar;%APP_HOME%\lib\tuweni-kv-2.0.0.jar;%APP_HOME%\lib\tuweni-bytes-2.0.0.jar;%APP_HOME%\lib\tuweni-concurrent-coroutines-2.0.0.jar;%APP_HOME%\lib\tuweni-concurrent-2.0.0.jar;%APP_HOME%\lib\tuweni-config-2.0.0.jar;%APP_HOME%\lib\tuweni-io-2.0.0.jar;%APP_HOME%\lib\vertx-lang-kotlin-coroutines-3.9.7.jar;%APP_HOME%\lib\vertx-lang-kotlin-3.9.7.jar;%APP_HOME%\lib\vertx-core-3.9.7.jar;%APP_HOME%\lib\jackson-databind-2.11.0.jar;%APP_HOME%\lib\tuweni-kademlia-2.0.0.jar;%APP_HOME%\lib\kotlinx-coroutines-guava-1.4.2.jar;%APP_HOME%\lib\guava-27.0.1-jre.jar;%APP_HOME%\lib\HikariCP-4.0.3.jar;%APP_HOME%\lib\flyway-core-7.8.1.jar;%APP_HOME%\lib\kotlinx-coroutines-jdk8-1.4.2.jar;%APP_HOME%\lib\logback-classic-1.2.3.jar;%APP_HOME%\lib\slf4j-api-1.7.30.jar;%APP_HOME%\lib\tuweni-toml-2.0.0.jar;%APP_HOME%\lib\kotlin-stdlib-jdk8-1.4.20.jar;%APP_HOME%\lib\kotlinx-coroutines-core-jvm-1.4.2.jar;%APP_HOME%\lib\kotlin-stdlib-jdk7-1.4.20.jar;%APP_HOME%\lib\kotlin-stdlib-1.4.20.jar;%APP_HOME%\lib\postgresql-42.2.19.jar;%APP_HOME%\lib\jetty-servlet-9.4.0.v20161208.jar;%APP_HOME%\lib\jetty-security-9.4.0.v20161208.jar;%APP_HOME%\lib\jetty-server-9.4.0.v20161208.jar;%APP_HOME%\lib\jetty-http-9.4.0.v20161208.jar;%APP_HOME%\lib\jetty-io-9.4.0.v20161208.jar;%APP_HOME%\lib\jetty-util-9.4.0.v20161208.jar;%APP_HOME%\lib\jersey-container-servlet-2.31.jar;%APP_HOME%\lib\jersey-container-servlet-core-2.31.jar;%APP_HOME%\lib\jersey-server-2.31.jar;%APP_HOME%\lib\jersey-hk2-2.31.jar;%APP_HOME%\lib\jaxb-api-2.3.1.jar;%APP_HOME%\lib\bcprov-jdk15on-1.66.jar;%APP_HOME%\lib\framework-1.3.2.jar;%APP_HOME%\lib\framework-internal-1.3.2.jar;%APP_HOME%\lib\jnr-ffi-2.1.9.jar;%APP_HOME%\lib\commons-codec-1.14.jar;%APP_HOME%\lib\snappy-java-1.1.7.2.jar;%APP_HOME%\lib\jackson-annotations-2.11.0.jar;%APP_HOME%\lib\jackson-core-2.11.3.jar;%APP_HOME%\lib\failureaccess-1.0.1.jar;%APP_HOME%\lib\listenablefuture-9999.0-empty-to-avoid-conflict-with-guava.jar;%APP_HOME%\lib\jsr305-3.0.2.jar;%APP_HOME%\lib\checker-qual-3.5.0.jar;%APP_HOME%\lib\error_prone_annotations-2.2.0.jar;%APP_HOME%\lib\j2objc-annotations-1.1.jar;%APP_HOME%\lib\animal-sniffer-annotations-1.17.jar;%APP_HOME%\lib\netty-handler-proxy-4.1.60.Final.jar;%APP_HOME%\lib\netty-codec-http2-4.1.60.Final.jar;%APP_HOME%\lib\netty-codec-http-4.1.60.Final.jar;%APP_HOME%\lib\netty-resolver-dns-4.1.60.Final.jar;%APP_HOME%\lib\netty-handler-4.1.60.Final.jar;%APP_HOME%\lib\netty-codec-socks-4.1.60.Final.jar;%APP_HOME%\lib\netty-codec-dns-4.1.60.Final.jar;%APP_HOME%\lib\netty-codec-4.1.60.Final.jar;%APP_HOME%\lib\netty-transport-4.1.60.Final.jar;%APP_HOME%\lib\netty-buffer-4.1.60.Final.jar;%APP_HOME%\lib\netty-resolver-4.1.60.Final.jar;%APP_HOME%\lib\netty-common-4.1.60.Final.jar;%APP_HOME%\lib\kotlin-stdlib-common-1.4.20.jar;%APP_HOME%\lib\annotations-16.0.3.jar;%APP_HOME%\lib\javax.servlet-api-3.1.0.jar;%APP_HOME%\lib\jersey-client-2.31.jar;%APP_HOME%\lib\jersey-media-jaxb-2.31.jar;%APP_HOME%\lib\jersey-common-2.31.jar;%APP_HOME%\lib\jakarta.ws.rs-api-2.1.6.jar;%APP_HOME%\lib\jakarta.annotation-api-1.3.5.jar;%APP_HOME%\lib\hk2-locator-2.6.1.jar;%APP_HOME%\lib\hk2-api-2.6.1.jar;%APP_HOME%\lib\hk2-utils-2.6.1.jar;%APP_HOME%\lib\jakarta.inject-2.6.1.jar;%APP_HOME%\lib\jakarta.validation-api-2.0.2.jar;%APP_HOME%\lib\javassist-3.25.0-GA.jar;%APP_HOME%\lib\javax.activation-api-1.2.0.jar;%APP_HOME%\lib\logback-core-1.2.3.jar;%APP_HOME%\lib\lucene-core-7.6.0.jar;%APP_HOME%\lib\antlr4-runtime-4.7.1.jar;%APP_HOME%\lib\jffi-1.2.17.jar;%APP_HOME%\lib\jffi-1.2.17-native.jar;%APP_HOME%\lib\asm-commons-5.0.3.jar;%APP_HOME%\lib\asm-analysis-5.0.3.jar;%APP_HOME%\lib\asm-util-5.0.3.jar;%APP_HOME%\lib\asm-tree-5.0.3.jar;%APP_HOME%\lib\asm-5.0.3.jar;%APP_HOME%\lib\jnr-a64asm-1.0.0.jar;%APP_HOME%\lib\jnr-x86asm-1.0.2.jar;%APP_HOME%\lib\osgi-resource-locator-1.0.3.jar;%APP_HOME%\lib\aopalliance-repackaged-2.6.1.jar;%APP_HOME%\lib\javax.persistence-api-2.2.jar

@rem Execute crawler
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %CRAWLER_OPTS%  -classpath "%CLASSPATH%" org.apache.tuweni.eth.crawler.CrawlerApp %CMD_LINE_ARGS%

:end
@rem End local scope for the variables with windows NT shell
if "%ERRORLEVEL%"=="0" goto mainEnd

:fail
rem Set variable CRAWLER_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
if  not "" == "%CRAWLER_EXIT_CONSOLE%" exit 1
exit /b 1

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
