/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.net.tls;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.net.tls.FingerprintRepository;
import org.apache.tuweni.net.tls.TLS;

final class ServerFingerprintTrustManager
extends X509ExtendedTrustManager {
    private static final X509Certificate[] EMPTY_X509_CERTIFICATES = new X509Certificate[0];
    private final FingerprintRepository repository;
    private final boolean acceptNewFingerprints;
    private final boolean updateFingerprints;

    static ServerFingerprintTrustManager record(FingerprintRepository repository) {
        return new ServerFingerprintTrustManager(repository, true, true);
    }

    static ServerFingerprintTrustManager tofu(FingerprintRepository repository) {
        return new ServerFingerprintTrustManager(repository, true, false);
    }

    static ServerFingerprintTrustManager allowlist(FingerprintRepository repository) {
        return new ServerFingerprintTrustManager(repository, false, false);
    }

    private ServerFingerprintTrustManager(FingerprintRepository repository, boolean acceptNewFingerprints, boolean updateFingerprints) {
        this.repository = repository;
        this.acceptNewFingerprints = acceptNewFingerprints;
        this.updateFingerprints = updateFingerprints;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        InetSocketAddress socketAddress = (InetSocketAddress)socket.getRemoteSocketAddress();
        this.checkTrusted(chain, socketAddress.getHostName(), socketAddress.getPort());
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.checkTrusted(chain, engine.getPeerHost(), engine.getPeerPort());
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        throw new UnsupportedOperationException();
    }

    private void checkTrusted(X509Certificate[] chain, String host, int port) throws CertificateException {
        Bytes fingerprint;
        X509Certificate cert = chain[0];
        String identifier = this.hostIdentifier(host, port);
        if (this.repository.contains(identifier, fingerprint = Bytes.wrap((byte[])TLS.certificateFingerprint(cert)))) {
            return;
        }
        if (this.repository.contains(identifier)) {
            if (!this.updateFingerprints) {
                throw new CertificateException(String.format("Remote host identification has changed!! Certificate for %s (%s) has fingerprint %s", identifier, cert.getSubjectDN(), fingerprint.toHexString().substring(2).toLowerCase()));
            }
        } else if (!this.acceptNewFingerprints) {
            throw new CertificateException(String.format("Certificate for %s (%s) has unknown fingerprint %s", identifier, cert.getSubjectDN(), fingerprint.toHexString().substring(2).toLowerCase()));
        }
        this.repository.addFingerprint(identifier, fingerprint);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return EMPTY_X509_CERTIFICATES;
    }

    private String hostIdentifier(String host, int port) {
        return host.trim().toLowerCase() + ":" + port;
    }
}

