/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.kv;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlinx.coroutines.Dispatchers;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.concurrent.AsyncCompletion;
import org.apache.tuweni.concurrent.AsyncResult;
import org.apache.tuweni.io.file.Files;
import org.apache.tuweni.kv.KeyValueStore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksIterator;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0006\u0018\u0000 '*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003:\u0002&'Bq\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00010\u0007\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0011\u0010\u0017\u001a\u00020\u0018H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u0018H\u0016J\u0019\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00028\u0000H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u00020\u0016H\u0002J\u001b\u0010 \u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001d\u001a\u00028\u0000H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001eJ\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\"H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019J!\u0010#\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00028\u00002\u0006\u0010$\u001a\u00028\u0001H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010%R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006("}, d2={"Lorg/apache/tuweni/kv/RocksDBKeyValueStore;", "K", "V", "Lorg/apache/tuweni/kv/KeyValueStore;", "dbPath", "Ljava/nio/file/Path;", "keySerializer", "Lkotlin/Function1;", "Lorg/apache/tuweni/bytes/Bytes;", "valueSerializer", "keyDeserializer", "valueDeserializer", "options", "Lorg/rocksdb/Options;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lorg/rocksdb/Options;Lkotlin/coroutines/CoroutineContext;)V", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "db", "Lorg/rocksdb/RocksDB;", "clear", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "close", "containsKey", "", "key", "(Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "create", "get", "keys", "", "put", "value", "(Ljava/lang/Object;Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "BytesIterator", "Companion", "kv"})
public final class RocksDBKeyValueStore<K, V>
implements KeyValueStore<K, V> {
    private RocksDB db;
    private final AtomicBoolean closed;
    private final Path dbPath;
    private final Function1<K, Bytes> keySerializer;
    private final Function1<V, Bytes> valueSerializer;
    private final Function1<Bytes, K> keyDeserializer;
    private final Function1<Bytes, V> valueDeserializer;
    private final Options options;
    @NotNull
    private final CoroutineContext coroutineContext;
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final RocksDB create() {
        java.nio.file.Files.createDirectories(this.dbPath, new FileAttribute[0]);
        RocksDB rocksDB = RocksDB.open((Options)this.options, (String)((Object)this.dbPath.toAbsolutePath()).toString());
        Intrinsics.checkNotNullExpressionValue((Object)rocksDB, (String)"RocksDB.open(options, db\u2026bsolutePath().toString())");
        return rocksDB;
    }

    @Override
    @Nullable
    public Object containsKey(K key, @NotNull Continuation<? super Boolean> $completion) {
        return Boxing.boxBoolean((this.db.get(((Bytes)this.keySerializer.invoke(key)).toArrayUnsafe()) != null ? 1 : 0) != 0);
    }

    @Override
    @Nullable
    public Object get(K key, @NotNull Continuation<? super V> $completion) {
        Object object;
        if (this.closed.get()) {
            throw (Throwable)new IllegalStateException("Closed DB");
        }
        byte[] rawValue = this.db.get(((Bytes)this.keySerializer.invoke(key)).toArrayUnsafe());
        if (rawValue == null) {
            object = null;
        } else {
            Bytes bytes = Bytes.wrap((byte[])rawValue);
            Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"Bytes.wrap(rawValue)");
            object = this.valueDeserializer.invoke((Object)bytes);
        }
        return object;
    }

    @Override
    @Nullable
    public Object put(K key, V value, @NotNull Continuation<? super Unit> $completion) {
        if (this.closed.get()) {
            throw (Throwable)new IllegalStateException("Closed DB");
        }
        this.db.put(((Bytes)this.keySerializer.invoke(key)).toArrayUnsafe(), ((Bytes)this.valueSerializer.invoke(value)).toArrayUnsafe());
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object keys(@NotNull Continuation<? super Iterable<? extends K>> $completion) {
        if (this.closed.get()) {
            throw (Throwable)new IllegalStateException("Closed DB");
        }
        RocksIterator iter = this.db.newIterator();
        iter.seekToFirst();
        boolean bl = false;
        return new Iterable<K>(this, iter){
            final /* synthetic */ RocksDBKeyValueStore this$0;
            final /* synthetic */ RocksIterator $iter$inlined;
            {
                this.this$0 = rocksDBKeyValueStore;
                this.$iter$inlined = rocksIterator;
            }

            @NotNull
            public Iterator<K> iterator() {
                boolean bl = false;
                RocksIterator rocksIterator = this.$iter$inlined;
                Intrinsics.checkNotNullExpressionValue((Object)rocksIterator, (String)"iter");
                return new BytesIterator<K>(rocksIterator, RocksDBKeyValueStore.access$getKeyDeserializer$p(this.this$0));
            }
        };
    }

    @Override
    @Nullable
    public Object clear(@NotNull Continuation<? super Unit> $completion) {
        this.close();
        if (this.closed.compareAndSet(true, false)) {
            Files.deleteRecursively((Path)this.dbPath);
            this.db = this.create();
        }
        return Unit.INSTANCE;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.db.close();
        }
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    public RocksDBKeyValueStore(@NotNull Path dbPath, @NotNull Function1<? super K, ? extends Bytes> keySerializer, @NotNull Function1<? super V, ? extends Bytes> valueSerializer, @NotNull Function1<? super Bytes, ? extends K> keyDeserializer, @NotNull Function1<? super Bytes, ? extends V> valueDeserializer, @NotNull Options options, @NotNull CoroutineContext coroutineContext) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dbPath, (String)"dbPath");
        Intrinsics.checkNotNullParameter(keySerializer, (String)"keySerializer");
        Intrinsics.checkNotNullParameter(valueSerializer, (String)"valueSerializer");
        Intrinsics.checkNotNullParameter(keyDeserializer, (String)"keyDeserializer");
        Intrinsics.checkNotNullParameter(valueDeserializer, (String)"valueDeserializer");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        this.dbPath = dbPath;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.keyDeserializer = keyDeserializer;
        this.valueDeserializer = valueDeserializer;
        this.options = options;
        this.coroutineContext = coroutineContext;
        this.closed = new AtomicBoolean(false);
        RocksDB.loadLibrary();
        this.db = this.create();
    }

    public /* synthetic */ RocksDBKeyValueStore(Path path, Function1 function1, Function1 function12, Function1 function13, Function1 function14, Options options, CoroutineContext coroutineContext, int n, DefaultConstructorMarker defaultConstructorMarker) throws IOException {
        if ((n & 0x20) != 0) {
            Options options2 = new Options().setCreateIfMissing(true).setWriteBufferSize(0x10000000L).setMaxOpenFiles(-1);
            Intrinsics.checkNotNullExpressionValue((Object)options2, (String)"Options().setCreateIfMis\u20265456).setMaxOpenFiles(-1)");
            options = options2;
        }
        if ((n & 0x40) != 0) {
            coroutineContext = (CoroutineContext)Dispatchers.getIO();
        }
        this(path, function1, function12, function13, function14, options, coroutineContext);
    }

    @Override
    @NotNull
    public AsyncResult<Boolean> containsKeyAsync(K key) {
        return KeyValueStore.DefaultImpls.containsKeyAsync(this, key);
    }

    @Override
    @NotNull
    public AsyncResult<V> getAsync(K key) {
        return KeyValueStore.DefaultImpls.getAsync(this, key);
    }

    @Override
    @NotNull
    public AsyncCompletion putAsync(K key, V value) {
        return KeyValueStore.DefaultImpls.putAsync(this, key, value);
    }

    @Override
    @NotNull
    public AsyncResult<Iterable<K>> keysAsync() {
        return KeyValueStore.DefaultImpls.keysAsync(this);
    }

    @Override
    @NotNull
    public AsyncCompletion clearAsync() {
        return KeyValueStore.DefaultImpls.clearAsync(this);
    }

    public static final /* synthetic */ Function1 access$getKeyDeserializer$p(RocksDBKeyValueStore $this) {
        return $this.keyDeserializer;
    }

    @JvmStatic
    @NotNull
    public static final <K, V> RocksDBKeyValueStore<K, V> open(@NotNull Path dbPath, @NotNull Function<K, Bytes> keySerializer, @NotNull Function<V, Bytes> valueSerializer, @NotNull Function<Bytes, K> keyDeserializer, @NotNull Function<Bytes, V> valueDeserializer) throws IOException {
        return Companion.open(dbPath, keySerializer, valueSerializer, keyDeserializer, valueDeserializer);
    }

    @JvmStatic
    @NotNull
    public static final <K, V> RocksDBKeyValueStore<K, V> open(@NotNull Path dbPath, @NotNull Function<K, Bytes> keySerializer, @NotNull Function<V, Bytes> valueSerializer, @NotNull Function<Bytes, K> keyDeserializer, @NotNull Function<Bytes, V> valueDeserializer, @NotNull Options options) throws IOException {
        return Companion.open(dbPath, keySerializer, valueSerializer, keyDeserializer, valueDeserializer, options);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0002\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\t\u0010\r\u001a\u00020\u000eH\u0096\u0002J\u000e\u0010\u000f\u001a\u00028\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u0010R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/apache/tuweni/kv/RocksDBKeyValueStore$BytesIterator;", "K", "", "rIterator", "Lorg/rocksdb/RocksIterator;", "keyDeserializer", "Lkotlin/Function1;", "Lorg/apache/tuweni/bytes/Bytes;", "(Lorg/rocksdb/RocksIterator;Lkotlin/jvm/functions/Function1;)V", "getKeyDeserializer", "()Lkotlin/jvm/functions/Function1;", "getRIterator", "()Lorg/rocksdb/RocksIterator;", "hasNext", "", "next", "()Ljava/lang/Object;", "kv"})
    private static final class BytesIterator<K>
    implements Iterator<K>,
    KMappedMarker {
        @NotNull
        private final RocksIterator rIterator;
        @NotNull
        private final Function1<Bytes, K> keyDeserializer;

        @Override
        public boolean hasNext() {
            return this.rIterator.isValid();
        }

        @Override
        public K next() {
            byte[] key = this.rIterator.key();
            this.rIterator.next();
            Bytes bytes = Bytes.wrap((byte[])key);
            Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"Bytes.wrap(key)");
            return (K)this.keyDeserializer.invoke((Object)bytes);
        }

        @NotNull
        public final RocksIterator getRIterator() {
            return this.rIterator;
        }

        @NotNull
        public final Function1<Bytes, K> getKeyDeserializer() {
            return this.keyDeserializer;
        }

        public BytesIterator(@NotNull RocksIterator rIterator, @NotNull Function1<? super Bytes, ? extends K> keyDeserializer) {
            Intrinsics.checkNotNullParameter((Object)rIterator, (String)"rIterator");
            Intrinsics.checkNotNullParameter(keyDeserializer, (String)"keyDeserializer");
            this.rIterator = rIterator;
            this.keyDeserializer = keyDeserializer;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jx\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u0004\"\u0004\b\u0002\u0010\u0005\"\u0004\b\u0003\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u000b0\n2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u000b0\n2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\u00050\n2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\u00060\nH\u0007J\u0080\u0001\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u0004\"\u0004\b\u0002\u0010\u0005\"\u0004\b\u0003\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020\u000b0\n2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u00020\u000b0\n2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\u00050\n2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\u00060\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007\u00a8\u0006\u0011"}, d2={"Lorg/apache/tuweni/kv/RocksDBKeyValueStore$Companion;", "", "()V", "open", "Lorg/apache/tuweni/kv/RocksDBKeyValueStore;", "K", "V", "dbPath", "Ljava/nio/file/Path;", "keySerializer", "Ljava/util/function/Function;", "Lorg/apache/tuweni/bytes/Bytes;", "valueSerializer", "keyDeserializer", "valueDeserializer", "options", "Lorg/rocksdb/Options;", "kv"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final <K, V> RocksDBKeyValueStore<K, V> open(@NotNull Path dbPath, @NotNull Function<K, Bytes> keySerializer, @NotNull Function<V, Bytes> valueSerializer, @NotNull Function<Bytes, K> keyDeserializer, @NotNull Function<Bytes, V> valueDeserializer) throws IOException {
            Intrinsics.checkNotNullParameter((Object)dbPath, (String)"dbPath");
            Intrinsics.checkNotNullParameter(keySerializer, (String)"keySerializer");
            Intrinsics.checkNotNullParameter(valueSerializer, (String)"valueSerializer");
            Intrinsics.checkNotNullParameter(keyDeserializer, (String)"keyDeserializer");
            Intrinsics.checkNotNullParameter(valueDeserializer, (String)"valueDeserializer");
            return new RocksDBKeyValueStore(dbPath, new Function1<K, Bytes>(keySerializer){

                @NotNull
                public final Bytes invoke(K p1) {
                    return (Bytes)((Function)this.receiver).apply(p1);
                }
            }, new Function1<V, Bytes>(valueSerializer){

                @NotNull
                public final Bytes invoke(V p1) {
                    return (Bytes)((Function)this.receiver).apply(p1);
                }
            }, new Function1<Bytes, K>(keyDeserializer){

                public final K invoke(@NotNull Bytes p1) {
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    return (K)((Function)this.receiver).apply(p1);
                }
            }, new Function1<Bytes, V>(valueDeserializer){

                public final V invoke(@NotNull Bytes p1) {
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    return (V)((Function)this.receiver).apply(p1);
                }
            }, null, null, 96, null);
        }

        @JvmStatic
        @NotNull
        public final <K, V> RocksDBKeyValueStore<K, V> open(@NotNull Path dbPath, @NotNull Function<K, Bytes> keySerializer, @NotNull Function<V, Bytes> valueSerializer, @NotNull Function<Bytes, K> keyDeserializer, @NotNull Function<Bytes, V> valueDeserializer, @NotNull Options options) throws IOException {
            Intrinsics.checkNotNullParameter((Object)dbPath, (String)"dbPath");
            Intrinsics.checkNotNullParameter(keySerializer, (String)"keySerializer");
            Intrinsics.checkNotNullParameter(valueSerializer, (String)"valueSerializer");
            Intrinsics.checkNotNullParameter(keyDeserializer, (String)"keyDeserializer");
            Intrinsics.checkNotNullParameter(valueDeserializer, (String)"valueDeserializer");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            return new RocksDBKeyValueStore(dbPath, new Function1<K, Bytes>(keySerializer){

                @NotNull
                public final Bytes invoke(K p1) {
                    return (Bytes)((Function)this.receiver).apply(p1);
                }
            }, new Function1<V, Bytes>(valueSerializer){

                @NotNull
                public final Bytes invoke(V p1) {
                    return (Bytes)((Function)this.receiver).apply(p1);
                }
            }, new Function1<Bytes, K>(keyDeserializer){

                public final K invoke(@NotNull Bytes p1) {
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    return (K)((Function)this.receiver).apply(p1);
                }
            }, new Function1<Bytes, V>(valueDeserializer){

                public final V invoke(@NotNull Bytes p1) {
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    return (V)((Function)this.receiver).apply(p1);
                }
            }, options, null, 64, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

