/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.rlpx.wire;

import java.util.Collection;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.rlpx.wire.DisconnectReason;
import org.apache.tuweni.rlpx.wire.HelloMessage;
import org.apache.tuweni.rlpx.wire.SubProtocolIdentifier;

public interface WireConnection {
    public boolean supports(SubProtocolIdentifier var1);

    public Collection<SubProtocolIdentifier> agreedSubprotocols();

    public boolean isDisconnectReceived();

    public boolean isDisconnectRequested();

    public DisconnectReason getDisconnectReason();

    public String peerHost();

    public int peerPort();

    public SECP256K1.PublicKey peerPublicKey();

    default public String uri() {
        return "enode://" + this.peerPublicKey().toHexString() + "@" + this.peerHost() + ":" + this.peerPort();
    }

    public HelloMessage getPeerHello();

    public void registerListener(EventListener var1);

    public static enum Event {
        CONNECTED,
        DISCONNECTED;

    }

    public static interface EventListener {
        public void onEvent(Event var1);
    }
}

