/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.crypto;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.crypto.sodium.SHA256Hash;
import org.apache.tuweni.crypto.sodium.Sodium;

public final class Hash {
    static boolean USE_SODIUM = true;
    private static String SHA2_256 = "SHA-256";
    private static String SHA2_512_256 = "SHA-512/256";
    private static String KECCAK_256 = "KECCAK-256";
    private static String KECCAK_512 = "KECCAK-512";
    private static String SHA3_256 = "SHA3-256";
    private static String SHA3_512 = "SHA3-512";

    private Hash() {
    }

    public static byte[] digestUsingAlgorithm(byte[] input, String alg) throws NoSuchAlgorithmException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(alg);
        MessageDigest digest = MessageDigest.getInstance(alg);
        digest.update(input);
        return digest.digest();
    }

    public static Bytes digestUsingAlgorithm(Bytes input, String alg) throws NoSuchAlgorithmException {
        Objects.requireNonNull(input);
        return Bytes.wrap((byte[])Hash.digestUsingAlgorithm(input.toArrayUnsafe(), alg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] sha2_256(byte[] input) {
        if (USE_SODIUM && Sodium.isAvailable()) {
            SHA256Hash.Input shaInput = SHA256Hash.Input.fromBytes(input);
            try {
                SHA256Hash.Hash result = SHA256Hash.hash(shaInput);
                try {
                    byte[] byArray = SHA256Hash.hash(shaInput).bytesArray();
                    result.destroy();
                    return byArray;
                }
                catch (Throwable throwable) {
                    result.destroy();
                    throw throwable;
                }
            }
            finally {
                shaInput.destroy();
            }
        }
        try {
            return Hash.digestUsingAlgorithm(input, SHA2_256);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Algorithm should be available but was not", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bytes32 sha2_256(Bytes input) {
        if (USE_SODIUM && Sodium.isAvailable()) {
            SHA256Hash.Input shaInput = SHA256Hash.Input.fromBytes(input);
            try {
                SHA256Hash.Hash result = SHA256Hash.hash(shaInput);
                try {
                    Bytes32 bytes32 = (Bytes32)SHA256Hash.hash(shaInput).bytes();
                    result.destroy();
                    return bytes32;
                }
                catch (Throwable throwable) {
                    result.destroy();
                    throw throwable;
                }
            }
            finally {
                shaInput.destroy();
            }
        }
        try {
            return (Bytes32)Hash.digestUsingAlgorithm(input, SHA2_256);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Algorithm should be available but was not", e);
        }
    }

    public static byte[] sha2_512_256(byte[] input) {
        try {
            return Hash.digestUsingAlgorithm(input, SHA2_512_256);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Algorithm should be available but was not", e);
        }
    }

    public static Bytes32 sha2_512_256(Bytes input) {
        try {
            return (Bytes32)Hash.digestUsingAlgorithm(input, SHA2_512_256);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Algorithm should be available but was not", e);
        }
    }

    public static byte[] keccak256(byte[] input) {
        try {
            return Hash.digestUsingAlgorithm(input, KECCAK_256);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Algorithm should be available but was not", e);
        }
    }

    public static Bytes32 keccak256(Bytes input) {
        try {
            return (Bytes32)Hash.digestUsingAlgorithm(input, KECCAK_256);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Algorithm should be available but was not", e);
        }
    }

    public static byte[] keccak512(byte[] input) {
        try {
            return Hash.digestUsingAlgorithm(input, KECCAK_512);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Algorithm should be available but was not", e);
        }
    }

    public static Bytes keccak512(Bytes input) {
        try {
            return Hash.digestUsingAlgorithm(input, KECCAK_512);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Algorithm should be available but was not", e);
        }
    }

    public static byte[] sha3_256(byte[] input) {
        try {
            return Hash.digestUsingAlgorithm(input, SHA3_256);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Algorithm should be available but was not", e);
        }
    }

    public static Bytes32 sha3_256(Bytes input) {
        try {
            return (Bytes32)Hash.digestUsingAlgorithm(input, SHA3_256);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Algorithm should be available but was not", e);
        }
    }

    public static byte[] sha3_512(byte[] input) {
        try {
            return Hash.digestUsingAlgorithm(input, SHA3_512);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Algorithm should be available but was not", e);
        }
    }

    public static Bytes sha3_512(Bytes input) {
        try {
            return Hash.digestUsingAlgorithm(input, SHA3_512);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Algorithm should be available but was not", e);
        }
    }
}

