/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p.v5.topic;

import java.net.InetAddress;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.devp2p.v5.encrypt.AES128GCM;
import org.apache.tuweni.devp2p.v5.topic.Ticket;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.rlp.RLPWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0017\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0080\b\u0018\u0000 (2\u00020\u0001:\u0001(B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001a\u001a\u00020\bH\u00c6\u0003JE\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\bH\u00c6\u0001J\u0006\u0010\u001c\u001a\u00020\u0003J\u000e\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\t\u0010$\u001a\u00020\u0006H\u00d6\u0001J&\u0010%\u001a\u00020&2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003R\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\r\u00a8\u0006)"}, d2={"Lorg/apache/tuweni/devp2p/v5/topic/Ticket;", "", "topic", "Lorg/apache/tuweni/bytes/Bytes;", "srcNodeId", "srcIp", "", "requestTime", "", "waitTime", "cumTime", "(Lorg/apache/tuweni/bytes/Bytes;Lorg/apache/tuweni/bytes/Bytes;Ljava/lang/String;JJJ)V", "getCumTime", "()J", "getRequestTime", "getSrcIp", "()Ljava/lang/String;", "getSrcNodeId", "()Lorg/apache/tuweni/bytes/Bytes;", "getTopic", "getWaitTime", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "encode", "encrypt", "key", "equals", "", "other", "hashCode", "", "toString", "validate", "", "now", "Companion", "devp2p"})
public final class Ticket {
    @NotNull
    private final Bytes topic;
    @NotNull
    private final Bytes srcNodeId;
    @NotNull
    private final String srcIp;
    private final long requestTime;
    private final long waitTime;
    private final long cumTime;
    private static final int ZERO_NONCE_SIZE = 12;
    public static final int TIME_WINDOW_MS = 10000;
    @NotNull
    public static final String TICKET_INVALID_MSG = "Ticket is invalid";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Bytes encode() {
        Bytes bytes = RLP.encodeList((Consumer)new Consumer<RLPWriter>(this){
            final /* synthetic */ Ticket this$0;

            public final void accept(RLPWriter writer) {
                writer.writeValue(this.this$0.getTopic());
                writer.writeValue(this.this$0.getSrcNodeId());
                InetAddress inetAddress = InetAddress.getByName(this.this$0.getSrcIp());
                Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"InetAddress.getByName(srcIp)");
                writer.writeValue(Bytes.wrap((byte[])inetAddress.getAddress()));
                writer.writeLong(this.this$0.getRequestTime());
                writer.writeLong(this.this$0.getWaitTime());
                writer.writeLong(this.this$0.getCumTime());
            }
            {
                this.this$0 = ticket;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"RLP.encodeList { writer \u2026.writeLong(cumTime)\n    }");
        return bytes;
    }

    @NotNull
    public final Bytes encrypt(@NotNull Bytes key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Bytes ticketBytes = this.encode();
        Bytes bytes = Bytes.wrap((byte[])new byte[12]);
        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"Bytes.wrap(ByteArray(ZERO_NONCE_SIZE))");
        Bytes bytes2 = Bytes.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)bytes2, (String)"Bytes.EMPTY");
        return AES128GCM.INSTANCE.encrypt(key, bytes, ticketBytes, bytes2);
    }

    public final void validate(@NotNull Bytes srcNodeId, @NotNull String srcIp, long now, @NotNull Bytes topic) {
        Intrinsics.checkNotNullParameter((Object)srcNodeId, (String)"srcNodeId");
        Intrinsics.checkNotNullParameter((Object)srcIp, (String)"srcIp");
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        boolean bl = Intrinsics.areEqual((Object)this.srcNodeId, (Object)srcNodeId);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = TICKET_INVALID_MSG;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = Intrinsics.areEqual((Object)this.srcIp, (Object)srcIp);
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = TICKET_INVALID_MSG;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = Intrinsics.areEqual((Object)this.topic, (Object)topic);
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = TICKET_INVALID_MSG;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        long windowStart = this.requestTime + this.waitTime;
        bl3 = now >= windowStart && now <= windowStart + (long)10000;
        boolean bl7 = false;
        boolean bl8 = false;
        if (!bl3) {
            boolean bl9 = false;
            String string = TICKET_INVALID_MSG;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final Bytes getTopic() {
        return this.topic;
    }

    @NotNull
    public final Bytes getSrcNodeId() {
        return this.srcNodeId;
    }

    @NotNull
    public final String getSrcIp() {
        return this.srcIp;
    }

    public final long getRequestTime() {
        return this.requestTime;
    }

    public final long getWaitTime() {
        return this.waitTime;
    }

    public final long getCumTime() {
        return this.cumTime;
    }

    public Ticket(@NotNull Bytes topic, @NotNull Bytes srcNodeId, @NotNull String srcIp, long requestTime, long waitTime, long cumTime) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)srcNodeId, (String)"srcNodeId");
        Intrinsics.checkNotNullParameter((Object)srcIp, (String)"srcIp");
        this.topic = topic;
        this.srcNodeId = srcNodeId;
        this.srcIp = srcIp;
        this.requestTime = requestTime;
        this.waitTime = waitTime;
        this.cumTime = cumTime;
    }

    @NotNull
    public final Bytes component1() {
        return this.topic;
    }

    @NotNull
    public final Bytes component2() {
        return this.srcNodeId;
    }

    @NotNull
    public final String component3() {
        return this.srcIp;
    }

    public final long component4() {
        return this.requestTime;
    }

    public final long component5() {
        return this.waitTime;
    }

    public final long component6() {
        return this.cumTime;
    }

    @NotNull
    public final Ticket copy(@NotNull Bytes topic, @NotNull Bytes srcNodeId, @NotNull String srcIp, long requestTime, long waitTime, long cumTime) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)srcNodeId, (String)"srcNodeId");
        Intrinsics.checkNotNullParameter((Object)srcIp, (String)"srcIp");
        return new Ticket(topic, srcNodeId, srcIp, requestTime, waitTime, cumTime);
    }

    public static /* synthetic */ Ticket copy$default(Ticket ticket, Bytes bytes, Bytes bytes2, String string, long l, long l2, long l3, int n, Object object) {
        if ((n & 1) != 0) {
            bytes = ticket.topic;
        }
        if ((n & 2) != 0) {
            bytes2 = ticket.srcNodeId;
        }
        if ((n & 4) != 0) {
            string = ticket.srcIp;
        }
        if ((n & 8) != 0) {
            l = ticket.requestTime;
        }
        if ((n & 0x10) != 0) {
            l2 = ticket.waitTime;
        }
        if ((n & 0x20) != 0) {
            l3 = ticket.cumTime;
        }
        return ticket.copy(bytes, bytes2, string, l, l2, l3);
    }

    @NotNull
    public String toString() {
        return "Ticket(topic=" + this.topic + ", srcNodeId=" + this.srcNodeId + ", srcIp=" + this.srcIp + ", requestTime=" + this.requestTime + ", waitTime=" + this.waitTime + ", cumTime=" + this.cumTime + ")";
    }

    public int hashCode() {
        Bytes bytes = this.topic;
        Bytes bytes2 = this.srcNodeId;
        String string = this.srcIp;
        return (((((bytes != null ? bytes.hashCode() : 0) * 31 + (bytes2 != null ? bytes2.hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0)) * 31 + Long.hashCode(this.requestTime)) * 31 + Long.hashCode(this.waitTime)) * 31 + Long.hashCode(this.cumTime);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Ticket)) break block3;
                Ticket ticket = (Ticket)object;
                if (!Intrinsics.areEqual((Object)this.topic, (Object)ticket.topic) || !Intrinsics.areEqual((Object)this.srcNodeId, (Object)ticket.srcNodeId) || !Intrinsics.areEqual((Object)this.srcIp, (Object)ticket.srcIp) || this.requestTime != ticket.requestTime || this.waitTime != ticket.waitTime || this.cumTime != ticket.cumTime) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/apache/tuweni/devp2p/v5/topic/Ticket$Companion;", "", "()V", "TICKET_INVALID_MSG", "", "TIME_WINDOW_MS", "", "ZERO_NONCE_SIZE", "create", "Lorg/apache/tuweni/devp2p/v5/topic/Ticket;", "content", "Lorg/apache/tuweni/bytes/Bytes;", "decrypt", "encrypted", "key", "devp2p"})
    public static final class Companion {
        @NotNull
        public final Ticket create(@NotNull Bytes content) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Object object = RLP.decodeList((Bytes)content, (Function)create.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"RLP.decodeList(content) \u2026aitTime, cumTime)\n      }");
            return (Ticket)object;
        }

        @NotNull
        public final Ticket decrypt(@NotNull Bytes encrypted, @NotNull Bytes key) {
            Intrinsics.checkNotNullParameter((Object)encrypted, (String)"encrypted");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Bytes bytes = Bytes.wrap((byte[])new byte[12]);
            Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"Bytes.wrap(ByteArray(ZERO_NONCE_SIZE))");
            Bytes bytes2 = Bytes.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)bytes2, (String)"Bytes.EMPTY");
            Bytes decrypted = AES128GCM.INSTANCE.decrypt(key, bytes, encrypted, bytes2);
            return this.create(decrypted);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

