/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.devp2p.ENRRequestPacket;
import org.apache.tuweni.devp2p.ENRResponsePacket;
import org.apache.tuweni.devp2p.FindNodePacket;
import org.apache.tuweni.devp2p.NeighborsPacket;
import org.apache.tuweni.devp2p.Packet;
import org.apache.tuweni.devp2p.PingPacket;
import org.apache.tuweni.devp2p.PongPacket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0080\u0001\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0017B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016\u00a8\u0006\u0018"}, d2={"Lorg/apache/tuweni/devp2p/PacketType;", "", "typeId", "", "(Ljava/lang/String;IB)V", "getTypeId", "()B", "decode", "Lorg/apache/tuweni/devp2p/Packet;", "payload", "Lorg/apache/tuweni/bytes/Bytes;", "hash", "Lorg/apache/tuweni/bytes/Bytes32;", "publicKey", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "signature", "Lorg/apache/tuweni/crypto/SECP256K1$Signature;", "PING", "PONG", "FIND_NODE", "NEIGHBORS", "ENRREQUEST", "ENRRESPONSE", "Companion", "devp2p"})
public abstract class PacketType
extends Enum<PacketType> {
    public static final /* enum */ PacketType PING;
    public static final /* enum */ PacketType PONG;
    public static final /* enum */ PacketType FIND_NODE;
    public static final /* enum */ PacketType NEIGHBORS;
    public static final /* enum */ PacketType ENRREQUEST;
    public static final /* enum */ PacketType ENRRESPONSE;
    private static final /* synthetic */ PacketType[] $VALUES;
    private final byte typeId;
    private static final byte MAX_VALUE = 127;
    private static final PacketType[] INDEX;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    static {
        void $this$forEach$iv;
        PING = new PING("PING", 0);
        PONG = new PONG("PONG", 1);
        FIND_NODE = new FIND_NODE("FIND_NODE", 2);
        NEIGHBORS = new NEIGHBORS("NEIGHBORS", 3);
        ENRREQUEST = new ENRREQUEST("ENRREQUEST", 4);
        ENRRESPONSE = new ENRRESPONSE("ENRRESPONSE", 5);
        $VALUES = new PacketType[]{PING, PONG, FIND_NODE, NEIGHBORS, ENRREQUEST, ENRRESPONSE};
        Companion = new Companion(null);
        INDEX = new PacketType[127];
        PacketType[] packetTypeArray = PacketType.values();
        PacketType[] packetTypeArray2 = $VALUES;
        boolean $i$f$forEach = false;
        void var2_3 = $this$forEach$iv;
        int n = ((void)var2_3).length;
        for (int i = 0; i < n; ++i) {
            void element$iv;
            void type = element$iv = var2_3[i];
            boolean bl = false;
            PacketType.INDEX[type.typeId] = type;
        }
        PacketType[] packetTypeArray3 = packetTypeArray2;
    }

    @NotNull
    public abstract Packet decode(@NotNull Bytes var1, @NotNull Bytes32 var2, @NotNull SECP256K1.PublicKey var3, @NotNull SECP256K1.Signature var4);

    public final byte getTypeId() {
        return this.typeId;
    }

    private PacketType(byte typeId) {
        this.typeId = typeId;
        boolean bl = this.typeId <= 127;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Packet typeId must be in range [0x00, 0x80)";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ PacketType(String $enum$name, int $enum$ordinal, byte typeId, DefaultConstructorMarker $constructor_marker) {
        this(typeId);
    }

    public static PacketType[] values() {
        return (PacketType[])$VALUES.clone();
    }

    public static PacketType valueOf(String string) {
        return Enum.valueOf(PacketType.class, string);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/apache/tuweni/devp2p/PacketType$PING;", "Lorg/apache/tuweni/devp2p/PacketType;", "decode", "Lorg/apache/tuweni/devp2p/Packet;", "payload", "Lorg/apache/tuweni/bytes/Bytes;", "hash", "Lorg/apache/tuweni/bytes/Bytes32;", "publicKey", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "signature", "Lorg/apache/tuweni/crypto/SECP256K1$Signature;", "devp2p"})
    static final class PING
    extends PacketType {
        @Override
        @NotNull
        public Packet decode(@NotNull Bytes payload, @NotNull Bytes32 hash, @NotNull SECP256K1.PublicKey publicKey, @NotNull SECP256K1.Signature signature) {
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            PingPacket pingPacket = PingPacket.Companion.decode(payload, hash, publicKey, signature);
            if (pingPacket == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.apache.tuweni.devp2p.Packet");
            }
            return pingPacket;
        }

        /*
         * WARNING - void declaration
         */
        PING() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/apache/tuweni/devp2p/PacketType$PONG;", "Lorg/apache/tuweni/devp2p/PacketType;", "decode", "Lorg/apache/tuweni/devp2p/Packet;", "payload", "Lorg/apache/tuweni/bytes/Bytes;", "hash", "Lorg/apache/tuweni/bytes/Bytes32;", "publicKey", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "signature", "Lorg/apache/tuweni/crypto/SECP256K1$Signature;", "devp2p"})
    static final class PONG
    extends PacketType {
        @Override
        @NotNull
        public Packet decode(@NotNull Bytes payload, @NotNull Bytes32 hash, @NotNull SECP256K1.PublicKey publicKey, @NotNull SECP256K1.Signature signature) {
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            PongPacket pongPacket = PongPacket.Companion.decode(payload, hash, publicKey, signature);
            if (pongPacket == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.apache.tuweni.devp2p.Packet");
            }
            return pongPacket;
        }

        /*
         * WARNING - void declaration
         */
        PONG() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/apache/tuweni/devp2p/PacketType$FIND_NODE;", "Lorg/apache/tuweni/devp2p/PacketType;", "decode", "Lorg/apache/tuweni/devp2p/Packet;", "payload", "Lorg/apache/tuweni/bytes/Bytes;", "hash", "Lorg/apache/tuweni/bytes/Bytes32;", "publicKey", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "signature", "Lorg/apache/tuweni/crypto/SECP256K1$Signature;", "devp2p"})
    static final class FIND_NODE
    extends PacketType {
        @Override
        @NotNull
        public Packet decode(@NotNull Bytes payload, @NotNull Bytes32 hash, @NotNull SECP256K1.PublicKey publicKey, @NotNull SECP256K1.Signature signature) {
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            FindNodePacket findNodePacket = FindNodePacket.Companion.decode(payload, hash, publicKey, signature);
            if (findNodePacket == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.apache.tuweni.devp2p.Packet");
            }
            return findNodePacket;
        }

        /*
         * WARNING - void declaration
         */
        FIND_NODE() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/apache/tuweni/devp2p/PacketType$NEIGHBORS;", "Lorg/apache/tuweni/devp2p/PacketType;", "decode", "Lorg/apache/tuweni/devp2p/Packet;", "payload", "Lorg/apache/tuweni/bytes/Bytes;", "hash", "Lorg/apache/tuweni/bytes/Bytes32;", "publicKey", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "signature", "Lorg/apache/tuweni/crypto/SECP256K1$Signature;", "devp2p"})
    static final class NEIGHBORS
    extends PacketType {
        @Override
        @NotNull
        public Packet decode(@NotNull Bytes payload, @NotNull Bytes32 hash, @NotNull SECP256K1.PublicKey publicKey, @NotNull SECP256K1.Signature signature) {
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            NeighborsPacket neighborsPacket = NeighborsPacket.Companion.decode(payload, hash, publicKey, signature);
            if (neighborsPacket == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.apache.tuweni.devp2p.Packet");
            }
            return neighborsPacket;
        }

        /*
         * WARNING - void declaration
         */
        NEIGHBORS() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/apache/tuweni/devp2p/PacketType$ENRREQUEST;", "Lorg/apache/tuweni/devp2p/PacketType;", "decode", "Lorg/apache/tuweni/devp2p/Packet;", "payload", "Lorg/apache/tuweni/bytes/Bytes;", "hash", "Lorg/apache/tuweni/bytes/Bytes32;", "publicKey", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "signature", "Lorg/apache/tuweni/crypto/SECP256K1$Signature;", "devp2p"})
    static final class ENRREQUEST
    extends PacketType {
        @Override
        @NotNull
        public Packet decode(@NotNull Bytes payload, @NotNull Bytes32 hash, @NotNull SECP256K1.PublicKey publicKey, @NotNull SECP256K1.Signature signature) {
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            ENRRequestPacket eNRRequestPacket = ENRRequestPacket.Companion.decode(payload, hash, publicKey, signature);
            if (eNRRequestPacket == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.apache.tuweni.devp2p.Packet");
            }
            return eNRRequestPacket;
        }

        /*
         * WARNING - void declaration
         */
        ENRREQUEST() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/apache/tuweni/devp2p/PacketType$ENRRESPONSE;", "Lorg/apache/tuweni/devp2p/PacketType;", "decode", "Lorg/apache/tuweni/devp2p/Packet;", "payload", "Lorg/apache/tuweni/bytes/Bytes;", "hash", "Lorg/apache/tuweni/bytes/Bytes32;", "publicKey", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "signature", "Lorg/apache/tuweni/crypto/SECP256K1$Signature;", "devp2p"})
    static final class ENRRESPONSE
    extends PacketType {
        @Override
        @NotNull
        public Packet decode(@NotNull Bytes payload, @NotNull Bytes32 hash, @NotNull SECP256K1.PublicKey publicKey, @NotNull SECP256K1.Signature signature) {
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            ENRResponsePacket eNRResponsePacket = ENRResponsePacket.Companion.decode(payload, hash, publicKey, signature);
            if (eNRResponsePacket == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.apache.tuweni.devp2p.Packet");
            }
            return eNRResponsePacket;
        }

        /*
         * WARNING - void declaration
         */
        ENRRESPONSE() {
            void var1_1;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\bR\u0018\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/apache/tuweni/devp2p/PacketType$Companion;", "", "()V", "INDEX", "", "Lorg/apache/tuweni/devp2p/PacketType;", "[Lorg/apache/tuweni/devp2p/PacketType;", "MAX_VALUE", "", "forType", "typeId", "devp2p"})
    public static final class Companion {
        @Nullable
        public final PacketType forType(byte typeId) {
            return INDEX[typeId];
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

