/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import org.apache.tuweni.concurrent.AsyncResult;
import org.apache.tuweni.concurrent.coroutines.AsyncResultKt;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.devp2p.Endpoint;
import org.apache.tuweni.devp2p.EnodeUriComponents;
import org.apache.tuweni.devp2p.EnodeUriKt;
import org.apache.tuweni.devp2p.EthereumNodeRecord;
import org.apache.tuweni.devp2p.Peer;
import org.apache.tuweni.devp2p.PeerRepository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\u001b\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u000b\u001a\u00020\n2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0019\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J)\u0010\r\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0004H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\r\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u001a2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u001a2\u0006\u0010\u000e\u001a\u00020\u0012H\u0016R \u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001c"}, d2={"Lorg/apache/tuweni/devp2p/EphemeralPeerRepository;", "Lorg/apache/tuweni/devp2p/PeerRepository;", "peers", "", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "Lorg/apache/tuweni/devp2p/Peer;", "(Ljava/util/Map;)V", "listeners", "", "Lkotlin/Function1;", "", "addListener", "listener", "get", "uri", "Ljava/net/URI;", "(Ljava/net/URI;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "host", "", "port", "", "nodeId", "(Ljava/lang/String;ILorg/apache/tuweni/crypto/SECP256K1$PublicKey;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "endpoint", "Lorg/apache/tuweni/devp2p/Endpoint;", "getAsync", "Lorg/apache/tuweni/concurrent/AsyncResult;", "EphemeralPeer", "devp2p"})
public final class EphemeralPeerRepository
implements PeerRepository {
    private final List<Function1<Peer, Unit>> listeners;
    private final Map<SECP256K1.PublicKey, Peer> peers;

    @Override
    public void addListener(@NotNull Function1<? super Peer, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.listeners.add(listener);
    }

    @NotNull
    public final Peer get(@NotNull SECP256K1.PublicKey nodeId, @NotNull Endpoint endpoint) {
        Intrinsics.checkNotNullParameter((Object)nodeId, (String)"nodeId");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Peer peer = this.peers.compute(nodeId, new BiFunction<SECP256K1.PublicKey, Peer, Peer>(this, nodeId, endpoint){
            final /* synthetic */ EphemeralPeerRepository this$0;
            final /* synthetic */ SECP256K1.PublicKey $nodeId;
            final /* synthetic */ Endpoint $endpoint;

            @Nullable
            public final Peer apply(@NotNull SECP256K1.PublicKey $noName_0, @Nullable Peer peer) {
                Peer peer2;
                Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"<anonymous parameter 0>");
                if (peer == null) {
                    EphemeralPeer newPeer = this.this$0.new EphemeralPeer(this.$nodeId, this.$endpoint);
                    List list = EphemeralPeerRepository.access$getListeners$p(this.this$0);
                    boolean bl = false;
                    boolean bl2 = false;
                    List it = list;
                    boolean bl3 = false;
                    for (Function1 listener : EphemeralPeerRepository.access$getListeners$p(this.this$0)) {
                        listener.invoke((Object)newPeer);
                    }
                    peer2 = newPeer;
                } else {
                    peer2 = peer;
                }
                return peer2;
            }
            {
                this.this$0 = ephemeralPeerRepository;
                this.$nodeId = publicKey;
                this.$endpoint = endpoint;
            }
        });
        if (peer == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.apache.tuweni.devp2p.Peer");
        }
        return peer;
    }

    @Override
    @Nullable
    public Object get(@NotNull String host, int port, @NotNull SECP256K1.PublicKey nodeId, @NotNull Continuation<? super Peer> $completion) {
        return this.get(nodeId, new Endpoint(host, port, null, 4, null));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object get(@NotNull URI uri, @NotNull Continuation<? super Peer> $completion) {
        void nodeId;
        EnodeUriComponents enodeUriComponents = EnodeUriKt.parseEnodeUri(uri);
        SECP256K1.PublicKey publicKey = enodeUriComponents.component1();
        Endpoint endpoint = enodeUriComponents.component2();
        return this.get((SECP256K1.PublicKey)nodeId, endpoint);
    }

    @Override
    @NotNull
    public AsyncResult<Peer> getAsync(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return AsyncResultKt.asyncResult$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Peer>, Object>(this, uri, null){
            int label;
            final /* synthetic */ EphemeralPeerRepository this$0;
            final /* synthetic */ URI $uri;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.get(this.$uri, (Continuation<? super Peer>)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = ephemeralPeerRepository;
                this.$uri = uRI;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Peer>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    @NotNull
    public AsyncResult<Peer> getAsync(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return AsyncResultKt.asyncResult$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Peer>, Object>(this, uri, null){
            int label;
            final /* synthetic */ EphemeralPeerRepository this$0;
            final /* synthetic */ String $uri;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.get(this.$uri, (Continuation<? super Peer>)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = ephemeralPeerRepository;
                this.$uri = string;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Peer>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public EphemeralPeerRepository(@NotNull Map<SECP256K1.PublicKey, Peer> peers) {
        Intrinsics.checkNotNullParameter(peers, (String)"peers");
        this.peers = peers;
        boolean bl = false;
        this.listeners = new ArrayList();
    }

    public /* synthetic */ EphemeralPeerRepository(Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map2 = new ConcurrentHashMap();
        }
        this(map2);
    }

    public EphemeralPeerRepository() {
        this(null, 1, null);
    }

    @Override
    @Nullable
    public Object get(@NotNull String uri, @NotNull Continuation<? super Peer> continuation) {
        return PeerRepository.DefaultImpls.get(this, uri, continuation);
    }

    public static final /* synthetic */ List access$getListeners$p(EphemeralPeerRepository $this) {
        return $this.listeners;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001e\u001a\u00020\u0013H\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0013H\u0016J\u0018\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020\r2\u0006\u0010!\u001a\u00020\u0013H\u0016J'\u0010$\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00132\b\u0010%\u001a\u0004\u0018\u00010\u0013H\u0016\u00a2\u0006\u0002\u0010&J\u0018\u0010'\u001a\u00020(2\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0013H\u0016R\u001a\u0010\u0007\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0018\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0019\u001a\u0004\u0018\u00010\u0013X\u0096\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0018\u001a\u0004\b\u001a\u0010\u0015\"\u0004\b\u001b\u0010\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006)"}, d2={"Lorg/apache/tuweni/devp2p/EphemeralPeerRepository$EphemeralPeer;", "Lorg/apache/tuweni/devp2p/Peer;", "nodeId", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "knownEndpoint", "Lorg/apache/tuweni/devp2p/Endpoint;", "(Lorg/apache/tuweni/devp2p/EphemeralPeerRepository;Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;Lorg/apache/tuweni/devp2p/Endpoint;)V", "endpoint", "getEndpoint", "()Lorg/apache/tuweni/devp2p/Endpoint;", "setEndpoint", "(Lorg/apache/tuweni/devp2p/Endpoint;)V", "enr", "Lorg/apache/tuweni/devp2p/EthereumNodeRecord;", "getEnr", "()Lorg/apache/tuweni/devp2p/EthereumNodeRecord;", "setEnr", "(Lorg/apache/tuweni/devp2p/EthereumNodeRecord;)V", "lastSeen", "", "getLastSeen", "()Ljava/lang/Long;", "setLastSeen", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "lastVerified", "getLastVerified", "setLastVerified", "getNodeId", "()Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "ifVerifiedOnOrAfter", "seenAt", "", "time", "updateENR", "record", "updateEndpoint", "ifVerifiedBefore", "(Lorg/apache/tuweni/devp2p/Endpoint;JLjava/lang/Long;)Lorg/apache/tuweni/devp2p/Endpoint;", "verifyEndpoint", "", "devp2p"})
    private final class EphemeralPeer
    implements Peer {
        @NotNull
        private volatile Endpoint endpoint;
        @Nullable
        private EthereumNodeRecord enr;
        @Nullable
        private volatile Long lastVerified;
        @Nullable
        private volatile Long lastSeen;
        @NotNull
        private final SECP256K1.PublicKey nodeId;

        @Override
        @NotNull
        public Endpoint getEndpoint() {
            return this.endpoint;
        }

        public void setEndpoint(@NotNull Endpoint endpoint) {
            Intrinsics.checkNotNullParameter((Object)endpoint, (String)"<set-?>");
            this.endpoint = endpoint;
        }

        @Override
        @Nullable
        public EthereumNodeRecord getEnr() {
            return this.enr;
        }

        public void setEnr(@Nullable EthereumNodeRecord ethereumNodeRecord) {
            this.enr = ethereumNodeRecord;
        }

        @Override
        @Nullable
        public synchronized Endpoint getEndpoint(long ifVerifiedOnOrAfter) {
            Long l = this.getLastVerified();
            if ((l != null ? l : 0L) >= ifVerifiedOnOrAfter) {
                return this.getEndpoint();
            }
            return null;
        }

        @Override
        @Nullable
        public Long getLastVerified() {
            return this.lastVerified;
        }

        public void setLastVerified(@Nullable Long l) {
            this.lastVerified = l;
        }

        @Override
        @Nullable
        public Long getLastSeen() {
            return this.lastSeen;
        }

        public void setLastSeen(@Nullable Long l) {
            this.lastSeen = l;
        }

        @Override
        @NotNull
        public synchronized Endpoint updateEndpoint(@NotNull Endpoint endpoint, long time, @Nullable Long ifVerifiedBefore) {
            Endpoint currentEndpoint;
            block6: {
                block5: {
                    Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
                    currentEndpoint = this.getEndpoint();
                    if (Intrinsics.areEqual((Object)currentEndpoint, (Object)endpoint)) {
                        this.seenAt(time);
                        return currentEndpoint;
                    }
                    if (ifVerifiedBefore == null) break block5;
                    Long l = this.getLastVerified();
                    if ((l != null ? l : 0L) >= ifVerifiedBefore) break block6;
                }
                if (Intrinsics.areEqual((Object)currentEndpoint.getAddress(), (Object)endpoint.getAddress()) ^ true || currentEndpoint.getUdpPort() != endpoint.getUdpPort()) {
                    this.setLastVerified(null);
                }
                this.setEndpoint(endpoint);
                this.seenAt(time);
                return endpoint;
            }
            return currentEndpoint;
        }

        @Override
        public synchronized boolean verifyEndpoint(@NotNull Endpoint endpoint, long time) {
            Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
            if (Intrinsics.areEqual((Object)endpoint, (Object)this.getEndpoint()) ^ true) {
                return false;
            }
            this.seenAt(time);
            Long l = this.getLastVerified();
            if ((l != null ? l : 0L) < time) {
                this.setLastVerified(time);
            }
            return true;
        }

        @Override
        public synchronized void seenAt(long time) {
            Long l = this.getLastSeen();
            if ((l != null ? l : 0L) < time) {
                this.setLastSeen(time);
            }
        }

        @Override
        public synchronized void updateENR(@NotNull EthereumNodeRecord record, long time) {
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)record, (String)"record");
                    if (this.getEnr() == null) break block2;
                    EthereumNodeRecord ethereumNodeRecord = this.getEnr();
                    Intrinsics.checkNotNull((Object)ethereumNodeRecord);
                    if (ethereumNodeRecord.seq() >= record.seq()) break block3;
                }
                this.setEnr(record);
                String string = record.ip().getHostAddress();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"record.ip().hostAddress");
                Integer n = record.udp();
                Intrinsics.checkNotNull((Object)n);
                Peer.DefaultImpls.updateEndpoint$default(this, new Endpoint(string, n, record.tcp()), time, null, 4, null);
            }
        }

        @Override
        @NotNull
        public SECP256K1.PublicKey getNodeId() {
            return this.nodeId;
        }

        public EphemeralPeer(@NotNull SECP256K1.PublicKey nodeId, Endpoint knownEndpoint) {
            Intrinsics.checkNotNullParameter((Object)nodeId, (String)"nodeId");
            Intrinsics.checkNotNullParameter((Object)knownEndpoint, (String)"knownEndpoint");
            this.nodeId = nodeId;
            this.endpoint = knownEndpoint;
        }

        @Override
        @NotNull
        public String uri() {
            return Peer.DefaultImpls.uri(this);
        }
    }
}

