/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p;

import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.devp2p.DecodingException;
import org.apache.tuweni.devp2p.Packet;
import org.apache.tuweni.devp2p.PacketKt;
import org.apache.tuweni.devp2p.PacketType;
import org.apache.tuweni.devp2p.SigHash;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.rlp.RLPException;
import org.apache.tuweni.rlp.RLPReader;
import org.apache.tuweni.rlp.RLPWriter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B7\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0011\u001a\u00020\u000bH\u0016R\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lorg/apache/tuweni/devp2p/ENRResponsePacket;", "Lorg/apache/tuweni/devp2p/Packet;", "nodeId", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "signature", "Lorg/apache/tuweni/crypto/SECP256K1$Signature;", "hash", "Lorg/apache/tuweni/bytes/Bytes32;", "expiration", "", "requestHash", "Lorg/apache/tuweni/bytes/Bytes;", "enr", "(Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;Lorg/apache/tuweni/crypto/SECP256K1$Signature;Lorg/apache/tuweni/bytes/Bytes32;JLorg/apache/tuweni/bytes/Bytes;Lorg/apache/tuweni/bytes/Bytes;)V", "getEnr", "()Lorg/apache/tuweni/bytes/Bytes;", "getRequestHash", "encode", "Companion", "devp2p"})
public final class ENRResponsePacket
extends Packet {
    @NotNull
    private final Bytes requestHash;
    @NotNull
    private final Bytes enr;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public Bytes encode() {
        return this.encodeTo(PacketType.ENRRESPONSE, (Function1<? super RLPWriter, Unit>)((Function1)new Function1<RLPWriter, Unit>(this){
            final /* synthetic */ ENRResponsePacket this$0;

            public final void invoke(@NotNull RLPWriter writer) {
                Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                org.apache.tuweni.devp2p.ENRResponsePacket$Companion.access$encodeTo(ENRResponsePacket.Companion, writer, this.this$0.getRequestHash(), this.this$0.getEnr(), this.this$0.getExpiration());
            }
            {
                this.this$0 = eNRResponsePacket;
                super(1);
            }
        }));
    }

    @NotNull
    public final Bytes getRequestHash() {
        return this.requestHash;
    }

    @NotNull
    public final Bytes getEnr() {
        return this.enr;
    }

    private ENRResponsePacket(SECP256K1.PublicKey nodeId, SECP256K1.Signature signature, Bytes32 hash, long expiration, Bytes requestHash, Bytes enr2) {
        super(nodeId, signature, hash, expiration, null);
        this.requestHash = requestHash;
        this.enr = enr2;
    }

    public /* synthetic */ ENRResponsePacket(SECP256K1.PublicKey nodeId, SECP256K1.Signature signature, Bytes32 hash, long expiration, Bytes requestHash, Bytes enr2, DefaultConstructorMarker $constructor_marker) {
        this(nodeId, signature, hash, expiration, requestHash, enr2);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ&\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\bH\u0002\u00a8\u0006\u0019"}, d2={"Lorg/apache/tuweni/devp2p/ENRResponsePacket$Companion;", "", "()V", "create", "Lorg/apache/tuweni/devp2p/ENRResponsePacket;", "keyPair", "Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;", "now", "", "requestHash", "Lorg/apache/tuweni/bytes/Bytes;", "enr", "decode", "payload", "hash", "Lorg/apache/tuweni/bytes/Bytes32;", "publicKey", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "signature", "Lorg/apache/tuweni/crypto/SECP256K1$Signature;", "encodeTo", "", "writer", "Lorg/apache/tuweni/rlp/RLPWriter;", "expiration", "devp2p"})
    public static final class Companion {
        @NotNull
        public final ENRResponsePacket create(@NotNull SECP256K1.KeyPair keyPair, long now, @NotNull Bytes requestHash, @NotNull Bytes enr2) {
            Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
            Intrinsics.checkNotNullParameter((Object)requestHash, (String)"requestHash");
            Intrinsics.checkNotNullParameter((Object)enr2, (String)"enr");
            long expiration = Packet.Companion.expirationFor(now);
            SigHash sigHash2 = Packet.Companion.createSignature(PacketType.ENRRESPONSE, keyPair, (Function1<? super RLPWriter, Unit>)((Function1)new Function1<RLPWriter, Unit>(requestHash, enr2, expiration){
                final /* synthetic */ Bytes $requestHash;
                final /* synthetic */ Bytes $enr;
                final /* synthetic */ long $expiration;

                public final void invoke(@NotNull RLPWriter writer) {
                    Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                    org.apache.tuweni.devp2p.ENRResponsePacket$Companion.access$encodeTo(ENRResponsePacket.Companion, writer, this.$requestHash, this.$enr, this.$expiration);
                }
                {
                    this.$requestHash = bytes;
                    this.$enr = bytes2;
                    this.$expiration = l;
                    super(1);
                }
            }));
            SECP256K1.PublicKey publicKey = keyPair.publicKey();
            Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"keyPair.publicKey()");
            return new ENRResponsePacket(publicKey, sigHash2.getSignature(), sigHash2.getHash(), expiration, requestHash, enr2, null);
        }

        @NotNull
        public final ENRResponsePacket decode(@NotNull Bytes payload, @NotNull Bytes32 hash, @NotNull SECP256K1.PublicKey publicKey, @NotNull SECP256K1.Signature signature) {
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            try {
                Object object = RLP.decodeList((Bytes)payload, (Function)new Function<RLPReader, ENRResponsePacket>(publicKey, signature, hash){
                    final /* synthetic */ SECP256K1.PublicKey $publicKey;
                    final /* synthetic */ SECP256K1.Signature $signature;
                    final /* synthetic */ Bytes32 $hash;

                    public final ENRResponsePacket apply(RLPReader reader) {
                        Bytes requestHash = reader.readValue();
                        Bytes enr2 = reader.readValue();
                        long expiration = reader.readLong();
                        long l = PacketKt.access$secToMsec(expiration);
                        Bytes bytes = requestHash;
                        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"requestHash");
                        Bytes bytes2 = enr2;
                        Intrinsics.checkNotNullExpressionValue((Object)bytes2, (String)"enr");
                        return new ENRResponsePacket(this.$publicKey, this.$signature, this.$hash, l, bytes, bytes2, null);
                    }
                    {
                        this.$publicKey = publicKey;
                        this.$signature = signature;
                        this.$hash = bytes32;
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"RLP.decodeList(payload) \u2026questHash, enr)\n        }");
                return (ENRResponsePacket)object;
            }
            catch (RLPException e) {
                throw (Throwable)new DecodingException("Invalid enr response packet", e);
            }
        }

        private final void encodeTo(RLPWriter writer, Bytes requestHash, Bytes enr2, long expiration) {
            writer.writeValue(requestHash);
            writer.writeValue(enr2);
            writer.writeLong(PacketKt.access$msecToSec(expiration));
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$encodeTo(Companion $this, RLPWriter writer, Bytes requestHash, Bytes enr2, long expiration) {
            $this.encodeTo(writer, requestHash, enr2, expiration);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

