/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.jsonrpc.methods;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.eth.JSONRPCRequest;
import org.apache.tuweni.eth.JSONRPCResponse;
import org.apache.tuweni.eth.JSONRPCResponseKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B%\u0012\u001e\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0003\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0006R)\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lorg/apache/tuweni/jsonrpc/methods/MethodsRouter;", "", "methodsMap", "", "", "Lkotlin/Function1;", "Lorg/apache/tuweni/eth/JSONRPCRequest;", "Lorg/apache/tuweni/eth/JSONRPCResponse;", "(Ljava/util/Map;)V", "getMethodsMap", "()Ljava/util/Map;", "handleRequest", "request", "jsonrpc"})
public final class MethodsRouter {
    @NotNull
    private final Map<String, Function1<JSONRPCRequest, JSONRPCResponse>> methodsMap;

    @NotNull
    public final JSONRPCResponse handleRequest(@NotNull JSONRPCRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Function1<JSONRPCRequest, JSONRPCResponse> methodHandler = this.methodsMap.get(request.getMethod());
        if (methodHandler == null) {
            return JSONRPCResponseKt.getMethodNotFound();
        }
        return (JSONRPCResponse)methodHandler.invoke((Object)request);
    }

    @NotNull
    public final Map<String, Function1<JSONRPCRequest, JSONRPCResponse>> getMethodsMap() {
        return this.methodsMap;
    }

    public MethodsRouter(@NotNull Map<String, ? extends Function1<? super JSONRPCRequest, JSONRPCResponse>> methodsMap) {
        Intrinsics.checkNotNullParameter(methodsMap, (String)"methodsMap");
        this.methodsMap = methodsMap;
    }
}

