/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.scuttlebutt;

import com.google.common.base.Splitter;
import java.util.List;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.crypto.sodium.Signature;
import org.apache.tuweni.scuttlebutt.Ed25519PublicKeyIdentity;
import org.apache.tuweni.scuttlebutt.Identity;
import org.apache.tuweni.scuttlebutt.MalformedInviteCodeException;

public final class Invite {
    private final String host;
    private final int port;
    private final Identity identity;
    private final Signature.Seed seedKey;

    public Invite(String host, int port, Identity identity, Signature.Seed seedKey) {
        if (port <= 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port");
        }
        this.host = host;
        this.port = port;
        this.identity = identity;
        this.seedKey = seedKey;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public Identity identity() {
        return this.identity;
    }

    public Signature.Seed seedKey() {
        return this.seedKey;
    }

    public String toCanonicalForm() {
        return this.host + ":" + this.port + ":@" + this.identity.publicKeyAsBase64String() + "." + this.identity.curveName() + "~" + this.seedKey.bytes().toBase64String();
    }

    public static Invite fromCanonicalForm(String inviteCode) {
        String exceptionMessage = "Invite code should be of format host:port:publicKey.curveName~secretKey";
        List parts = Splitter.on((char)':').splitToList((CharSequence)inviteCode);
        if (parts.size() != 3) {
            throw new MalformedInviteCodeException(exceptionMessage);
        }
        String host = (String)parts.get(0);
        String portString = (String)parts.get(1);
        int port = Invite.toPort(portString);
        List keyAndSecret = Splitter.on((char)'~').splitToList((CharSequence)parts.get(2));
        if (keyAndSecret.size() != 2) {
            throw new MalformedInviteCodeException(exceptionMessage);
        }
        String fullKey = (String)keyAndSecret.get(0);
        List splitKey = Splitter.on((char)'.').splitToList((CharSequence)fullKey);
        if (splitKey.size() != 2) {
            throw new MalformedInviteCodeException(exceptionMessage);
        }
        String keyPart = (String)splitKey.get(0);
        String secretKeyPart = (String)keyAndSecret.get(1);
        Signature.Seed secretKey = Invite.toSecretKey(secretKeyPart);
        Ed25519PublicKeyIdentity identity = Invite.toPublicKey(keyPart);
        return new Invite(host, port, identity, secretKey);
    }

    private static Signature.Seed toSecretKey(String secretKeyPart) {
        Bytes secret = Bytes.fromBase64String((CharSequence)secretKeyPart);
        return Signature.Seed.fromBytes((Bytes)secret);
    }

    private static Ed25519PublicKeyIdentity toPublicKey(String keyPart) {
        String keyPartSuffix = keyPart.substring(1);
        Bytes publicKeyBytes = Bytes.fromBase64String((CharSequence)keyPartSuffix);
        Signature.PublicKey publicKey = Signature.PublicKey.fromBytes((Bytes)publicKeyBytes);
        return new Ed25519PublicKeyIdentity(publicKey);
    }

    private static int toPort(String portString) throws MalformedInviteCodeException {
        try {
            return Integer.parseInt(portString);
        }
        catch (NumberFormatException ex) {
            throw new MalformedInviteCodeException("Expected a string for the port. Value parsed: " + portString);
        }
    }

    public String toString() {
        return this.toCanonicalForm();
    }
}

