/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.peer.repository.memory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.peer.repository.Connection;
import org.apache.tuweni.peer.repository.Identity;
import org.apache.tuweni.peer.repository.Peer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0080\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\t\u0010\u0011\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c2\u0003J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0016J'\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00d6\u0001J\b\u0010\u001a\u001a\u00020\u0003H\u0016J\b\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/apache/tuweni/peer/repository/memory/MemoryIdentity;", "Lorg/apache/tuweni/peer/repository/Identity;", "networkInterface", "", "port", "", "publicKey", "Lorg/apache/tuweni/crypto/SECP256K1$PublicKey;", "(Ljava/lang/String;ILorg/apache/tuweni/crypto/SECP256K1$PublicKey;)V", "connections", "", "Lorg/apache/tuweni/peer/repository/Connection;", "getConnections$peer_repository", "()Ljava/util/List;", "activePeers", "", "Lorg/apache/tuweni/peer/repository/Peer;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "id", "toString", "peer-repository"})
public final class MemoryIdentity
implements Identity {
    @NotNull
    private final List<Connection> connections;
    private final String networkInterface;
    private final int port;
    private final SECP256K1.PublicKey publicKey;

    @NotNull
    public final List<Connection> getConnections$peer_repository() {
        return this.connections;
    }

    @Override
    @NotNull
    public String networkInterface() {
        return this.networkInterface;
    }

    @Override
    public int port() {
        return this.port;
    }

    @Override
    @NotNull
    public SECP256K1.PublicKey publicKey() {
        return this.publicKey;
    }

    @Override
    @NotNull
    public String id() {
        return this.publicKey.toHexString() + "@" + this.networkInterface + ":" + this.port;
    }

    @Override
    @NotNull
    public List<Connection> connections() {
        return this.connections;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Peer> activePeers() {
        void $this$mapTo$iv$iv;
        Connection it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.connections;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Connection)element$iv$iv;
            boolean bl = false;
            if (!it.active()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Connection)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Peer peer = it.peer();
            collection.add(peer);
        }
        return (List)destination$iv$iv;
    }

    public MemoryIdentity(@NotNull String networkInterface, int port, @NotNull SECP256K1.PublicKey publicKey) {
        Intrinsics.checkNotNullParameter((Object)networkInterface, (String)"networkInterface");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        this.networkInterface = networkInterface;
        this.port = port;
        this.publicKey = publicKey;
        boolean bl = false;
        this.connections = new ArrayList();
    }

    private final String component1() {
        return this.networkInterface;
    }

    private final int component2() {
        return this.port;
    }

    private final SECP256K1.PublicKey component3() {
        return this.publicKey;
    }

    @NotNull
    public final MemoryIdentity copy(@NotNull String networkInterface, int port, @NotNull SECP256K1.PublicKey publicKey) {
        Intrinsics.checkNotNullParameter((Object)networkInterface, (String)"networkInterface");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        return new MemoryIdentity(networkInterface, port, publicKey);
    }

    public static /* synthetic */ MemoryIdentity copy$default(MemoryIdentity memoryIdentity, String string, int n, SECP256K1.PublicKey publicKey, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = memoryIdentity.networkInterface;
        }
        if ((n2 & 2) != 0) {
            n = memoryIdentity.port;
        }
        if ((n2 & 4) != 0) {
            publicKey = memoryIdentity.publicKey;
        }
        return memoryIdentity.copy(string, n, publicKey);
    }

    @NotNull
    public String toString() {
        return "MemoryIdentity(networkInterface=" + this.networkInterface + ", port=" + this.port + ", publicKey=" + this.publicKey + ")";
    }

    public int hashCode() {
        String string = this.networkInterface;
        SECP256K1.PublicKey publicKey = this.publicKey;
        return ((string != null ? string.hashCode() : 0) * 31 + Integer.hashCode(this.port)) * 31 + (publicKey != null ? publicKey.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof MemoryIdentity)) break block3;
                MemoryIdentity memoryIdentity = (MemoryIdentity)object;
                if (!Intrinsics.areEqual((Object)this.networkInterface, (Object)memoryIdentity.networkInterface) || this.port != memoryIdentity.port || !Intrinsics.areEqual((Object)this.publicKey, (Object)memoryIdentity.publicKey)) break block3;
            }
            return true;
        }
        return false;
    }
}

