/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.scuttlebutt.handshake;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.MutableBytes;
import org.apache.tuweni.crypto.sodium.SHA256Hash;
import org.apache.tuweni.crypto.sodium.SecretBox;
import org.apache.tuweni.scuttlebutt.handshake.SecureScuttlebuttStreamClient;
import org.apache.tuweni.scuttlebutt.handshake.SecureScuttlebuttStreamServer;
import org.apache.tuweni.scuttlebutt.handshake.StreamException;

final class SecureScuttlebuttStream
implements SecureScuttlebuttStreamClient,
SecureScuttlebuttStreamServer {
    private final SecretBox.Key clientToServerKey;
    private final MutableBytes clientToServerNonce;
    private final SecretBox.Key serverToClientKey;
    private final MutableBytes serverToClientNonce;
    private Bytes clientToServerBuffer = Bytes.EMPTY;
    private Bytes serverToClientBuffer = Bytes.EMPTY;

    SecureScuttlebuttStream(SHA256Hash.Hash clientToServerKey, Bytes clientToServerNonce, SHA256Hash.Hash serverToClientKey, Bytes serverToClientNonce) {
        this.clientToServerKey = SecretBox.Key.fromHash((SHA256Hash.Hash)clientToServerKey);
        this.serverToClientKey = SecretBox.Key.fromHash((SHA256Hash.Hash)serverToClientKey);
        this.clientToServerNonce = clientToServerNonce.mutableCopy();
        this.serverToClientNonce = serverToClientNonce.mutableCopy();
    }

    @Override
    public synchronized Bytes sendToServer(Bytes message) {
        return this.encrypt(message, this.clientToServerKey, this.clientToServerNonce);
    }

    @Override
    public synchronized Bytes sendGoodbyeToServer() {
        return this.sendToServer(Bytes.wrap((byte[])new byte[18]));
    }

    @Override
    public synchronized Bytes readFromServer(Bytes message) {
        return this.decrypt(message, this.serverToClientKey, this.serverToClientNonce, false);
    }

    @Override
    public synchronized Bytes sendToClient(Bytes message) {
        return this.encrypt(message, this.serverToClientKey, this.serverToClientNonce);
    }

    @Override
    public synchronized Bytes sendGoodbyeToClient() {
        return this.sendToClient(Bytes.wrap((byte[])new byte[18]));
    }

    @Override
    public synchronized Bytes readFromClient(Bytes message) {
        return this.decrypt(message, this.clientToServerKey, this.clientToServerNonce, true);
    }

    private Bytes decrypt(Bytes message, SecretBox.Key key, MutableBytes nonce, boolean isClientToServer) {
        int index;
        Bytes decryptedMessage;
        ArrayList<Bytes> decryptedMessages = new ArrayList<Bytes>();
        Bytes messageWithBuffer = isClientToServer ? Bytes.concatenate((Bytes[])new Bytes[]{this.clientToServerBuffer, message}) : Bytes.concatenate((Bytes[])new Bytes[]{this.serverToClientBuffer, message});
        for (index = 0; index < messageWithBuffer.size() && (decryptedMessage = this.decryptMessage(messageWithBuffer.slice(index), key, nonce)) != null; index += decryptedMessage.size() + 34) {
            decryptedMessages.add(decryptedMessage);
        }
        if (isClientToServer) {
            this.clientToServerBuffer = messageWithBuffer.slice(index);
        } else {
            this.serverToClientBuffer = messageWithBuffer.slice(index);
        }
        return Bytes.concatenate((Bytes[])decryptedMessages.toArray(new Bytes[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bytes decryptMessage(Bytes message, SecretBox.Key key, MutableBytes nonce) {
        int bodySize;
        Bytes decryptedHeader;
        SecretBox.Nonce bodyNonce;
        SecretBox.Nonce headerNonce;
        block6: {
            if (message.size() < 34) {
                return null;
            }
            headerNonce = null;
            bodyNonce = null;
            try {
                MutableBytes snapshotNonce = nonce.mutableCopy();
                headerNonce = SecretBox.Nonce.fromBytes((Bytes)snapshotNonce);
                bodyNonce = SecretBox.Nonce.fromBytes((Bytes)snapshotNonce.increment());
                decryptedHeader = SecretBox.decrypt((Bytes)message.slice(0, 34), (SecretBox.Key)key, (SecretBox.Nonce)headerNonce);
                if (decryptedHeader == null) {
                    throw new StreamException("Failed to decrypt message header");
                }
                bodySize = ((decryptedHeader.get(0) & 0xFF) << 8) + (decryptedHeader.get(1) & 0xFF);
                if (message.size() >= bodySize + 34) break block6;
                Bytes bytes = null;
                this.destroyIfNonNull(headerNonce);
                this.destroyIfNonNull(bodyNonce);
                return bytes;
            }
            catch (Throwable throwable) {
                this.destroyIfNonNull(headerNonce);
                this.destroyIfNonNull(bodyNonce);
                throw throwable;
            }
        }
        Bytes body = message.slice(34, bodySize);
        Bytes decryptedBody = SecretBox.decrypt((Bytes)Bytes.concatenate((Bytes[])new Bytes[]{decryptedHeader.slice(2), body}), (SecretBox.Key)key, (SecretBox.Nonce)bodyNonce);
        if (decryptedBody == null) {
            throw new StreamException("Failed to decrypt message");
        }
        nonce.increment().increment();
        Bytes bytes = decryptedBody;
        this.destroyIfNonNull(headerNonce);
        this.destroyIfNonNull(bodyNonce);
        return bytes;
    }

    private Bytes encrypt(Bytes message, SecretBox.Key clientToServerKey, MutableBytes clientToServerNonce) {
        ArrayList<Bytes> bytes = this.breakIntoParts(message);
        List<Bytes> segments = bytes.stream().map(slice -> this.encryptMessage((Bytes)slice, clientToServerKey, clientToServerNonce)).collect(Collectors.toList());
        return Bytes.concatenate((Bytes[])segments.toArray(new Bytes[0]));
    }

    private ArrayList<Bytes> breakIntoParts(Bytes message) {
        byte[] original = message.toArray();
        int chunk = 4096;
        ArrayList<Bytes> result = new ArrayList<Bytes>();
        for (int i = 0; i < original.length; i += chunk) {
            byte[] bytes = Arrays.copyOfRange(original, i, Math.min(original.length, i + chunk));
            Bytes wrap = Bytes.wrap((byte[])bytes);
            result.add(wrap);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bytes encryptMessage(Bytes message, SecretBox.Key key, MutableBytes nonce) {
        SecretBox.Nonce headerNonce = null;
        SecretBox.Nonce bodyNonce = null;
        try {
            headerNonce = SecretBox.Nonce.fromBytes((Bytes)nonce);
            bodyNonce = SecretBox.Nonce.fromBytes((Bytes)nonce.increment());
            nonce.increment();
            Bytes encryptedBody = SecretBox.encrypt((Bytes)message, (SecretBox.Key)key, (SecretBox.Nonce)bodyNonce);
            int bodySize = encryptedBody.size() - 16;
            Bytes encodedBodySize = Bytes.ofUnsignedInt((long)bodySize).slice(2);
            Bytes header = SecretBox.encrypt((Bytes)Bytes.concatenate((Bytes[])new Bytes[]{encodedBodySize, encryptedBody.slice(0, 16)}), (SecretBox.Key)key, (SecretBox.Nonce)headerNonce);
            Bytes bytes = Bytes.concatenate((Bytes[])new Bytes[]{header, encryptedBody.slice(16)});
            return bytes;
        }
        finally {
            this.destroyIfNonNull(headerNonce);
            this.destroyIfNonNull(bodyNonce);
        }
    }

    private void destroyIfNonNull(SecretBox.Nonce nonce) {
        if (nonce != null) {
            nonce.destroy();
        }
    }
}

