/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.units.bigints;

import java.math.BigInteger;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.units.bigints.UInt64;

public interface UInt64Value<T extends UInt64Value<T>>
extends Comparable<T> {
    default public boolean isZero() {
        return this.toBytes().isZero();
    }

    public T add(T var1);

    default public T addExact(T value) {
        T result = this.add(value);
        if (this.compareTo(result) > 0) {
            throw new ArithmeticException("UInt64 overflow");
        }
        return result;
    }

    public T add(long var1);

    default public T addExact(long value) {
        T result = this.add(value);
        if (value > 0L && this.compareTo(result) > 0 || value < 0L && this.compareTo(result) < 0) {
            throw new ArithmeticException("UInt64 overflow");
        }
        return result;
    }

    public T addMod(T var1, UInt64 var2);

    public T addMod(long var1, UInt64 var3);

    public T addMod(long var1, long var3);

    public T subtract(T var1);

    default public T subtractExact(T value) {
        T result = this.subtract(value);
        if (this.compareTo(result) < 0) {
            throw new ArithmeticException("UInt64 overflow");
        }
        return result;
    }

    public T subtract(long var1);

    default public T subtractExact(long value) {
        T result = this.subtract(value);
        if (value > 0L && this.compareTo(result) < 0 || value < 0L && this.compareTo(result) > 0) {
            throw new ArithmeticException("UInt64 overflow");
        }
        return result;
    }

    public T multiply(T var1);

    public T multiply(long var1);

    public T multiplyMod(T var1, UInt64 var2);

    public T multiplyMod(long var1, UInt64 var3);

    public T multiplyMod(long var1, long var3);

    public T divide(T var1);

    public T divide(long var1);

    public T pow(UInt64 var1);

    public T pow(long var1);

    public T mod(UInt64 var1);

    public T mod(long var1);

    default public boolean fitsInt() {
        Bytes bytes = this.toBytes();
        for (int i = 0; i < 4; ++i) {
            if (bytes.get(i) == 0) continue;
            return false;
        }
        return bytes.get(4) >= 0;
    }

    default public int intValue() {
        if (!this.fitsInt()) {
            throw new ArithmeticException("Value does not fit a 4 byte int");
        }
        return this.toBytes().getInt(4);
    }

    default public boolean fitsLong() {
        return true;
    }

    default public long toLong() {
        if (!this.fitsLong()) {
            throw new ArithmeticException("Value does not fit a 8 byte long");
        }
        return this.toBytes().getLong(0);
    }

    default public BigInteger toBigInteger() {
        return this.toBytes().toUnsignedBigInteger();
    }

    default public String toHexString() {
        return this.toBytes().toHexString();
    }

    default public String toShortHexString() {
        return this.toBytes().toShortHexString();
    }

    public UInt64 toUInt64();

    public Bytes toBytes();

    public Bytes toMinimalBytes();

    default public int numberOfLeadingZeros() {
        return this.toBytes().numberOfLeadingZeros();
    }

    default public int bitLength() {
        return this.toBytes().bitLength();
    }

    default public String toDecimalString() {
        return this.toBigInteger().toString(10);
    }
}

