/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.units.bigints;

import java.math.BigInteger;
import java.util.Objects;
import java.util.function.Function;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes48;
import org.apache.tuweni.units.bigints.UInt384;
import org.apache.tuweni.units.bigints.UInt384Value;

public abstract class BaseUInt384Value<T extends UInt384Value<T>>
implements UInt384Value<T> {
    private final UInt384 value;
    private final Function<UInt384, T> ctor;

    protected BaseUInt384Value(UInt384 value, Function<UInt384, T> ctor) {
        Objects.requireNonNull(value);
        Objects.requireNonNull(ctor);
        this.value = value;
        this.ctor = ctor;
    }

    protected BaseUInt384Value(long value, Function<UInt384, T> ctor) {
        Objects.requireNonNull(ctor);
        this.value = UInt384.valueOf(value);
        this.ctor = ctor;
    }

    protected BaseUInt384Value(BigInteger value, Function<UInt384, T> ctor) {
        Objects.requireNonNull(value);
        Objects.requireNonNull(ctor);
        this.value = UInt384.valueOf(value);
        this.ctor = ctor;
    }

    protected T copy() {
        return (T)((UInt384Value)this.ctor.apply(this.value));
    }

    protected T zero() {
        return (T)((UInt384Value)this.ctor.apply(UInt384.ZERO));
    }

    @Override
    public T add(T value) {
        return this.add(value.toUInt384());
    }

    @Override
    public T add(UInt384 value) {
        if (value.isZero()) {
            return this.copy();
        }
        return (T)((UInt384Value)this.ctor.apply(this.value.add(value)));
    }

    @Override
    public T add(long value) {
        if (value == 0L) {
            return this.copy();
        }
        return (T)((UInt384Value)this.ctor.apply(this.value.add(value)));
    }

    @Override
    public T addMod(T value, UInt384 modulus) {
        return this.addMod(value.toUInt384(), modulus);
    }

    @Override
    public T addMod(UInt384 value, UInt384 modulus) {
        return (T)((UInt384Value)this.ctor.apply(this.value.addMod(value, modulus)));
    }

    @Override
    public T addMod(long value, UInt384 modulus) {
        return (T)((UInt384Value)this.ctor.apply(this.value.addMod(value, modulus)));
    }

    @Override
    public T addMod(long value, long modulus) {
        return (T)((UInt384Value)this.ctor.apply(this.value.addMod(value, modulus)));
    }

    @Override
    public T subtract(T value) {
        return this.subtract(value.toUInt384());
    }

    @Override
    public T subtract(UInt384 value) {
        if (value.isZero()) {
            return this.copy();
        }
        return (T)((UInt384Value)this.ctor.apply(this.value.subtract(value)));
    }

    @Override
    public T subtract(long value) {
        if (value == 0L) {
            return this.copy();
        }
        return (T)((UInt384Value)this.ctor.apply(this.value.subtract(value)));
    }

    @Override
    public T multiply(T value) {
        return this.multiply(value.toUInt384());
    }

    @Override
    public T multiply(UInt384 value) {
        if (this.isZero() || value.isZero()) {
            return this.zero();
        }
        if (value.equals(UInt384.ONE)) {
            return this.copy();
        }
        return (T)((UInt384Value)this.ctor.apply(this.value.multiply(value)));
    }

    @Override
    public T multiply(long value) {
        if (value == 0L || this.isZero()) {
            return this.zero();
        }
        if (value == 1L) {
            return this.copy();
        }
        return (T)((UInt384Value)this.ctor.apply(this.value.multiply(value)));
    }

    @Override
    public T multiplyMod(T value, UInt384 modulus) {
        return this.multiplyMod(value.toUInt384(), modulus);
    }

    @Override
    public T multiplyMod(UInt384 value, UInt384 modulus) {
        return (T)((UInt384Value)this.ctor.apply(this.value.multiplyMod(value, modulus)));
    }

    @Override
    public T multiplyMod(long value, UInt384 modulus) {
        return (T)((UInt384Value)this.ctor.apply(this.value.multiplyMod(value, modulus)));
    }

    @Override
    public T multiplyMod(long value, long modulus) {
        return (T)((UInt384Value)this.ctor.apply(this.value.multiplyMod(value, modulus)));
    }

    @Override
    public T divide(T value) {
        return this.divide(value.toUInt384());
    }

    @Override
    public T divide(UInt384 value) {
        return (T)((UInt384Value)this.ctor.apply(this.value.divide(value)));
    }

    @Override
    public T divide(long value) {
        return (T)((UInt384Value)this.ctor.apply(this.value.divide(value)));
    }

    @Override
    public T pow(UInt384 exponent) {
        return (T)((UInt384Value)this.ctor.apply(this.value.pow(exponent)));
    }

    @Override
    public T pow(long exponent) {
        return (T)((UInt384Value)this.ctor.apply(this.value.pow(exponent)));
    }

    @Override
    public T mod(UInt384 modulus) {
        return (T)((UInt384Value)this.ctor.apply(this.value.mod(modulus)));
    }

    @Override
    public T mod(long modulus) {
        return (T)((UInt384Value)this.ctor.apply(this.value.mod(modulus)));
    }

    @Override
    public int compareTo(T other) {
        return this.compareTo(other.toUInt384());
    }

    @Override
    public int compareTo(UInt384 other) {
        return this.value.compareTo(other);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UInt384Value)) {
            return false;
        }
        UInt384Value other = (UInt384Value)obj;
        return this.value.equals(other.toUInt384());
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public UInt384 toUInt384() {
        return this.value;
    }

    @Override
    public Bytes48 toBytes() {
        return this.value.toBytes();
    }

    @Override
    public Bytes toMinimalBytes() {
        return this.value.toMinimalBytes();
    }
}

