/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p.eth;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Dispatchers;
import org.apache.tuweni.devp2p.eth.BlockchainInformation;
import org.apache.tuweni.devp2p.eth.EthHelloClient;
import org.apache.tuweni.devp2p.eth.EthHelloController;
import org.apache.tuweni.devp2p.eth.EthHelloHandler;
import org.apache.tuweni.devp2p.eth.Status;
import org.apache.tuweni.rlpx.RLPxService;
import org.apache.tuweni.rlpx.wire.SubProtocol;
import org.apache.tuweni.rlpx.wire.SubProtocolClient;
import org.apache.tuweni.rlpx.wire.SubProtocolHandler;
import org.apache.tuweni.rlpx.wire.SubProtocolIdentifier;
import org.apache.tuweni.rlpx.wire.WireConnection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB3\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u001a\b\u0002\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\rH\u0016J\u0016\u0010\u0015\u001a\u0010\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00110\u00110\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0011H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/apache/tuweni/devp2p/eth/EthHelloSubprotocol;", "Lorg/apache/tuweni/rlpx/wire/SubProtocol;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "blockchainInfo", "Lorg/apache/tuweni/devp2p/eth/BlockchainInformation;", "listener", "Lkotlin/Function2;", "Lorg/apache/tuweni/rlpx/wire/WireConnection;", "Lorg/apache/tuweni/devp2p/eth/Status;", "", "(Lkotlin/coroutines/CoroutineContext;Lorg/apache/tuweni/devp2p/eth/BlockchainInformation;Lkotlin/jvm/functions/Function2;)V", "createClient", "Lorg/apache/tuweni/rlpx/wire/SubProtocolClient;", "service", "Lorg/apache/tuweni/rlpx/RLPxService;", "identifier", "Lorg/apache/tuweni/rlpx/wire/SubProtocolIdentifier;", "createHandler", "Lorg/apache/tuweni/rlpx/wire/SubProtocolHandler;", "client", "getCapabilities", "", "kotlin.jvm.PlatformType", "id", "supports", "", "subProtocolIdentifier", "Companion", "devp2p-eth"})
public final class EthHelloSubprotocol
implements SubProtocol {
    private final CoroutineContext coroutineContext;
    private final BlockchainInformation blockchainInfo;
    private final Function2<WireConnection, Status, Unit> listener;
    private static final SubProtocolIdentifier ETH62;
    private static final SubProtocolIdentifier ETH63;
    private static final SubProtocolIdentifier ETH64;
    private static final SubProtocolIdentifier ETH65;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public SubProtocolIdentifier id() {
        SubProtocolIdentifier subProtocolIdentifier = ETH65;
        Intrinsics.checkNotNullExpressionValue((Object)subProtocolIdentifier, (String)"ETH65");
        return subProtocolIdentifier;
    }

    public boolean supports(@NotNull SubProtocolIdentifier subProtocolIdentifier) {
        Intrinsics.checkNotNullParameter((Object)subProtocolIdentifier, (String)"subProtocolIdentifier");
        return "eth".equals(subProtocolIdentifier.name()) && (subProtocolIdentifier.version() == ETH62.version() || subProtocolIdentifier.version() == ETH63.version() || subProtocolIdentifier.version() == ETH64.version() || subProtocolIdentifier.version() == ETH65.version());
    }

    @NotNull
    public SubProtocolHandler createHandler(@NotNull RLPxService service, @NotNull SubProtocolClient client) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        EthHelloController controller = new EthHelloController(this.listener);
        return new EthHelloHandler(this.coroutineContext, this.blockchainInfo, service, controller);
    }

    @NotNull
    public List<SubProtocolIdentifier> getCapabilities() {
        return CollectionsKt.mutableListOf((Object[])new SubProtocolIdentifier[]{ETH62, ETH63, ETH64, ETH65});
    }

    @NotNull
    public SubProtocolClient createClient(@NotNull RLPxService service, @NotNull SubProtocolIdentifier identifier) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        return new EthHelloClient(service);
    }

    public EthHelloSubprotocol(@NotNull CoroutineContext coroutineContext, @NotNull BlockchainInformation blockchainInfo, @NotNull Function2<? super WireConnection, ? super Status, Unit> listener) {
        Intrinsics.checkNotNullParameter((Object)coroutineContext, (String)"coroutineContext");
        Intrinsics.checkNotNullParameter((Object)blockchainInfo, (String)"blockchainInfo");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.coroutineContext = coroutineContext;
        this.blockchainInfo = blockchainInfo;
        this.listener = listener;
    }

    public /* synthetic */ EthHelloSubprotocol(CoroutineContext coroutineContext, BlockchainInformation blockchainInformation, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            coroutineContext = (CoroutineContext)Dispatchers.getDefault();
        }
        if ((n & 4) != 0) {
            function2 = 1.INSTANCE;
        }
        this(coroutineContext, blockchainInformation, (Function2<? super WireConnection, ? super Status, Unit>)function2);
    }

    static {
        Companion = new Companion(null);
        ETH62 = SubProtocolIdentifier.of((String)"eth", (int)62, (int)8);
        ETH63 = SubProtocolIdentifier.of((String)"eth", (int)63, (int)17);
        ETH64 = SubProtocolIdentifier.of((String)"eth", (int)64, (int)17);
        ETH65 = SubProtocolIdentifier.of((String)"eth", (int)65, (int)17);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0019\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0019\u0010\f\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/apache/tuweni/devp2p/eth/EthHelloSubprotocol$Companion;", "", "()V", "ETH62", "Lorg/apache/tuweni/rlpx/wire/SubProtocolIdentifier;", "kotlin.jvm.PlatformType", "getETH62", "()Lorg/apache/tuweni/rlpx/wire/SubProtocolIdentifier;", "ETH63", "getETH63", "ETH64", "getETH64", "ETH65", "getETH65", "devp2p-eth"})
    public static final class Companion {
        public final SubProtocolIdentifier getETH62() {
            return ETH62;
        }

        public final SubProtocolIdentifier getETH63() {
            return ETH63;
        }

        public final SubProtocolIdentifier getETH64() {
            return ETH64;
        }

        public final SubProtocolIdentifier getETH65() {
            return ETH65;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

