/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.scuttlebutt.rpc.mux;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.concurrent.AsyncResult;
import org.apache.tuweni.concurrent.CompletableAsyncResult;
import org.apache.tuweni.scuttlebutt.handshake.vertx.ClientHandler;
import org.apache.tuweni.scuttlebutt.rpc.RPCAsyncRequest;
import org.apache.tuweni.scuttlebutt.rpc.RPCCodec;
import org.apache.tuweni.scuttlebutt.rpc.RPCFlag;
import org.apache.tuweni.scuttlebutt.rpc.RPCMessage;
import org.apache.tuweni.scuttlebutt.rpc.RPCResponse;
import org.apache.tuweni.scuttlebutt.rpc.RPCStreamRequest;
import org.apache.tuweni.scuttlebutt.rpc.mux.Multiplexer;
import org.apache.tuweni.scuttlebutt.rpc.mux.ScuttlebuttStreamHandler;
import org.apache.tuweni.scuttlebutt.rpc.mux.exceptions.ConnectionClosedException;
import org.apache.tuweni.scuttlebutt.rpc.mux.exceptions.RPCRequestFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RPCHandler
implements Multiplexer,
ClientHandler {
    private static final Logger logger = LoggerFactory.getLogger(RPCHandler.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final Consumer<Bytes> messageSender;
    private final Runnable connectionCloser;
    private final Vertx vertx;
    private Map<Integer, CompletableAsyncResult<RPCResponse>> awaitingAsyncResponse = new ConcurrentHashMap<Integer, CompletableAsyncResult<RPCResponse>>();
    private Map<Integer, ScuttlebuttStreamHandler> streams = new ConcurrentHashMap<Integer, ScuttlebuttStreamHandler>();
    private boolean closed;

    public RPCHandler(Vertx vertx, Consumer<Bytes> messageSender, Runnable terminationFn) {
        this.vertx = vertx;
        this.messageSender = messageSender;
        this.connectionCloser = terminationFn;
        this.closed = false;
    }

    @Override
    public AsyncResult<RPCResponse> makeAsyncRequest(RPCAsyncRequest request) throws JsonProcessingException {
        Bytes bodyBytes = request.toEncodedRpcMessage(objectMapper);
        CompletableAsyncResult result = AsyncResult.incomplete();
        Handler synchronizedAddRequest = event -> {
            if (this.closed) {
                result.completeExceptionally((Throwable)new ConnectionClosedException());
            } else {
                RPCMessage message = new RPCMessage(bodyBytes);
                int requestNumber = message.requestNumber();
                this.awaitingAsyncResponse.put(requestNumber, (CompletableAsyncResult<RPCResponse>)result);
                Bytes bytes = RPCCodec.encodeRequest(message.body(), requestNumber, request.getRPCFlags());
                this.logOutgoingRequest(message);
                this.sendBytes(bytes);
            }
        };
        this.vertx.runOnContext(synchronizedAddRequest);
        return result;
    }

    @Override
    public void openStream(RPCStreamRequest request, Function<Runnable, ScuttlebuttStreamHandler> responseSink) throws JsonProcessingException {
        Bytes bodyBytes = request.toEncodedRpcMessage(objectMapper);
        Handler synchronizedRequest = event -> {
            RPCFlag[] rpcFlags = request.getRPCFlags();
            RPCMessage message = new RPCMessage(bodyBytes);
            final int requestNumber = message.requestNumber();
            Bytes requestBytes = RPCCodec.encodeRequest(message.body(), requestNumber, rpcFlags);
            Runnable closeStreamHandler = () -> this.vertx.runOnContext((Handler)new Handler<Void>(){

                public void handle(Void event) {
                    RPCHandler.this.endStream(requestNumber);
                }
            });
            ScuttlebuttStreamHandler scuttlebuttStreamHandler = (ScuttlebuttStreamHandler)responseSink.apply(closeStreamHandler);
            if (this.closed) {
                scuttlebuttStreamHandler.onStreamError(new ConnectionClosedException());
            } else {
                this.streams.put(requestNumber, scuttlebuttStreamHandler);
                this.logOutgoingRequest(message);
                this.sendBytes(requestBytes);
            }
        };
        this.vertx.runOnContext(synchronizedRequest);
    }

    private void logOutgoingRequest(RPCMessage rpcMessage) {
        if (logger.isDebugEnabled()) {
            String requestString = rpcMessage.asString();
            String logMessage = String.format("[%d] Outgoing request: %s", rpcMessage.requestNumber(), requestString);
            logger.debug(logMessage);
        }
    }

    @Override
    public void close() {
        this.vertx.runOnContext(event -> this.connectionCloser.run());
    }

    public void receivedMessage(Bytes message) {
        Handler synchronizedHandleMessage = event -> {
            RPCMessage rpcMessage = new RPCMessage(message);
            if (rpcMessage.requestNumber() < 0) {
                this.handleResponse(rpcMessage);
            } else {
                this.handleRequest(rpcMessage);
            }
        };
        this.vertx.runOnContext(synchronizedHandleMessage);
    }

    public void streamClosed() {
        Handler synchronizedCloseStream = event -> {
            this.closed = true;
            this.streams.forEach((key, streamHandler) -> streamHandler.onStreamError(new ConnectionClosedException()));
            this.streams.clear();
            this.awaitingAsyncResponse.forEach((key, value) -> {
                if (!value.isDone()) {
                    value.completeExceptionally((Throwable)new ConnectionClosedException());
                }
            });
            this.awaitingAsyncResponse.clear();
        };
        this.vertx.runOnContext(synchronizedCloseStream);
    }

    private void handleRequest(RPCMessage rpcMessage) {
        logger.warn("Received incoming request, but we do not yet handle any requests: " + rpcMessage.asString());
    }

    private void handleResponse(RPCMessage response) {
        int requestNumber = response.requestNumber() * -1;
        if (logger.isDebugEnabled()) {
            String logMessage = String.format("[%d] incoming response: %s", requestNumber, response.asString());
            logger.debug(logMessage);
        }
        byte rpcFlags = response.rpcFlags();
        boolean isStream = RPCFlag.Stream.STREAM.isApplied(rpcFlags);
        Optional<RPCRequestFailedException> exception = response.getException(objectMapper);
        if (isStream) {
            ScuttlebuttStreamHandler scuttlebuttStreamHandler = this.streams.get(requestNumber);
            if (scuttlebuttStreamHandler != null) {
                if (response.isSuccessfulLastMessage()) {
                    this.endStream(requestNumber);
                } else if (exception.isPresent()) {
                    scuttlebuttStreamHandler.onStreamError(exception.get());
                } else {
                    RPCResponse successfulResponse = new RPCResponse(response.body(), response.bodyType());
                    scuttlebuttStreamHandler.onMessage(successfulResponse);
                }
            } else {
                logger.warn("Couldn't find stream handler for RPC response with request number " + requestNumber + " " + response.asString());
            }
        } else {
            CompletableAsyncResult<RPCResponse> rpcMessageFuture = this.awaitingAsyncResponse.remove(requestNumber);
            if (rpcMessageFuture != null) {
                if (exception.isPresent()) {
                    rpcMessageFuture.completeExceptionally((Throwable)exception.get());
                } else {
                    RPCResponse successfulResponse = new RPCResponse(response.body(), response.bodyType());
                    rpcMessageFuture.complete((Object)successfulResponse);
                }
            } else {
                logger.warn("Couldn't find async handler for RPC response with request number " + requestNumber + " " + response.asString());
            }
        }
    }

    private void sendBytes(Bytes bytes) {
        this.messageSender.accept(bytes);
    }

    private void endStream(int requestNumber) {
        try {
            ScuttlebuttStreamHandler streamHandler = this.streams.remove(requestNumber);
            if (streamHandler != null) {
                Bytes streamEnd = RPCCodec.encodeStreamEndRequest(requestNumber);
                streamHandler.onStreamEnd();
                if (logger.isDebugEnabled()) {
                    String logMessage = String.format("[%d] Sending close stream message.", requestNumber);
                    logger.debug(logMessage);
                }
                this.sendBytes(streamEnd);
            }
        }
        catch (JsonProcessingException e) {
            logger.warn("Unexpectedly could not encode stream end message to JSON.");
        }
    }
}

