/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.scuttlebutt.rpc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.scuttlebutt.rpc.RPCFlag;

public final class RPCCodec {
    static final AtomicInteger counter = new AtomicInteger(1);
    private static ObjectMapper mapper = new ObjectMapper();

    private static int nextRequestNumber() {
        int requestNumber = counter.getAndIncrement();
        if (requestNumber < 1) {
            counter.set(1);
            return 1;
        }
        return requestNumber;
    }

    public static Bytes encodeRequest(String body, RPCFlag ... flags) {
        return RPCCodec.encodeRequest(Bytes.wrap((byte[])body.getBytes(StandardCharsets.UTF_8)), RPCCodec.nextRequestNumber(), flags);
    }

    public static Bytes encodeRequest(Bytes body, RPCFlag ... flags) {
        return RPCCodec.encodeRequest(body, RPCCodec.nextRequestNumber(), flags);
    }

    public static Bytes encodeRequest(Bytes body, int requestNumber, RPCFlag ... flags) {
        if (requestNumber < 1) {
            throw new IllegalArgumentException("Invalid request number");
        }
        byte encodedFlags = 0;
        for (RPCFlag flag : flags) {
            encodedFlags = flag.apply(encodedFlags);
        }
        return Bytes.concatenate((Bytes[])new Bytes[]{Bytes.of((byte[])new byte[]{encodedFlags}), Bytes.ofUnsignedInt((long)body.size()), Bytes.ofUnsignedInt((long)requestNumber), body});
    }

    public static Bytes encodeRequest(Bytes body, int requestNumber, byte flags) {
        return Bytes.concatenate((Bytes[])new Bytes[]{Bytes.of((byte[])new byte[]{flags}), Bytes.ofUnsignedInt((long)body.size()), Bytes.ofUnsignedInt((long)requestNumber), body});
    }

    public static Bytes encodeResponse(Bytes body, int requestNumber, byte flagByte) {
        if (requestNumber < 1) {
            throw new IllegalArgumentException("Invalid request number");
        }
        return Bytes.concatenate((Bytes[])new Bytes[]{Bytes.of((byte[])new byte[]{flagByte}), Bytes.ofUnsignedInt((long)body.size()), Bytes.wrap((byte[])ByteBuffer.allocate(4).putInt(-requestNumber).array()), body});
    }

    public static Bytes encodeResponse(Bytes body, int requestNumber, byte flagByte, RPCFlag ... flags) {
        for (RPCFlag flag : flags) {
            flagByte = flag.apply(flagByte);
        }
        return RPCCodec.encodeResponse(body, requestNumber, flagByte);
    }

    public static Bytes encodeStreamEndRequest(int requestNumber) throws JsonProcessingException {
        Boolean bool = Boolean.TRUE;
        byte[] bytes = mapper.writeValueAsBytes((Object)bool);
        return RPCCodec.encodeRequest(Bytes.wrap((byte[])bytes), requestNumber, RPCFlag.EndOrError.END, RPCFlag.BodyType.JSON, RPCFlag.Stream.STREAM);
    }

    public static Bytes encodeResponse(Bytes body, int requestNumber, RPCFlag ... flags) {
        return RPCCodec.encodeResponse(body, requestNumber, (byte)0, flags);
    }
}

