/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.ethash;

import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.crypto.Hash;
import org.apache.tuweni.units.bigints.UInt32;

public class EthHash {
    public static int WORD_BYTES = 4;
    public static long DATASET_BYTES_INIT = (long)Math.pow(2.0, 30.0);
    public static long DATASET_BYTES_GROWTH = (long)Math.pow(2.0, 23.0);
    public static long CACHE_BYTES_INIT = (long)Math.pow(2.0, 24.0);
    public static long CACHE_BYTES_GROWTH = (long)Math.pow(2.0, 17.0);
    public static int CACHE_MULTIPLIER = 1024;
    public static int EPOCH_LENGTH = 30000;
    public static int MIX_BYTES = 128;
    public static int HASH_BYTES = 64;
    private static int HASH_WORDS = HASH_BYTES / WORD_BYTES;
    public static int DATASET_PARENTS = 256;
    public static int CACHE_ROUNDS = 3;
    public static int ACCESSES = 64;
    public static int FNV_PRIME = 16777619;

    public static Bytes hashimotoLight(long size, UInt32[] cache, Bytes header, Bytes nonce) {
        return EthHash.hashimoto(size, header, nonce, ind -> EthHash.calcDatasetItem(cache, ind));
    }

    private static Bytes hashimoto(long size, Bytes header, Bytes nonce, Function<UInt32, Bytes> datasetLookup) {
        long n = Long.divideUnsigned(size, MIX_BYTES);
        Bytes seed = Hash.keccak512((Bytes)Bytes.concatenate((Bytes[])new Bytes[]{header, nonce.reverse()}));
        Bytes[] mixBufferElts = new Bytes[MIX_BYTES / HASH_BYTES];
        for (int i2 = 0; i2 < MIX_BYTES / HASH_BYTES; ++i2) {
            mixBufferElts[i2] = seed;
        }
        Bytes mixBuffer = Bytes.concatenate((Bytes[])mixBufferElts);
        UInt32[] mix = new UInt32[MIX_BYTES / 4];
        for (int i3 = 0; i3 < MIX_BYTES / 4; ++i3) {
            mix[i3] = UInt32.fromBytes((Bytes)mixBuffer.slice(i3 * 4, 4), (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        }
        UInt32 firstSeed = mix[0];
        for (int i4 = 0; i4 < ACCESSES; ++i4) {
            UInt32 fnvValue = EthHash.fnv(firstSeed.xor(i4), mix[i4 % (MIX_BYTES / WORD_BYTES)]);
            UInt32 p = fnvValue.mod((int)n);
            ArrayList<UInt32> cache = new ArrayList<UInt32>();
            for (int j = 0; j < MIX_BYTES / HASH_BYTES; ++j) {
                Bytes lookupResult = datasetLookup.apply(p.multiply(2).add(j));
                for (int k = 0; k < lookupResult.size() / 4; ++k) {
                    cache.add(UInt32.fromBytes((Bytes)lookupResult.slice(k * 4, 4), (ByteOrder)ByteOrder.LITTLE_ENDIAN));
                }
            }
            for (int k = 0; k < mix.length; ++k) {
                mix[k] = EthHash.fnv(mix[k], (UInt32)cache.get(k));
            }
        }
        Stream<Bytes> part1 = IntStream.range(0, mix.length / 4).parallel().mapToObj(i -> {
            int index = i * 4;
            return EthHash.fnv(EthHash.fnv(EthHash.fnv(mix[index], mix[index + 1]), mix[index + 2]), mix[index + 3]).toBytes().reverse();
        });
        Bytes resultPart1 = Bytes.concatenate((Bytes[])((Bytes[])part1.toArray(Bytes[]::new)));
        Bytes32 resultPart2 = Hash.keccak256((Bytes)Bytes.concatenate((Bytes[])new Bytes[]{seed, resultPart1}));
        return Bytes.concatenate((Bytes[])new Bytes[]{resultPart1, resultPart2});
    }

    public static long epoch(long block) {
        return block / (long)EPOCH_LENGTH;
    }

    public static int getCacheSize(long block_number) {
        long sz = CACHE_BYTES_INIT + CACHE_BYTES_GROWTH * (block_number / (long)EPOCH_LENGTH);
        sz -= (long)HASH_BYTES;
        while (!EthHash.isPrime(sz / (long)HASH_BYTES)) {
            sz -= (long)(2 * HASH_BYTES);
        }
        return (int)sz;
    }

    public static long getFullSize(long block_number) {
        long sz = DATASET_BYTES_INIT + DATASET_BYTES_GROWTH * (block_number / (long)EPOCH_LENGTH);
        sz -= (long)MIX_BYTES;
        while (!EthHash.isPrime(sz / (long)MIX_BYTES)) {
            sz -= (long)(2 * MIX_BYTES);
        }
        return sz;
    }

    public static UInt32[] mkCache(int cacheSize, long block) {
        int rows = cacheSize / HASH_BYTES;
        ArrayList<Bytes> cache = new ArrayList<Bytes>(rows);
        cache.add(Hash.keccak512((Bytes)EthHash.dagSeed(block)));
        for (int i = 1; i < rows; ++i) {
            cache.add(Hash.keccak512((Bytes)((Bytes)cache.get(i - 1))));
        }
        Bytes completeCache = Bytes.concatenate((Bytes[])cache.toArray(new Bytes[cache.size()]));
        byte[] temp = new byte[HASH_BYTES];
        for (int i = 0; i < CACHE_ROUNDS; ++i) {
            for (int j = 0; j < rows; ++j) {
                int offset = j * HASH_BYTES;
                for (int k = 0; k < HASH_BYTES; ++k) {
                    temp[k] = (byte)(completeCache.get((j - 1 + rows) % rows * HASH_BYTES + k) ^ completeCache.get(Integer.remainderUnsigned(completeCache.getInt(offset, ByteOrder.LITTLE_ENDIAN), rows) * HASH_BYTES + k));
                }
                temp = Hash.keccak512((byte[])temp);
                System.arraycopy(temp, 0, completeCache.toArrayUnsafe(), offset, HASH_BYTES);
            }
        }
        UInt32[] result = new UInt32[completeCache.size() / 4];
        for (int i = 0; i < result.length; ++i) {
            result[i] = UInt32.fromBytes((Bytes)completeCache.slice(i * 4, 4).reverse());
        }
        return result;
    }

    public static Bytes calcDatasetItem(UInt32[] cache, UInt32 index) {
        int i;
        int rows = cache.length / HASH_WORDS;
        UInt32[] mixInts = new UInt32[HASH_BYTES / 4];
        int offset = index.mod(rows).multiply(HASH_WORDS).intValue();
        mixInts[0] = cache[offset].xor(index);
        System.arraycopy(cache, offset + 1, mixInts, 1, HASH_WORDS - 1);
        Bytes buffer = EthHash.intToByte(mixInts);
        buffer = Hash.keccak512((Bytes)buffer);
        for (i = 0; i < mixInts.length; ++i) {
            mixInts[i] = UInt32.fromBytes((Bytes)buffer.slice(i * 4, 4).reverse());
        }
        for (i = 0; i < DATASET_PARENTS; ++i) {
            EthHash.fnvHash(mixInts, cache, EthHash.fnv(index.xor(UInt32.valueOf((int)i)), mixInts[i % 16]).mod(UInt32.valueOf((int)rows)).multiply(UInt32.valueOf((int)HASH_WORDS)));
        }
        return Hash.keccak512((Bytes)EthHash.intToByte(mixInts));
    }

    private static Bytes dagSeed(long block) {
        Bytes32 seed = Bytes32.wrap((byte[])new byte[32]);
        if (Long.compareUnsigned(block, EPOCH_LENGTH) >= 0) {
            int i = 0;
            while ((long)i < Long.divideUnsigned(block, EPOCH_LENGTH)) {
                seed = Hash.keccak256((Bytes)seed);
                ++i;
            }
        }
        return seed;
    }

    private static UInt32 fnv(UInt32 v1, UInt32 v2) {
        return v1.multiply(FNV_PRIME).xor(v2);
    }

    private static void fnvHash(UInt32[] mix, UInt32[] cache, UInt32 offset) {
        for (int i = 0; i < mix.length; ++i) {
            mix[i] = EthHash.fnv(mix[i], cache[offset.intValue() + i]);
        }
    }

    private static Bytes intToByte(UInt32[] ints) {
        return Bytes.concatenate((Bytes[])((Bytes[])Stream.of(ints).map(i -> i.toBytes().reverse()).toArray(Bytes[]::new)));
    }

    private static boolean isPrime(long number) {
        return number > 2L && IntStream.rangeClosed(2, (int)Math.sqrt(number)).noneMatch(n -> number % (long)n == 0L);
    }
}

