/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.stratum.server;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.stratum.server.JsonRpcRequest;
import org.apache.tuweni.stratum.server.JsonRpcSuccessResponse;
import org.apache.tuweni.stratum.server.PoWInput;
import org.apache.tuweni.stratum.server.PoWSolution;
import org.apache.tuweni.stratum.server.StratumConnection;
import org.apache.tuweni.stratum.server.StratumProtocol;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 !2\u00020\u0001:\u0001!BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0010H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\u0018\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u001aH\u0002J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u0010H\u0016J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0012H\u0016R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/apache/tuweni/stratum/server/Stratum1Protocol;", "Lorg/apache/tuweni/stratum/server/StratumProtocol;", "extranonce", "", "jobIdSupplier", "Lkotlin/Function0;", "subscriptionIdCreator", "submitCallback", "Lkotlin/Function1;", "Lorg/apache/tuweni/stratum/server/PoWSolution;", "", "seedSupplier", "Lorg/apache/tuweni/bytes/Bytes32;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "activeConnections", "", "Lorg/apache/tuweni/stratum/server/StratumConnection;", "currentInput", "Lorg/apache/tuweni/stratum/server/PoWInput;", "canHandle", "initialMessage", "conn", "handle", "", "message", "handleMiningAuthorize", "Lorg/apache/tuweni/stratum/server/JsonRpcRequest;", "handleMiningSubmit", "onClose", "registerConnection", "sendNewWork", "setCurrentWorkTask", "input", "Companion", "server"})
public final class Stratum1Protocol
implements StratumProtocol {
    private PoWInput currentInput;
    private final List<StratumConnection> activeConnections;
    private final String extranonce;
    private final Function0<String> jobIdSupplier;
    private final Function0<String> subscriptionIdCreator;
    private final Function1<PoWSolution, Boolean> submitCallback;
    private final Function0<Bytes32> seedSupplier;
    private static final Logger logger;
    private static final JsonMapper mapper;
    private static final String STRATUM_1;
    @NotNull
    public static final Companion Companion;

    @Override
    public boolean canHandle(@NotNull String initialMessage, @NotNull StratumConnection conn2) {
        Intrinsics.checkNotNullParameter((Object)initialMessage, (String)"initialMessage");
        Intrinsics.checkNotNullParameter((Object)conn2, (String)"conn");
        if (!StringsKt.contains$default((CharSequence)initialMessage, (CharSequence)"mining.subscribe", (boolean)false, (int)2, null)) {
            logger.debug("Invalid first message method: {}", (Object)initialMessage);
            return false;
        }
        JsonRpcRequest requestBody = null;
        try {
            Object object = mapper.readValue(initialMessage, JsonRpcRequest.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mapper.readValue(initial\u2026onRpcRequest::class.java)");
            requestBody = (JsonRpcRequest)object;
        }
        catch (JsonProcessingException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return false;
        }
        try {
            String notify = mapper.writeValueAsString((Object)new JsonRpcSuccessResponse(requestBody.getId(), null, CollectionsKt.mutableListOf((Object[])new Object[]{CollectionsKt.mutableListOf((Object[])new String[]{"mining.notify", (String)this.subscriptionIdCreator.invoke(), STRATUM_1}), this.extranonce}), 2, null));
            conn2.send(notify + "\n");
        }
        catch (JsonProcessingException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            conn2.close();
        }
        return true;
    }

    private final void registerConnection(StratumConnection conn2) {
        this.activeConnections.add(conn2);
        if (this.currentInput != null) {
            this.sendNewWork(conn2);
        }
    }

    private final void sendNewWork(StratumConnection conn2) {
        PoWInput poWInput = this.currentInput;
        if (poWInput == null) {
            return;
        }
        PoWInput input = poWInput;
        Object[] objectArray = new Object[5];
        objectArray[0] = this.jobIdSupplier.invoke();
        String string = Bytes.wrap((Bytes[])new Bytes[]{input.getPrePowHash()}).toHexString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Bytes.wrap(input.prePowHash).toHexString()");
        objectArray[1] = string;
        String string2 = ((Bytes32)this.seedSupplier.invoke()).toHexString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"seedSupplier().toHexString()");
        objectArray[2] = string2;
        String string3 = input.getTarget().toBytes().toHexString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"input.target.toBytes().toHexString()");
        objectArray[3] = string3;
        objectArray[4] = true;
        List params = CollectionsKt.mutableListOf((Object[])objectArray);
        JsonRpcRequest req = new JsonRpcRequest("2.0", "mining.notify", params, "32");
        try {
            conn2.send(mapper.writeValueAsString((Object)req) + "\n");
        }
        catch (JsonProcessingException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void onClose(@NotNull StratumConnection conn2) {
        Intrinsics.checkNotNullParameter((Object)conn2, (String)"conn");
        this.activeConnections.remove(conn2);
    }

    @Override
    public void handle(@NotNull StratumConnection conn2, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)conn2, (String)"conn");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        try {
            Object object = mapper.readValue(message, JsonRpcRequest.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mapper.readValue(message\u2026onRpcRequest::class.java)");
            JsonRpcRequest req = (JsonRpcRequest)object;
            if (Intrinsics.areEqual((Object)"mining.authorize", (Object)req.getMethod())) {
                this.handleMiningAuthorize(conn2, req);
            } else if (Intrinsics.areEqual((Object)"mining.submit", (Object)req.getMethod())) {
                this.handleMiningSubmit(conn2, req);
            }
        }
        catch (JsonProcessingException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            conn2.close();
        }
        catch (IOException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            conn2.close();
        }
    }

    private final void handleMiningSubmit(StratumConnection conn2, JsonRpcRequest message) {
        block1: {
            logger.debug("Miner submitted solution {}", (Object)message);
            PoWSolution solution = new PoWSolution(message.bytes(2).getLong(0), message.bytes32(4), null, message.bytes(3));
            PoWInput poWInput = this.currentInput;
            if (poWInput == null || (poWInput = poWInput.getPrePowHash()) == null) break block1;
            boolean bl = ((Object)poWInput).equals(solution.getPowHash());
            boolean bl2 = false;
            boolean bl3 = false;
            boolean it = bl;
            boolean bl4 = false;
            if (it) {
                boolean result = (Boolean)this.submitCallback.invoke((Object)solution);
                String response = mapper.writeValueAsString((Object)new JsonRpcSuccessResponse(message.getId(), null, result, 2, null));
                conn2.send(response + "\n");
            }
        }
    }

    private final void handleMiningAuthorize(StratumConnection conn2, JsonRpcRequest message) throws IOException {
        String confirm = mapper.writeValueAsString((Object)new JsonRpcSuccessResponse(message.getId(), null, true, 2, null));
        conn2.send(confirm + "\n");
        this.registerConnection(conn2);
    }

    @Override
    public void setCurrentWorkTask(@NotNull PoWInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.currentInput = input;
        logger.debug("Sending new work to miners: {}", (Object)input);
        for (StratumConnection conn2 : this.activeConnections) {
            this.sendNewWork(conn2);
        }
    }

    public Stratum1Protocol(@NotNull String extranonce, @NotNull Function0<String> jobIdSupplier, @NotNull Function0<String> subscriptionIdCreator, @NotNull Function1<? super PoWSolution, Boolean> submitCallback, @NotNull Function0<? extends Bytes32> seedSupplier) {
        Intrinsics.checkNotNullParameter((Object)extranonce, (String)"extranonce");
        Intrinsics.checkNotNullParameter(jobIdSupplier, (String)"jobIdSupplier");
        Intrinsics.checkNotNullParameter(subscriptionIdCreator, (String)"subscriptionIdCreator");
        Intrinsics.checkNotNullParameter(submitCallback, (String)"submitCallback");
        Intrinsics.checkNotNullParameter(seedSupplier, (String)"seedSupplier");
        this.extranonce = extranonce;
        this.jobIdSupplier = jobIdSupplier;
        this.subscriptionIdCreator = subscriptionIdCreator;
        this.submitCallback = submitCallback;
        this.seedSupplier = seedSupplier;
        this.activeConnections = new ArrayList();
    }

    public /* synthetic */ Stratum1Protocol(String string, Function0 function0, Function0 function02, Function1 function1, Function0 function03, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function0 = 1.INSTANCE;
        }
        if ((n & 4) != 0) {
            function02 = 2.INSTANCE;
        }
        this(string, (Function0<String>)function0, (Function0<String>)function02, (Function1<? super PoWSolution, Boolean>)function1, (Function0<? extends Bytes32>)function03);
    }

    static {
        Companion = new Companion(null);
        logger = LoggerFactory.getLogger(Stratum1Protocol.class);
        mapper = new JsonMapper();
        STRATUM_1 = "EthereumStratum/1.0.0";
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/apache/tuweni/stratum/server/Stratum1Protocol$Companion;", "", "()V", "STRATUM_1", "", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "mapper", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "createSubscriptionID", "server"})
    public static final class Companion {
        private final String createSubscriptionID() {
            byte[] subscriptionBytes = new byte[16];
            new Random().nextBytes(subscriptionBytes);
            String string = Bytes.wrap((byte[])subscriptionBytes).toShortHexString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Bytes.wrap(subscriptionBytes).toShortHexString()");
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

