/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.ethclient;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.NoSuchFileException;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.tuweni.config.Configuration;
import org.apache.tuweni.config.Schema;
import org.apache.tuweni.config.SchemaBuilder;
import org.apache.tuweni.ethclient.DNSConfiguration;
import org.apache.tuweni.ethclient.DNSConfigurationImpl;
import org.apache.tuweni.ethclient.DataStoreConfiguration;
import org.apache.tuweni.ethclient.DataStoreConfigurationImpl;
import org.apache.tuweni.ethclient.GenesisFileConfiguration;
import org.apache.tuweni.ethclient.GenesisFileConfigurationImpl;
import org.apache.tuweni.ethclient.PeerRepositoryConfiguration;
import org.apache.tuweni.ethclient.PeerRepositoryConfigurationImpl;
import org.apache.tuweni.ethclient.RLPxServiceConfiguration;
import org.apache.tuweni.ethclient.RLPxServiceConfigurationImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0006J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006J\u000e\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/apache/tuweni/ethclient/EthereumClientConfig;", "", "config", "Lorg/apache/tuweni/config/Configuration;", "(Lorg/apache/tuweni/config/Configuration;)V", "dataStores", "", "Lorg/apache/tuweni/ethclient/DataStoreConfiguration;", "dnsClients", "Lorg/apache/tuweni/ethclient/DNSConfiguration;", "genesisFiles", "Lorg/apache/tuweni/ethclient/GenesisFileConfiguration;", "peerRepositories", "Lorg/apache/tuweni/ethclient/PeerRepositoryConfiguration;", "rlpxServices", "Lorg/apache/tuweni/ethclient/RLPxServiceConfiguration;", "toToml", "", "kotlin.jvm.PlatformType", "Companion", "eth-client"})
public final class EthereumClientConfig {
    private Configuration config;
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DataStoreConfiguration> dataStores() {
        void $this$mapTo$iv$iv;
        Set storageSections = this.config.sections("storage");
        if (storageSections == null || storageSections.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = storageSections;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void section;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Configuration sectionConfig = this.config.getConfigurationSection("storage." + (String)section);
            void v0 = section;
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"section");
            Path path = Paths.get(sectionConfig.getString("path"), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(sectionConfig.getString(\"path\"))");
            String string2 = sectionConfig.getString("genesis");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sectionConfig.getString(\"genesis\")");
            DataStoreConfigurationImpl dataStoreConfigurationImpl = new DataStoreConfigurationImpl((String)v0, path, string2);
            collection.add(dataStoreConfigurationImpl);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<RLPxServiceConfiguration> rlpxServices() {
        return CollectionsKt.listOf((Object)new RLPxServiceConfigurationImpl());
    }

    @NotNull
    public final List<GenesisFileConfiguration> genesisFiles() {
        return CollectionsKt.listOf((Object)new GenesisFileConfigurationImpl());
    }

    @NotNull
    public final List<PeerRepositoryConfiguration> peerRepositories() {
        return CollectionsKt.listOf((Object)new PeerRepositoryConfigurationImpl("default"));
    }

    public final String toToml() {
        return this.config.toToml();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DNSConfiguration> dnsClients() {
        void $this$mapTo$iv$iv;
        Set dnsSections = this.config.sections("dns");
        if (dnsSections == null || dnsSections.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = dnsSections;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void section;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Configuration sectionConfig = this.config.getConfigurationSection("dns." + (String)section);
            void v0 = section;
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"section");
            String string2 = sectionConfig.getString("peerRepository");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sectionConfig.getString(\"peerRepository\")");
            String string3 = sectionConfig.getString("enrLink");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"sectionConfig.getString(\"enrLink\")");
            DNSConfigurationImpl dNSConfigurationImpl = new DNSConfigurationImpl((String)v0, string2, string3, sectionConfig.getLong("pollingPeriod"));
            collection.add(dNSConfigurationImpl);
        }
        return (List)destination$iv$iv;
    }

    public EthereumClientConfig(@NotNull Configuration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
    }

    public /* synthetic */ EthereumClientConfig(Configuration configuration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Configuration configuration2 = Configuration.empty((Schema)Companion.createSchema());
            Intrinsics.checkNotNullExpressionValue((Object)configuration2, (String)"Configuration.empty(createSchema())");
            configuration = configuration2;
        }
        this(configuration);
    }

    public EthereumClientConfig() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lorg/apache/tuweni/ethclient/EthereumClientConfig$Companion;", "", "()V", "createSchema", "Lorg/apache/tuweni/config/Schema;", "empty", "Lorg/apache/tuweni/ethclient/EthereumClientConfig;", "fromFile", "path", "Ljava/nio/file/Path;", "fromString", "config", "", "eth-client"})
    public static final class Companion {
        @NotNull
        public final Schema createSchema() {
            SchemaBuilder storageSection = SchemaBuilder.create();
            storageSection.addString("path", null, "File system path where data is stored", null);
            storageSection.addString("genesis", null, "Reference to a genesis configuration", null);
            SchemaBuilder dnsSection = SchemaBuilder.create();
            dnsSection.addString("enrLink", null, "DNS domain to query for records", null);
            dnsSection.addLong("pollingPeriod", Long.valueOf(50000L), "Polling period to refresh DNS records", null);
            dnsSection.addString("peerRepository", "default", "Peer repository to which records should go", null);
            SchemaBuilder builder = SchemaBuilder.create();
            builder.addSection("storage", storageSection.toSchema());
            builder.addSection("dns", dnsSection.toSchema());
            Schema schema = builder.toSchema();
            Intrinsics.checkNotNullExpressionValue((Object)schema, (String)"builder.toSchema()");
            return schema;
        }

        @NotNull
        public final EthereumClientConfig fromFile(@Nullable Path path) {
            if (path == null) {
                return this.empty();
            }
            try {
                File file = path.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"path.toFile()");
                return this.fromString(FilesKt.readText$default((File)file, null, (int)1, null));
            }
            catch (Exception e) {
                Exception exception = e;
                if (exception instanceof NoSuchFileException || exception instanceof FileNotFoundException) {
                    throw (Throwable)new IllegalArgumentException("Missing config file: '" + path + '\'');
                }
                throw (Throwable)e;
            }
        }

        @NotNull
        public final EthereumClientConfig fromString(@NotNull String config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Configuration configuration = Configuration.fromToml((String)config, (Schema)this.createSchema());
            Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"Configuration.fromToml(config, createSchema())");
            return new EthereumClientConfig(configuration);
        }

        @NotNull
        public final EthereumClientConfig empty() {
            URL uRL = EthereumClientConfig.class.getResource("/default.toml");
            Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"EthereumClientConfig::cl\u2026Resource(\"/default.toml\")");
            URL uRL2 = uRL;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
            boolean bl2 = false;
            boolean bl3 = false;
            return this.fromString(new String(byArray, charset));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

