/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.wallet;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.crypto.Hash;
import org.apache.tuweni.crypto.SECP256K1;
import org.apache.tuweni.crypto.sodium.AES256GCM;
import org.apache.tuweni.eth.Address;
import org.apache.tuweni.eth.Transaction;
import org.apache.tuweni.units.bigints.UInt256;
import org.apache.tuweni.units.ethereum.Gas;
import org.apache.tuweni.units.ethereum.Wei;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\t\u001a\u00020\nJG\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\u0002\u0010\u0019J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/apache/tuweni/wallet/Wallet;", "", "file", "Ljava/nio/file/Path;", "password", "", "(Ljava/nio/file/Path;Ljava/lang/String;)V", "keyPair", "Lorg/apache/tuweni/crypto/SECP256K1$KeyPair;", "address", "Lorg/apache/tuweni/eth/Address;", "sign", "Lorg/apache/tuweni/eth/Transaction;", "nonce", "Lorg/apache/tuweni/units/bigints/UInt256;", "gasPrice", "Lorg/apache/tuweni/units/ethereum/Wei;", "gasLimit", "Lorg/apache/tuweni/units/ethereum/Gas;", "to", "value", "payload", "Lorg/apache/tuweni/bytes/Bytes;", "chainId", "", "(Lorg/apache/tuweni/units/bigints/UInt256;Lorg/apache/tuweni/units/ethereum/Wei;Lorg/apache/tuweni/units/ethereum/Gas;Lorg/apache/tuweni/eth/Address;Lorg/apache/tuweni/units/ethereum/Wei;Lorg/apache/tuweni/bytes/Bytes;Ljava/lang/Integer;)Lorg/apache/tuweni/eth/Transaction;", "verify", "", "tx", "Companion", "wallet"})
public final class Wallet {
    private final SECP256K1.KeyPair keyPair;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Transaction sign(@NotNull UInt256 nonce, @NotNull Wei gasPrice, @NotNull Gas gasLimit, @Nullable Address to, @NotNull Wei value, @NotNull Bytes payload, @Nullable Integer chainId) {
        Intrinsics.checkNotNullParameter((Object)nonce, (String)"nonce");
        Intrinsics.checkNotNullParameter((Object)gasPrice, (String)"gasPrice");
        Intrinsics.checkNotNullParameter((Object)gasLimit, (String)"gasLimit");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        return new Transaction(nonce, gasPrice, gasLimit, to, value, payload, this.keyPair, chainId);
    }

    public final boolean verify(@NotNull Transaction tx) {
        Intrinsics.checkNotNullParameter((Object)tx, (String)"tx");
        SECP256K1.PublicKey pubKey = tx.extractPublicKey();
        return Intrinsics.areEqual((Object)this.keyPair.publicKey(), (Object)pubKey);
    }

    @NotNull
    public final Address address() {
        Address address = Address.fromPublicKey((SECP256K1.PublicKey)this.keyPair.publicKey());
        Intrinsics.checkNotNullExpressionValue((Object)address, (String)"Address.fromPublicKey(keyPair.publicKey())");
        return address;
    }

    public Wallet(@NotNull Path file, @NotNull String password) {
        Bytes decrypted;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        String string = Files.readString(file);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Files.readString(file)");
        String string2 = string;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String contents = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        Bytes encrypted = Bytes.fromHexString((CharSequence)contents);
        String string4 = password;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"StandardCharsets.UTF_8");
        Charset charset2 = charset;
        boolean bl2 = false;
        byte[] byArray = string4.getBytes(charset2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] hash = Hash.sha2_256((byte[])byArray);
        Bytes nonceBytes = Hash.sha2_256((Bytes)Bytes.wrap((Bytes[])new Bytes[]{Bytes.wrap((byte[])hash), Bytes.fromHexString((CharSequence)"0A00E0")})).slice(0, 12);
        AES256GCM.Key key = AES256GCM.Key.fromBytes((byte[])hash);
        AES256GCM.Nonce nonce = AES256GCM.Nonce.fromBytes((Bytes)nonceBytes);
        Bytes bytes = decrypted = AES256GCM.decrypt((Bytes)encrypted, (AES256GCM.Key)key, (AES256GCM.Nonce)nonce);
        Intrinsics.checkNotNull((Object)bytes);
        SECP256K1.KeyPair keyPair = SECP256K1.KeyPair.fromSecretKey((SECP256K1.SecretKey)SECP256K1.SecretKey.fromBytes((Bytes32)Bytes32.secure((byte[])bytes.toArrayUnsafe())));
        Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"SECP256K1.KeyPair.fromSe\u2026toArrayUnsafe()))\n      )");
        this.keyPair = keyPair;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\n"}, d2={"Lorg/apache/tuweni/wallet/Wallet$Companion;", "", "()V", "create", "Lorg/apache/tuweni/wallet/Wallet;", "file", "Ljava/nio/file/Path;", "password", "", "open", "wallet"})
    public static final class Companion {
        @NotNull
        public final Wallet create(@NotNull Path file, @NotNull String password) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            String string = password;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"StandardCharsets.UTF_8");
            Charset charset2 = charset;
            boolean bl = false;
            byte[] byArray = string.getBytes(charset2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] hash = Hash.sha2_256((byte[])byArray);
            Bytes nonceBytes = Hash.sha2_256((Bytes)Bytes.wrap((Bytes[])new Bytes[]{Bytes.wrap((byte[])hash), Bytes.fromHexString((CharSequence)"0A00E0")})).slice(0, 12);
            AES256GCM.Key key = AES256GCM.Key.fromBytes((byte[])hash);
            AES256GCM.Nonce nonce = AES256GCM.Nonce.fromBytes((Bytes)nonceBytes);
            Bytes encrypted = AES256GCM.encrypt((Bytes)((Bytes)Bytes32.random()), (Bytes)Bytes.EMPTY, (AES256GCM.Key)key, (AES256GCM.Nonce)nonce);
            file.getParent().toFile().mkdirs();
            String string2 = encrypted.toHexString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encrypted.toHexString()");
            Files.write(file, StringsKt.encodeToByteArray((String)string2), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
            return this.open(file, password);
        }

        @NotNull
        public final Wallet open(@NotNull Path file, @NotNull String password) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            return new Wallet(file, password);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

