/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.io;

import java.util.Arrays;

class Base58Codec {
    private static final byte[] ENCODE_TABLE = new byte[]{49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 74, 75, 76, 77, 78, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
    private static final byte[] DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, -1, -1, -1, -1, -1, -1, -1, 9, 10, 11, 12, 13, 14, 15, 16, -1, 17, 18, 19, 20, 21, -1, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, -1, -1, -1, -1, -1, -1, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, -1, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};

    Base58Codec() {
    }

    static byte[] encode(byte[] decoded) {
        byte[] input = Arrays.copyOf(decoded, decoded.length);
        byte[] encoded = new byte[input.length * 2];
        int inputStart = 0;
        int outputStart = encoded.length;
        int zeros = 0;
        while (inputStart < input.length) {
            if (input[inputStart] == 0 && outputStart == encoded.length) {
                ++zeros;
                ++inputStart;
                continue;
            }
            int remainder = 0;
            for (int i = 0; i < input.length; ++i) {
                int digit = input[i] & 0xFF;
                int temp = remainder * 256 + digit;
                input[i] = (byte)(temp / 58);
                remainder = temp % 58;
            }
            encoded[--outputStart] = ENCODE_TABLE[remainder];
            if (input[inputStart] != 0) continue;
            ++inputStart;
        }
        Arrays.fill(encoded, outputStart - zeros, outputStart, ENCODE_TABLE[0]);
        return Arrays.copyOfRange(encoded, outputStart - zeros, encoded.length);
    }

    static byte[] decode(String encoded) {
        byte[] input = new byte[encoded.length()];
        byte[] decoded = new byte[input.length];
        for (int i = 0; i < input.length; ++i) {
            input[i] = DECODE_TABLE[encoded.charAt(i)];
            if (input[i] != -1) continue;
            throw new IllegalArgumentException("Invalid character " + encoded.charAt(i));
        }
        int inputStart = 0;
        int outputStart = input.length;
        int zeros = 0;
        while (inputStart < input.length) {
            if (input[inputStart] == 0 && outputStart == input.length) {
                ++zeros;
                ++inputStart;
                continue;
            }
            int remainder = 0;
            for (int i = 0; i < input.length; ++i) {
                int digit = input[i] & 0xFF;
                int temp = remainder * 58 + digit;
                input[i] = (byte)(temp / 256);
                remainder = temp % 256;
            }
            decoded[--outputStart] = (byte)remainder;
            if (input[inputStart] != 0) continue;
            ++inputStart;
        }
        Arrays.fill(decoded, outputStart - zeros, outputStart, (byte)0);
        return Arrays.copyOfRange(decoded, outputStart - zeros, decoded.length);
    }
}

