/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.serializer;

import java.io.IOException;
import java.io.Writer;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.standard.serializer.IStandardCSSSerializer;
import org.unbescape.css.CssEscape;

public final class StandardCSSSerializer
implements IStandardCSSSerializer {
    @Override
    public void serializeValue(Object object, Writer writer) {
        try {
            StandardCSSSerializer.writeValue(writer, object);
        }
        catch (IOException e) {
            throw new TemplateProcessingException("An exception was raised while trying to serialize object to CSS", e);
        }
    }

    private static void writeValue(Writer writer, Object object) throws IOException {
        if (object == null) {
            StandardCSSSerializer.writeNull(writer);
            return;
        }
        if (object instanceof CharSequence) {
            StandardCSSSerializer.writeString(writer, object.toString());
            return;
        }
        if (object instanceof Character) {
            StandardCSSSerializer.writeString(writer, object.toString());
            return;
        }
        if (object instanceof Number) {
            StandardCSSSerializer.writeNumber(writer, (Number)object);
            return;
        }
        if (object instanceof Boolean) {
            StandardCSSSerializer.writeBoolean(writer, (Boolean)object);
            return;
        }
        StandardCSSSerializer.writeString(writer, object.toString());
    }

    private static void writeNull(Writer writer) throws IOException {
        writer.write("");
    }

    private static void writeString(Writer writer, String str) throws IOException {
        writer.write(CssEscape.escapeCssIdentifier((String)str));
    }

    private static void writeNumber(Writer writer, Number number) throws IOException {
        writer.write(number.toString());
    }

    private static void writeBoolean(Writer writer, Boolean bool) throws IOException {
        writer.write(bool.toString());
    }
}

